/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.tasks;

import com.gridnine.xtrip.client.fx.core.service.RootEntityEditingService;
import com.gridnine.xtrip.client.fx.core.tasks.ClientTask;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.fx.rpc.BaseItineraryReceiptProperties;
import com.gridnine.xtrip.common.fx.rpc.BookingFileService;
import com.gridnine.xtrip.common.fx.rpc.EntityService;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceException;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import java.io.ByteArrayInputStream;
import java.util.HashMap;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.standard.DialogTypeSelection;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.export.JRPrintServiceExporter;
import net.sf.jasperreports.engine.export.JRPrintServiceExporterParameter;

public abstract class BaseItineraryReceiptTask<T extends BaseItineraryReceiptProperties>
extends ClientTask {
    protected final T properties;

    protected BaseItineraryReceiptTask(T properties) {
        this.properties = properties;
    }

    protected void execute() throws Exception {
        try {
            BookingFileService.ItineraryReceiptRPCResult result = this.createItineraryReceipts();
            ServiceInvocationContext sic = ServiceInvocationContext.get();
            EntityService entityService = (EntityService)RpcServiceManager.get().getService(EntityService.class);
            result.getDocuments().forEach(doc -> {
                EntityContainer docCont = EntityContainer.create((BaseEntity)doc);
                try {
                    docCont.getVersionInfo().setDataSource("fx-itn-receipt-task");
                    entityService.save(sic, docCont, null, true);
                }
                catch (ServiceException e) {
                    ErrorHandler.handle((Throwable)e);
                }
                if (this.properties.isPrint()) {
                    try {
                        JRPrintServiceExporter exporter = new JRPrintServiceExporter();
                        HashMap<Object, Object> exporterParameters = new HashMap<Object, Object>();
                        HashPrintRequestAttributeSet requestAttributes = new HashPrintRequestAttributeSet();
                        requestAttributes.add(DialogTypeSelection.COMMON);
                        exporterParameters.put(JRPrintServiceExporterParameter.PRINT_REQUEST_ATTRIBUTE_SET, requestAttributes);
                        exporterParameters.put(JRPrintServiceExporterParameter.INPUT_STREAM, new ByteArrayInputStream(doc.getContent()));
                        exporterParameters.put(JRPrintServiceExporterParameter.DISPLAY_PRINT_DIALOG, true);
                        exporter.setParameters(exporterParameters);
                        exporter.exportReport();
                    }
                    catch (JRException e) {
                        ErrorHandler.handle((Throwable)e);
                    }
                } else {
                    RootEntityEditingService.navigateTo((EntityReference)docCont.toReference());
                }
            });
            this.addMessages(result.getResultMessageList());
        }
        catch (Exception e) {
            ErrorHandler.handle((Throwable)e);
        }
    }

    protected String getTitle() {
        return Messages.Create_a_route_receipt;
    }

    abstract BookingFileService.ItineraryReceiptRPCResult createItineraryReceipts() throws Exception;
}

