/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.tasks;

import com.gridnine.xtrip.client.fx.core.entity.EntityModification;
import com.gridnine.xtrip.client.fx.core.entity.EntityModificationEvent;
import com.gridnine.xtrip.client.fx.core.event.Event;
import com.gridnine.xtrip.client.fx.core.event.EventBus;
import com.gridnine.xtrip.client.fx.core.tasks.ClientTask;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.fx.rpc.service.IntegrationBusRpcService;
import com.gridnine.xtrip.common.l10n.messages.L10n;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductReplaceDetailsType;
import com.gridnine.xtrip.common.model.profile.IbusReplaceDetailsContextKey;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.util.CollectionUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class ProductReplaceDetailsListTask
extends ClientTask {
    private final Map<String, EntityReference<BookingFile>> productUidsAndBookingFiles;
    private final Map<ProductReplaceDetailsType, Object> values;

    public ProductReplaceDetailsListTask(Map<String, EntityReference<BookingFile>> productUidsAndBookingFiles, Map<ProductReplaceDetailsType, Object> values) {
        this.productUidsAndBookingFiles = CollectionUtil.requireNonEmpty(productUidsAndBookingFiles, (String)"bookings not selected");
        this.values = CollectionUtil.requireNonEmpty(values, (String)"values not selected");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute() throws Exception {
        Map<EntityReference<BookingFile>, List<String>> bookingFilesAndProductsUids = this.collectByBookings();
        int index = 0;
        try {
            for (Map.Entry<EntityReference<BookingFile>, List<String>> entry : bookingFilesAndProductsUids.entrySet()) {
                EntityReference<BookingFile> bookingFile = entry.getKey();
                List<String> productUids = entry.getValue();
                Thread.sleep(1L);
                this.setProgress((byte)(100 * index++ / bookingFilesAndProductsUids.size()), L10n.replace((String)Messages.ProcessingBooking, (Object[])new Object[]{bookingFile}));
                this.addMessages(this.processBookingFile(bookingFile, productUids));
            }
        }
        finally {
            EventBus.get().publishAsync((Event)new EntityModificationEvent((Object)this, (Collection)bookingFilesAndProductsUids.keySet().stream().map(bookingFileEntityReference -> new EntityModification(bookingFileEntityReference, EntityModification.ModificationType.CHANGE)).collect(Collectors.toList())));
        }
    }

    protected String getTitle() {
        return Messages.Change_of_requisites;
    }

    private Map<EntityReference<BookingFile>, List<String>> collectByBookings() {
        HashMap<EntityReference<BookingFile>, List<String>> result = new HashMap<EntityReference<BookingFile>, List<String>>();
        this.productUidsAndBookingFiles.forEach((productUid, bfRef) -> result.computeIfAbsent((EntityReference<BookingFile>)bfRef, k -> new ArrayList()).add(productUid));
        return result;
    }

    private List<Message> processBookingFile(EntityReference<BookingFile> bookingFile, List<String> productUids) throws Exception {
        HashMap<String, Object> ibusContext = new HashMap<String, Object>();
        ibusContext.put(IbusReplaceDetailsContextKey.BOOKING_FILE_REFERENCE.name(), bookingFile);
        ibusContext.put(IbusReplaceDetailsContextKey.PRODUCT_UIDS.name(), productUids);
        ibusContext.put(IbusReplaceDetailsContextKey.VALUES.name(), this.values);
        Set<String> returnValues = Collections.singleton(IbusReplaceDetailsContextKey.MESSAGES.name());
        Map ibusResult = ((IntegrationBusRpcService)RpcServiceManager.get().getService(IntegrationBusRpcService.class)).processRouteSync(ServiceInvocationContext.get(), "replace-details:replace-details-product", ibusContext, returnValues);
        List messages = (List)ibusResult.get(IbusReplaceDetailsContextKey.MESSAGES.name());
        Objects.requireNonNull(messages, "Messages wasn't returned from server");
        return messages;
    }
}

