/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.tasks.dialog;

import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.dialogs.DialogButtonStyle;
import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityPane;
import com.gridnine.xtrip.client.fx.core.lib.container.cards.Card;
import com.gridnine.xtrip.client.fx.core.lib.container.cards.CardsContainer;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridCell;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridContainer;
import com.gridnine.xtrip.client.fx.core.lib.widgets.PriceValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.TextFieldWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.CurrencyValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.DictBoxWidget;
import com.gridnine.xtrip.client.fx.core.tasks.ClientTask;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.tasks.ProductRefundTask;
import com.gridnine.xtrip.client.fx.standard.tasks.dialog.BaseAirProductExchangeRefundDialog;
import com.gridnine.xtrip.common.fx.rpc.ProductExchangeRefundProperties;
import com.gridnine.xtrip.common.meta.ui.UiCardsContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BlankType;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javafx.scene.Node;

public class AirProductRefundDialog
extends BaseAirProductExchangeRefundDialog {
    private final RootEntityPane<BookingFile, ?> rootPane;
    private final Node source;
    private final EntityReference<BookingFile> bookingFileReference;
    private final TextFieldWidget emdPenaltyNumberWidget;
    private final PriceValueWidget emdPenaltyBaseFareWidget;
    private final CurrencyValueWidget emdPenaltyCurrencyWidget;
    private final PriceValueWidget emdPenaltyEquivFareWidget;
    private final TextFieldWidget emdReferenceNumberWidget;
    private final DictBoxWidget<BlankType> emdBlankTypeDictBoxWidget;

    public AirProductRefundDialog(Node source, EntityReference<BookingFile> bookingFileReference, Product product, Map<Integer, MiscUtil.Pair<String, String>> segmentsPoints) {
        this(null, source, bookingFileReference, product, segmentsPoints);
    }

    public AirProductRefundDialog(RootEntityPane<BookingFile, ?> rootPane, Product product, Map<Integer, MiscUtil.Pair<String, String>> segmentsPoints) {
        this(rootPane, (Node)rootPane, null, product, segmentsPoints);
    }

    public AirProductRefundDialog(RootEntityPane<BookingFile, ?> rootPane, Node source, EntityReference<BookingFile> bookingFileReference, Product product, Map<Integer, MiscUtil.Pair<String, String>> segmentsPoints) {
        super(product, segmentsPoints);
        this.rootPane = rootPane;
        this.source = source;
        this.bookingFileReference = bookingFileReference;
        this.emdPenaltyNumberWidget = new TextFieldWidget(false);
        this.emdPenaltyBaseFareWidget = new PriceValueWidget(false);
        this.emdPenaltyCurrencyWidget = new CurrencyValueWidget(false);
        this.emdPenaltyCurrencyWidget.setValue(null);
        this.emdPenaltyEquivFareWidget = new PriceValueWidget(false);
        this.emdReferenceNumberWidget = new TextFieldWidget(false);
        this.emdBlankTypeDictBoxWidget = new DictBoxWidget(BlankType.class, false);
    }

    @Override
    protected String getCheckedColumnTitle() {
        return Messages.Accept_to_return;
    }

    public void showDialog() {
        CardsContainer cardsContainer = this.createBaseParametersCard(false);
        cardsContainer.getCards().add((Object)new Card("penalty", UiCardsContainer.Style.STATIC, Messages.EMD_Fine, (Node)this.createEmdPenaltyContainer()));
        cardsContainer.getCards().add((Object)new Card("reference", UiCardsContainer.Style.STATIC, Messages.EMD_Ref, (Node)this.createEmdReferenceContainer()));
        Dialog dialog = new Dialog();
        dialog.setTitle(Messages.Return_ticket).setAutoClose(false).setExpandToParent().setBody((Node)cardsContainer).addButton(DialogButtonStyle.DECLINE, () -> ((Dialog)dialog).close()).addButton(DialogButtonStyle.ACCEPT_REGULAR, Messages.Return, () -> {
            String emdPenaltyChecking = this.checkEmdPenalty();
            if (!TextUtil.isBlank((String)emdPenaltyChecking)) {
                Dialog.info((String)emdPenaltyChecking);
                return;
            }
            ProductExchangeRefundProperties props = new ProductExchangeRefundProperties(this.getOperationDate(), this.getAgent(), this.isForced(), this.getUsedBaseFare(), this.getUsedEquivFare(), this.getPenalty(), this.getSegmentDescriptions(), this.getTaxes(), this.getEmdPenalty(), this.getEmdReferenceNumber());
            ProductRefundTask task = this.rootPane != null ? new ProductRefundTask(this.product.getUid(), props, this.rootPane) : new ProductRefundTask(this.product.getUid(), props, this.bookingFileReference);
            Notifications.get().enqueueAsyncTask((ClientTask)task);
            dialog.close();
        }).setOnCloseRequest(() -> ((Dialog)dialog).close()).show(this.source);
    }

    private boolean isEMDBlank() {
        return TextUtil.isBlank((String)this.emdPenaltyNumberWidget.getValue()) && this.emdPenaltyBaseFareWidget.getValue() == null && this.emdPenaltyCurrencyWidget.getValue() == null && this.emdPenaltyEquivFareWidget.getValue() == null && this.emdBlankTypeDictBoxWidget.getValue() == null;
    }

    private String checkEmdPenalty() {
        if (this.isEMDBlank()) {
            return null;
        }
        if (TextUtil.isBlank((String)this.emdPenaltyNumberWidget.getValue())) {
            return Messages.Number_fine;
        }
        if (this.emdPenaltyBaseFareWidget.getValue() == null) {
            return Messages.Sum_fine;
        }
        if (this.emdPenaltyCurrencyWidget.getValue() == null) {
            return Messages.Cur_fine;
        }
        if (this.emdPenaltyEquivFareWidget.getValue() == null) {
            return Messages.Equ_sum_fine;
        }
        if (this.emdBlankTypeDictBoxWidget.getValue() == null) {
            return Messages.Blank_type_fine;
        }
        return null;
    }

    private GridContainer createEmdReferenceContainer() {
        GridContainer gridContainer = new GridContainer(5);
        ArrayList<GridCell> cells = new ArrayList<GridCell>();
        GridCell cell = new GridCell(Messages.Number, (Node)this.emdReferenceNumberWidget);
        cells.add(cell);
        gridContainer.getCells().addAll(cells);
        return gridContainer;
    }

    private GridContainer createEmdPenaltyContainer() {
        GridContainer gridContainer = new GridContainer(5);
        ArrayList<GridCell> cells = new ArrayList<GridCell>();
        GridCell cell = new GridCell(Messages.Number, (Node)this.emdPenaltyNumberWidget);
        cells.add(cell);
        cell = new GridCell(Messages.Amount, (Node)this.emdPenaltyBaseFareWidget);
        cells.add(cell);
        cell = new GridCell(Messages.Currency, (Node)this.emdPenaltyCurrencyWidget);
        cells.add(cell);
        cell = new GridCell(Messages.Equ_amount, (Node)this.emdPenaltyEquivFareWidget);
        cells.add(cell);
        cell = new GridCell(Messages.Type_of_blank, this.emdBlankTypeDictBoxWidget);
        cells.add(cell);
        gridContainer.getCells().addAll(cells);
        return gridContainer;
    }

    private List<ProductExchangeRefundProperties.ExchangeRefundEMD> getEmdPenalty() {
        return this.isEMDBlank() ? Collections.emptyList() : Collections.singletonList(new ProductExchangeRefundProperties.ExchangeRefundEMD(this.emdPenaltyNumberWidget.getValue(), (BigDecimal)this.emdPenaltyBaseFareWidget.getValue(), this.emdPenaltyCurrencyWidget.getValue(), (BigDecimal)this.emdPenaltyEquivFareWidget.getValue(), MCOCategory.PENALTY, this.emdBlankTypeDictBoxWidget.getValue()));
    }

    private String getEmdReferenceNumber() {
        return this.emdReferenceNumberWidget.getValue();
    }
}

