/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.tasks.dialog;

import com.gridnine.xtrip.client.fx.core.entity.IndexListParameters;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridCell;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.BooleanValueWidget;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductAirPanel;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductEMDPanel;
import com.gridnine.xtrip.client.fx.standard.helpers.ControllerInterceptorsHelper;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.tasks.AirRefundReceiptTask;
import com.gridnine.xtrip.client.fx.standard.tasks.BaseRefundReceiptTask;
import com.gridnine.xtrip.client.fx.standard.tasks.dialog.BaseRefundReceiptDialog;
import com.gridnine.xtrip.common.fx.rpc.AirRefundReceiptProperties;
import com.gridnine.xtrip.common.fx.rpc.BookingFileService;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.booking.AirItineraryReceiptData;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductIndex;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.system.TemplateDocument;
import com.gridnine.xtrip.common.model.system.TemplateDocumentIndex;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javafx.scene.Node;
import javafx.scene.layout.Pane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AirRefundReceiptDialog
extends BaseRefundReceiptDialog<AirRefundReceiptProperties> {
    private BooleanValueWidget useCyrillicForTravelerName;
    private BooleanValueWidget includePayer;
    private BooleanValueWidget includeVat;
    private BooleanValueWidget includeAgencyFees;
    private BooleanValueWidget includeAgencyFeesIntoTaxes;
    private BooleanValueWidget includeVendorFees;
    private BooleanValueWidget includeVendorFeesIntoTaxes;
    private BooleanValueWidget showTaxesSum;
    private BooleanValueWidget includeVatDetalization;
    private BooleanValueWidget ITTariff;
    private BooleanValueWidget hidePassport;
    private static final Logger log = LoggerFactory.getLogger(AirRefundReceiptDialog.class);

    private boolean isIncludePayer() {
        return this.includePayer.getValue();
    }

    private boolean isIncludeVat() {
        return this.includeVat.getValue();
    }

    private boolean isShowTaxesSum() {
        return this.showTaxesSum.getValue();
    }

    private boolean isIncludeVatDetalization() {
        return this.includeVatDetalization.getValue();
    }

    public boolean isITTariff() {
        return this.ITTariff.getValue();
    }

    private boolean isIncludeAgencyFees() {
        return this.includeAgencyFees.getValue();
    }

    private boolean isIncludeAgencyFeesIntoTaxes() {
        return this.includeAgencyFeesIntoTaxes.getValue();
    }

    private boolean isIncludeVendorFees() {
        return this.includeVendorFees.getValue();
    }

    private boolean isIncludeVendorFeesIntoTaxes() {
        return this.includeVendorFeesIntoTaxes.getValue();
    }

    private boolean isUseCyrillicForTravelerName() {
        return this.useCyrillicForTravelerName.getValue();
    }

    public boolean isHidePassport() {
        return this.hidePassport.getValue();
    }

    @Override
    public AirRefundReceiptProperties createProperties(Map<BaseProduct, EntityReference<BookingFile>> products2Bookings) {
        AirItineraryReceiptData receiptData = AirRefundReceiptDialog.getAirItineraryReceiptData(products2Bookings);
        if (receiptData != null) {
            return new AirRefundReceiptProperties(receiptData.isUseCyrillicForTravelerName(), receiptData.isIncludePayer(), receiptData.isIncludeVat(), receiptData.isIncludeAgencyFees(), receiptData.isIncludeAgencyFeesIntoTaxes(), receiptData.isIncludeVendorFees(), receiptData.isIncludeVendorFeesIntoTaxes(), receiptData.isShowTaxesSum(), receiptData.isIncludeVatDetalization(), receiptData.isITTariff(), receiptData.isHidePassport(), (Collection)receiptData.getTemplates(), this.getProducts2Bookings(), receiptData.getNotes());
        }
        return null;
    }

    @Override
    public AirRefundReceiptProperties createEmptyProperties() {
        return new AirRefundReceiptProperties();
    }

    @Override
    public AirRefundReceiptProperties createAndFillProperties() {
        return new AirRefundReceiptProperties(this.isUseCyrillicForTravelerName(), this.isIncludePayer(), this.isIncludeVat(), this.isIncludeAgencyFees(), this.isIncludeAgencyFeesIntoTaxes(), this.isIncludeVendorFees(), this.isIncludeVendorFeesIntoTaxes(), this.isShowTaxesSum(), this.isIncludeVatDetalization(), this.isITTariff(), this.isHidePassport(), this.getTemplates(), this.getProducts2Bookings(), this.getInformationNotes());
    }

    @Override
    public void createAdditionalWidgets() {
        this.useCyrillicForTravelerName = new BooleanValueWidget(false, false);
        this.includePayer = new BooleanValueWidget(false, false);
        this.includeVat = new BooleanValueWidget(false, false);
        this.includeVat.setValue(true);
        this.includeAgencyFees = new BooleanValueWidget(false, false);
        this.includeAgencyFees.setValue(true);
        this.includeAgencyFeesIntoTaxes = new BooleanValueWidget(false, false);
        this.includeVendorFees = new BooleanValueWidget(false, false);
        this.includeVendorFees.setValue(true);
        this.includeVendorFeesIntoTaxes = new BooleanValueWidget(false, false);
        this.showTaxesSum = new BooleanValueWidget(false, false);
        this.includeVatDetalization = new BooleanValueWidget(false, false);
        this.ITTariff = new BooleanValueWidget(false, false);
        this.hidePassport = new BooleanValueWidget(false, false);
    }

    @Override
    public void updateFromDefaultProperties(AirRefundReceiptProperties properties) {
        this.includeAgencyFees.setValue(properties.isIncludeAgencyFees());
        this.includeAgencyFeesIntoTaxes.setValue(properties.isIncludeAgencyFeesIntoTaxes());
        this.includeVendorFees.setValue(properties.isIncludeVendorFees());
        this.includeVendorFeesIntoTaxes.setValue(properties.isIncludeVendorFeesIntoTaxes());
        this.showTaxesSum.setValue(properties.isShowTaxesSum());
        this.includeVatDetalization.setValue(properties.isIncludeVatDetalization());
        this.useCyrillicForTravelerName.setValue(properties.isUseCyrilicForTravelerName());
        this.includePayer.setValue(properties.isIncludePayer());
        this.includeVat.setValue(properties.isIncludeVat());
    }

    @Override
    public List<GridCell<?>> createAdditionalPropertiesCells() {
        return Arrays.asList(new GridCell(Messages.Use_Cyrillic_for_the_travelers_name, (Node)this.useCyrillicForTravelerName), new GridCell(Messages.Include_payer, (Node)this.includePayer), new GridCell(Messages.Include_VAT, (Node)this.includeVat), new GridCell(Messages.Include_agency_fees, (Node)this.includeAgencyFees), new GridCell(Messages.Include_agency_fees_in_taxes, (Node)this.includeAgencyFeesIntoTaxes), new GridCell(Messages.Include_vendor_fees, (Node)this.includeVendorFees), new GridCell(Messages.Include_vendor_fees_in_taxes, (Node)this.includeVendorFeesIntoTaxes), new GridCell(Messages.Show_taxes_sum, (Node)this.showTaxesSum), new GridCell(Messages.Show_details_of_VAT_INN_KPP, (Node)this.includeVatDetalization), new GridCell(Messages.IT_Tariff, (Node)this.ITTariff), new GridCell(Messages.Hide_Passport, (Node)this.hidePassport));
    }

    @Override
    public IndexListParameters<TemplateDocument, TemplateDocumentIndex> getTemplateParameters() {
        return ControllerInterceptorsHelper.getRefundTemplates();
    }

    @Override
    public BaseRefundReceiptTask<AirRefundReceiptProperties> createTask(AirRefundReceiptProperties properties) {
        return new AirRefundReceiptTask(properties);
    }

    @Override
    public String getPropertiesFileName() {
        return "refund-receipt.xml";
    }

    @Override
    public List<Class<? extends Pane>> getPaneClassList() {
        return Arrays.asList(BookingFileProductAirPanel.class, BookingFileProductEMDPanel.class);
    }

    @Override
    public Class<?> getProductIndexClass() {
        return ProductIndex.class;
    }

    @Override
    public Class<? extends BaseProduct> getProductClass() {
        return Product.class;
    }

    private static AirItineraryReceiptData getAirItineraryReceiptData(Map<BaseProduct, EntityReference<BookingFile>> products2Bookings) {
        ArrayList<AirItineraryReceiptData> receiptDataList = new ArrayList<AirItineraryReceiptData>();
        for (Map.Entry<BaseProduct, EntityReference<BookingFile>> entry : products2Bookings.entrySet()) {
            if (!(entry.getKey() instanceof Product)) continue;
            NestedEntityReference productReference = new NestedEntityReference(entry.getValue(), (BaseEntity)((Product)entry.getKey()));
            try {
                AirItineraryReceiptData receiptData = ((BookingFileService)RpcServiceManager.get().getService(BookingFileService.class)).getAirItineraryReceiptData(ServiceInvocationContext.get(), productReference);
                receiptDataList.add(receiptData);
            }
            catch (Exception e) {
                log.error("unable to get AirItineraryReceiptData", (Throwable)e);
                return null;
            }
        }
        if (!receiptDataList.isEmpty()) {
            return (AirItineraryReceiptData)receiptDataList.get(0);
        }
        return null;
    }
}

