/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.tasks.dialog;

import com.gridnine.xtrip.client.fx.core.acl.AppliedAclData;
import com.gridnine.xtrip.client.fx.core.acl.FxAclUtil;
import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.dialogs.DialogButtonStyle;
import com.gridnine.xtrip.client.fx.core.lib.components.ControlsPane;
import com.gridnine.xtrip.client.fx.core.lib.container.ViewController;
import com.gridnine.xtrip.client.fx.core.lib.widgets.CheckBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.DateTimeValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.InfoLabelWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.PriceValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.EntityBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.CheckBoxWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.DateTimeValueWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.InfoWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.PriceValueWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.dialog.EntityBoxWidgetColumn;
import com.gridnine.xtrip.client.fx.core.tasks.ClientTask;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.model.booking.PayDialogFOPVM;
import com.gridnine.xtrip.client.fx.model.booking.SinglePayDialogContainer;
import com.gridnine.xtrip.client.fx.model.booking.SinglePayDialogContainerController;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.tasks.ProductClientFOPTask;
import com.gridnine.xtrip.common.fx.rpc.BookingFileService;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.handlers.ProductStatusHandler;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javafx.scene.Node;

abstract class ProductClientFOPDialog
extends Dialog {
    ViewController<TableWidget<PayDialogFOPVM>, Collection<PayDialogFOPVM>> tableWidgetController;

    ProductClientFOPDialog(Map<EntityReference<BookingFile>, List<String>> bfAndProductsUids, boolean haveProductColumn) {
        SinglePayDialogContainerController containerController = new SinglePayDialogContainerController(false);
        SinglePayDialogContainer card = containerController.getView();
        this.setTitle(this.getCardCaption());
        ArrayList<ProductFop> filteredFops = new ArrayList<ProductFop>();
        for (Map.Entry<EntityReference<BookingFile>, List<String>> productEntry : bfAndProductsUids.entrySet()) {
            try {
                for (BookingFileService.ProductFopsResult rpcResult : ((BookingFileService)RpcServiceManager.get().getService(BookingFileService.class)).getClientFops(ServiceInvocationContext.get(), productEntry.getKey(), productEntry.getValue())) {
                    if (ProductStatusHandler.getAllVoidStatuses().contains(rpcResult.getStatus())) continue;
                    boolean isRefundOrExchange = rpcResult.getStatus() == ProductStatus.REFUND || rpcResult.getStatus() == ProductStatus.EXCHANGE;
                    for (GeneralProductFop fop : rpcResult.getFops()) {
                        if (!this.isPaymentStatusAppropriate(fop) || !this.getAdditionalPredicate(fop) || this.isZero(fop)) continue;
                        filteredFops.add(new ProductFop(productEntry.getKey(), rpcResult.getProductUid(), rpcResult.getProductName(), isRefundOrExchange, fop));
                    }
                }
            }
            catch (Exception e) {
                ErrorHandler.handle((Throwable)e);
            }
        }
        if (!filteredFops.isEmpty()) {
            try {
                AppliedAclData.loadForMetaBasedUI(data -> containerController.enforceAcl(data, FxAclUtil.getUiAclResource((String)card.getClass().getName())), (String[])new String[]{card.getClass().getName()});
            }
            catch (Exception e) {
                ErrorHandler.handle((Throwable)e);
            }
            this.tableWidgetController = containerController.getContent();
            this.setBody((Node)card, false);
            this.setAutoClose(false);
            this.setOnCloseRequest(() -> ((ProductClientFOPDialog)this).close());
            this.addButton(DialogButtonStyle.DECLINE, Messages.Close, () -> ((ProductClientFOPDialog)this).close());
            this.addButton(DialogButtonStyle.ACCEPT_CONTINUE, this.getAcceptButtonCaption(), () -> this.acceptButtonPushed(filteredFops));
            ((TableWidget)this.tableWidgetController.getView()).setControlButtonsAvailability(ControlsPane.NONE);
            this.saturateTableWidget(filteredFops, haveProductColumn);
        } else {
            this.setMessage(this.getNothingToDoMessage());
            this.addButton(DialogButtonStyle.ACCEPT_REGULAR, Messages.Close, () -> ((ProductClientFOPDialog)this).close());
        }
    }

    private List<PayDialogFOP> getSelectedFops(Collection<PayDialogFOP> rowList) {
        return rowList.stream().filter(payDialogFOP -> payDialogFOP.checkBoxWidget.isSelected()).collect(Collectors.toList());
    }

    private Collection<PayDialogFOP> getAllFops() {
        ArrayList<PayDialogFOP> result = new ArrayList<PayDialogFOP>();
        TableWidget tableWidget = (TableWidget)this.tableWidgetController.getView();
        PriceValueWidgetColumn amountColumn = (PriceValueWidgetColumn)tableWidget.getColumn("sum");
        PriceValueWidgetColumn paymentColumn = (PriceValueWidgetColumn)tableWidget.getColumn("payment");
        EntityBoxWidgetColumn agentColumn = (EntityBoxWidgetColumn)tableWidget.getColumn("agent");
        DateTimeValueWidgetColumn dateColumn = (DateTimeValueWidgetColumn)tableWidget.getColumn("date");
        CheckBoxWidgetColumn checkColumn = (CheckBoxWidgetColumn)tableWidget.getColumn("check");
        InfoWidgetColumn uidColumn = (InfoWidgetColumn)tableWidget.getColumn("uid");
        IntStream.range(0, tableWidget.getRowsCount()).forEach(i -> {
            PriceValueWidget amountWidget = (PriceValueWidget)amountColumn.getWidget(i);
            PriceValueWidget paymentWidget = (PriceValueWidget)paymentColumn.getWidget(i);
            EntityBoxWidget agentWidget = (EntityBoxWidget)agentColumn.getWidget(i);
            DateTimeValueWidget dateWidget = (DateTimeValueWidget)dateColumn.getWidget(i);
            CheckBoxWidget checkBoxWidget = (CheckBoxWidget)checkColumn.getWidget(i);
            InfoLabelWidget uidWidget = (InfoLabelWidget)uidColumn.getHiddenWidget(i);
            result.add(new PayDialogFOP(amountWidget, paymentWidget, (EntityBoxWidget<Person>)agentWidget, dateWidget, checkBoxWidget, uidWidget.getText()));
        });
        return result;
    }

    private boolean isZero(GeneralProductFop generalProductFop) {
        return MiscUtil.isZero((BigDecimal)generalProductFop.getEquivalentAmount(), (boolean)true);
    }

    private void acceptButtonPushed(List<ProductFop> fops) {
        List<PayDialogFOP> selectedFops = this.getSelectedFops(this.getAllFops());
        ArrayList<? extends String> validationErrorList = new ArrayList<String>();
        validationErrorList.addAll(this.performStandardChecks(selectedFops));
        validationErrorList.addAll(this.performExtraChecks(selectedFops));
        if (!validationErrorList.isEmpty()) {
            Dialog.info((Node)this.tableWidgetController.getView(), (String)String.join((CharSequence)"\n", validationErrorList));
        } else {
            selectedFops.forEach(selectedFop -> fops.stream().filter(fop -> fop.getFop().getUid().equals(selectedFop.uid)).findAny().ifPresent(sourceFop -> {
                BigDecimal difference = ((BigDecimal)selectedFop.amountWidget.getValue()).abs().subtract(((BigDecimal)selectedFop.paymentWidget.getValue()).abs());
                if (!difference.toBigInteger().equals(BigDecimal.ZERO.toBigIntegerExact())) {
                    this.splitSourceFop(fops, (ProductFop)sourceFop, difference);
                }
                this.updateSourceFop(sourceFop.getFop(), (PayDialogFOP)selectedFop, sourceFop.isRefundOrExchange());
            }));
            try {
                this.close();
                Map<EntityReference<BookingFile>, Map<String, List<GeneralProductFop>>> productsAndFops = fops.stream().collect(Collectors.groupingBy(ProductFop::getBfReference)).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((List)entry.getValue()).stream().collect(Collectors.groupingBy(ProductFop::getProductUid)).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry2 -> ((List)entry2.getValue()).stream().map(ProductFop::getFop).collect(Collectors.toList())))));
                Notifications.get().enqueueAsyncTask((ClientTask)new ProductClientFOPTask(productsAndFops));
            }
            catch (Exception e) {
                ErrorHandler.handle((Throwable)e);
            }
        }
    }

    private void splitSourceFop(List<ProductFop> fops, ProductFop sourceFop, BigDecimal difference) {
        try {
            ProductFop newFop = sourceFop.cloneFop();
            newFop.getFop().setEquivalentAmount(difference);
            fops.add(fops.indexOf(sourceFop) + 1, newFop);
        }
        catch (Exception e) {
            ErrorHandler.handle((Throwable)e);
        }
    }

    private Collection<String> performStandardChecks(Collection<PayDialogFOP> selectedFops) {
        ArrayList<String> result = new ArrayList<String>();
        if (selectedFops.isEmpty()) {
            result.add(Messages.Not_selected_by_any_payment);
        }
        if (result.isEmpty() && selectedFops.stream().anyMatch(payDialogFOP -> {
            BigDecimal payment = (BigDecimal)payDialogFOP.paymentWidget.getValue();
            return payment == null || payment.equals(BigDecimal.ZERO);
        })) {
            result.add(Messages.Not_specified_the_amount_of_payment);
        }
        if (result.isEmpty() && selectedFops.stream().anyMatch(payDialogFOP -> {
            BigDecimal payment = (BigDecimal)payDialogFOP.paymentWidget.getValue();
            BigDecimal amount = (BigDecimal)payDialogFOP.amountWidget.getValue();
            return payment != null && payment.multiply(amount).compareTo(BigDecimal.ZERO) < 0;
        })) {
            result.add(Messages.Payment_amount_has_a_sign_opposite_to_the_total_amount);
        }
        if (result.isEmpty() && selectedFops.stream().anyMatch(payDialogFOP -> {
            BigDecimal payment = (BigDecimal)payDialogFOP.paymentWidget.getValue();
            BigDecimal amount = (BigDecimal)payDialogFOP.amountWidget.getValue();
            return payment != null && payment.abs().compareTo(amount.abs()) > 0;
        })) {
            result.add(Messages.Amount_of_payment_exceeds_the_full_amount);
        }
        if (result.isEmpty() && selectedFops.stream().anyMatch(payDialogFOP -> {
            LocalDateTime date = payDialogFOP.dateWidget.getValue();
            return date == null;
        })) {
            result.add(Messages.No_date_specified);
        }
        return result;
    }

    Collection<? extends String> performExtraChecks(List<PayDialogFOP> selectedFops) {
        return Collections.emptyList();
    }

    boolean getAdditionalPredicate(GeneralProductFop fop) {
        return true;
    }

    abstract String getCardCaption();

    abstract String getAcceptButtonCaption();

    abstract void saturateTableWidget(List<ProductFop> var1, boolean var2);

    abstract void updateSourceFop(GeneralProductFop var1, PayDialogFOP var2, boolean var3);

    abstract String getNothingToDoMessage();

    abstract boolean isPaymentStatusAppropriate(GeneralProductFop var1);

    class ProductFop {
        private final EntityReference<BookingFile> bfReference;
        private final String productUid;
        private final String productName;
        private final boolean isRefundOrExchange;
        GeneralProductFop fop;

        ProductFop(EntityReference<BookingFile> bfReference, String productUid, String productName, boolean isRefundOrExchange, GeneralProductFop fop) throws Exception {
            this.bfReference = Objects.requireNonNull(bfReference);
            this.productUid = TextUtil.requireNonBlank((String)productUid);
            this.productName = productName;
            this.isRefundOrExchange = isRefundOrExchange;
            this.fop = (GeneralProductFop)Objects.requireNonNull(XCloneHelper.clone((XCloneable)fop));
        }

        EntityReference<BookingFile> getBfReference() {
            return this.bfReference;
        }

        String getProductUid() {
            return this.productUid;
        }

        String getProductName() {
            return this.productName;
        }

        boolean isRefundOrExchange() {
            return this.isRefundOrExchange;
        }

        GeneralProductFop getFop() {
            return this.fop;
        }

        ProductFop cloneFop() throws Exception {
            return new ProductFop(this.bfReference, this.productUid, this.productName, this.isRefundOrExchange, (GeneralProductFop)XCloneHelper.clone((XCloneable)this.fop, (boolean)true));
        }
    }

    class PayDialogFOP {
        final String uid;
        final PriceValueWidget paymentWidget;
        final PriceValueWidget amountWidget;
        final EntityBoxWidget<Person> agentWidget;
        final DateTimeValueWidget dateWidget;
        final CheckBoxWidget checkBoxWidget;

        PayDialogFOP(PriceValueWidget aAmountWidget, PriceValueWidget aPaymentWidget, EntityBoxWidget<Person> aAgentWidget, DateTimeValueWidget aDateWidget, CheckBoxWidget aCheckBoxWidget, String aUid) {
            this.uid = aUid;
            this.amountWidget = aAmountWidget;
            this.paymentWidget = aPaymentWidget;
            this.agentWidget = aAgentWidget;
            this.dateWidget = aDateWidget;
            this.checkBoxWidget = aCheckBoxWidget;
        }
    }
}

