/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.tasks.dialog;

import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.dialogs.DialogButtonStyle;
import com.gridnine.xtrip.client.fx.core.lib.components.ControlsPane;
import com.gridnine.xtrip.client.fx.core.lib.container.cards.Card;
import com.gridnine.xtrip.client.fx.core.lib.container.cards.CardsContainer;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridCell;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridContainer;
import com.gridnine.xtrip.client.fx.core.lib.widgets.TextAreaWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.multi.MultiEntityWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.BooleanValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidgetController;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.BooleanValueWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.InfoWidgetColumn;
import com.gridnine.xtrip.client.fx.core.tasks.ClientTask;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.standard.helpers.ControllerInterceptorsHelper;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.tasks.VoucherTask;
import com.gridnine.xtrip.client.fx.standard.tasks.dialog.AirItineraryReceiptDialog;
import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.fx.rpc.BookingFileService;
import com.gridnine.xtrip.common.fx.rpc.DictItem;
import com.gridnine.xtrip.common.fx.rpc.VoucherProperties;
import com.gridnine.xtrip.common.meta.ui.UiCardsContainer;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.HotelVoucherData;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProduct;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.InformationNote;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.system.TemplateDocument;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.xml.DocumentBuilderHelper;
import com.gridnine.xtrip.common.xml.XUtil;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class VoucherDialog {
    private final Control source;
    private final MultiEntityWidget<TemplateDocument> templatesWidget;
    private final TableWidget<ProductTableVM> productsWidget;
    private final BooleanValueWidget hidePriceWidget;
    private final BooleanValueWidget hideMealWidget;
    private final BooleanValueWidget hideBasicEssentialInfoWidget;
    private final BooleanValueWidget hideAmenitiesWidget;
    private final BooleanValueWidget includeFeesInTotalPriceWidget;
    private final TableWidgetController<TableWidget<ProductTableVM>, ProductTableVM> productsController;
    private final TextAreaWidget agencyContactsWidget;
    private final TableWidget<NotesTableVM> notesWidget;
    private final TableWidgetController<TableWidget<NotesTableVM>, NotesTableVM> notesController;
    private static final Logger log = LoggerFactory.getLogger(AirItineraryReceiptDialog.class);

    public VoucherDialog(Control src, Map<BaseProduct, EntityReference<BookingFile>> products2Bookings, List<DictItem<InformationNote>> notes, String uidSelectedProduct) {
        this.source = src;
        this.productsWidget = this.createProductsWidget();
        this.productsController = new TableWidgetController<TableWidget<ProductTableVM>, ProductTableVM>(){

            public TableWidget<ProductTableVM> getView() {
                return VoucherDialog.this.productsWidget;
            }
        };
        List productsVM = products2Bookings.entrySet().stream().map(item -> {
            BaseProduct prod = (BaseProduct)item.getKey();
            ProductTableVM productVM = new ProductTableVM();
            productVM.setProduct(BookingHelper.generateShortProductName((BaseProduct)prod));
            productVM.setProductUID(prod.getUid());
            productVM.setBfRef((EntityReference<BookingFile>)((EntityReference)item.getValue()));
            if (products2Bookings.entrySet().size() == 1) {
                productVM.setChecked(true);
            } else {
                productVM.setChecked(prod.getUid().equals(uidSelectedProduct));
            }
            return productVM;
        }).collect(Collectors.toList());
        this.productsController.readData(productsVM);
        VoucherProperties props = this.createProperties(products2Bookings);
        if (props == null) {
            props = new VoucherProperties();
            VoucherDialog.loadParams(props);
        }
        this.templatesWidget = new MultiEntityWidget(TemplateDocument.class, false);
        this.templatesWidget.setListParametersSupplier(ControllerInterceptorsHelper::getVoucherTemplates);
        this.templatesWidget.getValues().addAll(props.getTemplateRefs());
        this.hidePriceWidget = new BooleanValueWidget(true, false);
        this.hidePriceWidget.setValue(props.isHidePrice());
        this.hideMealWidget = new BooleanValueWidget(true, false);
        this.hideMealWidget.setValue(props.isHideMeal());
        this.hideBasicEssentialInfoWidget = new BooleanValueWidget(true, false);
        this.hideBasicEssentialInfoWidget.setValue(props.isHideBasicEssentialInfo());
        this.hideAmenitiesWidget = new BooleanValueWidget(true, false);
        this.hideAmenitiesWidget.setValue(props.isHideAmenities());
        this.includeFeesInTotalPriceWidget = new BooleanValueWidget(true, false);
        this.includeFeesInTotalPriceWidget.setValue(props.isIncludeFeesInTotalPrice());
        this.agencyContactsWidget = this.createAgencyContactsWidget();
        this.agencyContactsWidget.setValue(props.getAgencyContacts());
        List notesCodes = props.getNotes().stream().map(DictionaryReference::getCode).collect(Collectors.toList());
        this.notesWidget = this.createNotesWidget();
        this.notesController = new TableWidgetController<TableWidget<NotesTableVM>, NotesTableVM>(){

            public TableWidget<NotesTableVM> getView() {
                return VoucherDialog.this.notesWidget;
            }
        };
        List notesVM = notes.stream().map(dict -> {
            NotesTableVM noteVM = new NotesTableVM();
            noteVM.setInformationNoteReference((DictionaryReference<InformationNote>)dict.getReference());
            noteVM.setCode((String)dict.getFields().get(BaseDictionary.Property.code.name()));
            if (dict.getReference() != null) {
                noteVM.setText(dict.getReference().toString());
            }
            noteVM.setChecked(notesCodes.contains(noteVM.getCode()));
            return noteVM;
        }).collect(Collectors.toList());
        this.notesController.readData(notesVM);
    }

    private VoucherProperties createProperties(Map<BaseProduct, EntityReference<BookingFile>> products2Bookings) {
        HotelVoucherData hotelVoucherData = VoucherDialog.getHotelVoucherData(products2Bookings);
        if (hotelVoucherData != null) {
            return new VoucherProperties(this.getProducts2Bookings(), hotelVoucherData.getNotes(), (Collection)hotelVoucherData.getTemplates(), hotelVoucherData.getAgencyContacts(), hotelVoucherData.isHidePrice(), hotelVoucherData.isHideMeal(), hotelVoucherData.isHideBasicEssentialInfo(), hotelVoucherData.isHideAmenities(), hotelVoucherData.isIncludeFeesInTotalPrice());
        }
        return null;
    }

    public void showDialog() {
        CardsContainer cardsContainer = this.createParametersCard();
        Dialog dialog = new Dialog();
        dialog.setTitle(Messages.Voucher_options).setAutoClose(false).setExpandToParent().setBody((Node)cardsContainer).addButton(DialogButtonStyle.DECLINE, () -> ((Dialog)dialog).close()).addButton(DialogButtonStyle.ACCEPT_REGULAR, Messages.Form, () -> {
            Map<String, EntityReference<BookingFile>> products = this.getProducts2Bookings();
            if (products.size() == 0) {
                Dialog.info((String)Messages.Need_at_least_one_ticket);
                return;
            }
            if (this.getTemplates() == null || this.getTemplates().isEmpty()) {
                Dialog.info((String)Messages.Must_select_a_template);
                return;
            }
            VoucherProperties props = new VoucherProperties(this.getProducts2Bookings(), this.getInformationNotes(), this.getTemplates(), this.getAgencyContacts(), this.isHidePrice(), this.isHideMeal(), this.isHideBasicEssentialInfo(), this.isHideAmenities(), this.isIncludeFeesInTotalPrice());
            VoucherDialog.saveParams(props);
            Notifications.get().enqueueAsyncTask((ClientTask)new VoucherTask(props));
            dialog.close();
        }).setOnCloseRequest(() -> ((Dialog)dialog).close()).show((Node)this.source);
    }

    private TextAreaWidget createAgencyContactsWidget() {
        TextAreaWidget widget = new TextAreaWidget(false);
        widget.setPrefRowCount(5);
        return widget;
    }

    private TableWidget<ProductTableVM> createProductsWidget() {
        TableWidget widget = new TableWidget(false);
        widget.setControlButtonsAvailability(ControlsPane.NONE);
        ArrayList<InfoWidgetColumn> columns = new ArrayList<InfoWidgetColumn>();
        InfoWidgetColumn column = new InfoWidgetColumn(ProductTableVM::getProduct, ProductTableVM::setProduct);
        column.setId("product");
        column.setCaption(Messages.Name);
        columns.add(column);
        column = new BooleanValueWidgetColumn(ProductTableVM::isChecked, ProductTableVM::setChecked);
        column.setId("checked");
        column.setCaption(Messages.Add_to_voucher);
        column.setPrefWidth(Double.valueOf(30.0));
        columns.add(column);
        widget.setColumns(columns);
        return widget;
    }

    private TableWidget<NotesTableVM> createNotesWidget() {
        TableWidget widget = new TableWidget(false);
        widget.setControlButtonsAvailability(ControlsPane.NONE);
        ArrayList<InfoWidgetColumn> columns = new ArrayList<InfoWidgetColumn>();
        InfoWidgetColumn column = new InfoWidgetColumn(NotesTableVM::getText, NotesTableVM::setText);
        column.setId("product");
        column.setCaption(Messages.Message);
        columns.add(column);
        column = new BooleanValueWidgetColumn(NotesTableVM::isChecked, NotesTableVM::setChecked);
        column.setId("checked");
        column.setCaption(Messages.Add_to_voucher);
        column.setPrefWidth(Double.valueOf(30.0));
        columns.add(column);
        widget.setColumns(columns);
        return widget;
    }

    private CardsContainer createParametersCard() {
        GridContainer productsContainer = new GridContainer();
        productsContainer.getCells().add((Object)new GridCell("", this.productsWidget));
        GridContainer notesContainer = new GridContainer();
        notesContainer.getCells().add((Object)new GridCell("", this.notesWidget));
        GridContainer contactsContainer = new GridContainer();
        contactsContainer.getCells().add((Object)new GridCell("", (Node)this.agencyContactsWidget));
        CardsContainer cardsContainer = new CardsContainer();
        cardsContainer.getCards().add((Object)new Card("parameters", UiCardsContainer.Style.STATIC, Messages.Parameters, (Node)this.createGeneralParamsContainer()));
        cardsContainer.getCards().add((Object)new Card("contacts", UiCardsContainer.Style.STATIC, Messages.AgencyContacts, (Node)contactsContainer));
        cardsContainer.getCards().add((Object)new Card("products", UiCardsContainer.Style.STATIC, Messages.Tickets, (Node)productsContainer));
        cardsContainer.getCards().add((Object)new Card("notes", UiCardsContainer.Style.STATIC, Messages.Info_messages, (Node)notesContainer));
        return cardsContainer;
    }

    private GridContainer createGeneralParamsContainer() {
        GridContainer gridContainer = new GridContainer(3);
        ArrayList<GridCell> cells = new ArrayList<GridCell>();
        GridCell cell = new GridCell(Messages.Templates, this.templatesWidget);
        cells.add(cell);
        cell = new GridCell(Messages.HidePrice, (Node)this.hidePriceWidget);
        cells.add(cell);
        cell = new GridCell(Messages.HideMeal, (Node)this.hideMealWidget);
        cells.add(cell);
        cell = new GridCell(Messages.HideBasicEssentialInfo, (Node)this.hideBasicEssentialInfoWidget);
        cells.add(cell);
        cell = new GridCell(Messages.HideAmenities, (Node)this.hideAmenitiesWidget);
        cells.add(cell);
        cell = new GridCell(Messages.IncludeFeesInTotalPrice, (Node)this.includeFeesInTotalPriceWidget);
        cells.add(cell);
        gridContainer.getCells().addAll(cells);
        return gridContainer;
    }

    public Collection<EntityReference<TemplateDocument>> getTemplates() {
        return this.templatesWidget.getValues();
    }

    public String getAgencyContacts() {
        return this.agencyContactsWidget.getValue();
    }

    protected Map<String, EntityReference<BookingFile>> getProducts2Bookings() {
        ArrayList products = new ArrayList();
        this.productsController.writeData(products);
        return products.stream().filter(ProductTableVM::isChecked).collect(Collectors.toMap(ProductTableVM::getProductUID, ProductTableVM::getBfRef));
    }

    protected List<DictionaryReference<InformationNote>> getInformationNotes() {
        ArrayList notes = new ArrayList();
        this.notesController.writeData(notes);
        return notes.stream().filter(NotesTableVM::isChecked).map(NotesTableVM::getInformationNoteReference).collect(Collectors.toList());
    }

    private static HotelVoucherData getHotelVoucherData(Map<BaseProduct, EntityReference<BookingFile>> products2Bookings) {
        ArrayList<HotelVoucherData> voucherDataList = new ArrayList<HotelVoucherData>();
        for (Map.Entry<BaseProduct, EntityReference<BookingFile>> entry : products2Bookings.entrySet()) {
            if (!(entry.getKey() instanceof HotelProduct)) continue;
            NestedEntityReference productReference = new NestedEntityReference(entry.getValue(), (BaseEntity)((HotelProduct)entry.getKey()));
            try {
                HotelVoucherData voucherData = ((BookingFileService)RpcServiceManager.get().getService(BookingFileService.class)).getHotelVoucherData(ServiceInvocationContext.get(), productReference);
                voucherDataList.add(voucherData);
            }
            catch (Exception e) {
                log.error("unable to get HotelVoucherData", (Throwable)e);
                return null;
            }
        }
        if (!voucherDataList.isEmpty()) {
            return (HotelVoucherData)voucherDataList.get(0);
        }
        return null;
    }

    private static void loadParams(VoucherProperties params) {
        File file = new File(Environment.getDataFolder(), "settings/voucher.xml");
        if (file.isFile()) {
            try {
                params.fromXML(DocumentBuilderHelper.parse((File)file).getDocumentElement());
            }
            catch (Exception e) {
                LoggerFactory.getLogger(VoucherDialog.class).warn("failed loading voucher parameters from " + file, (Throwable)e);
            }
        }
    }

    private static void saveParams(VoucherProperties params) {
        File file = new File(Environment.getDataFolder(), "settings/voucher.xml");
        try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));){
            Document doc = DocumentBuilderHelper.newDocument();
            Element root = doc.createElement("object");
            root.setAttribute("class", VoucherProperties.class.getName());
            params.toXML(root);
            doc.appendChild(root);
            XUtil.newTransformer().transform(new DOMSource(doc), new StreamResult(out));
        }
        catch (Exception e) {
            LoggerFactory.getLogger(VoucherDialog.class).warn("failed saving voucher parameters to " + file, (Throwable)e);
        }
    }

    private boolean isHidePrice() {
        return this.hidePriceWidget.getValue();
    }

    public boolean isHideMeal() {
        return this.hideMealWidget.getValue();
    }

    public boolean isHideBasicEssentialInfo() {
        return this.hideBasicEssentialInfoWidget.getValue();
    }

    public boolean isHideAmenities() {
        return this.hideAmenitiesWidget.getValue();
    }

    public boolean isIncludeFeesInTotalPrice() {
        return this.includeFeesInTotalPriceWidget.getValue();
    }

    public static class NotesTableVM {
        private String code;
        private String text;
        private DictionaryReference<InformationNote> noteReference;
        private boolean checked;

        public String getCode() {
            return this.code;
        }

        public void setCode(String value) {
            this.code = value;
        }

        public String getText() {
            return this.text;
        }

        public void setText(String value) {
            this.text = value;
        }

        public DictionaryReference<InformationNote> getInformationNoteReference() {
            return this.noteReference;
        }

        public void setInformationNoteReference(DictionaryReference<InformationNote> value) {
            this.noteReference = value;
        }

        public boolean isChecked() {
            return this.checked;
        }

        public void setChecked(boolean value) {
            this.checked = value;
        }
    }

    public static class ProductTableVM {
        private String product;
        private String productUID;
        private boolean checked;
        private EntityReference<BookingFile> bfRef;

        public String getProduct() {
            return this.product;
        }

        public void setProduct(String value) {
            this.product = value;
        }

        public String getProductUID() {
            return this.productUID;
        }

        public void setProductUID(String value) {
            this.productUID = value;
        }

        public boolean isChecked() {
            return this.checked;
        }

        public void setChecked(boolean value) {
            this.checked = value;
        }

        public EntityReference<BookingFile> getBfRef() {
            return this.bfRef;
        }

        public void setBfRef(EntityReference<BookingFile> bfRef) {
            this.bfRef = bfRef;
        }
    }
}

