/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.workspace;

import com.gridnine.xtrip.client.fx.core.acl.FxAclUtil;
import com.gridnine.xtrip.client.fx.core.devtools.api.DevTool;
import com.gridnine.xtrip.client.fx.core.devtools.api.DevToolItem;
import com.gridnine.xtrip.client.fx.core.event.Event;
import com.gridnine.xtrip.client.fx.core.event.EventBus;
import com.gridnine.xtrip.client.fx.core.lib.components.ClearableTextField;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridCell;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridContainer;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ComboBoxWidget;
import com.gridnine.xtrip.client.fx.core.registry.ClientRegistry;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.ui.navigation.NavTool;
import com.gridnine.xtrip.client.fx.core.util.DelayedChangeListener;
import com.gridnine.xtrip.client.fx.core.util.UiUtil;
import com.gridnine.xtrip.client.fx.core.util.ValueHolder;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.workspace.event.WorkspaceItemChangedEvent;
import com.gridnine.xtrip.common.fx.assets.FxWorkspaceItem;
import com.gridnine.xtrip.common.fx.rpc.AclQuery;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import javafx.scene.Node;
import javafx.scene.layout.StackPane;
import javafx.util.Duration;
import javafx.util.StringConverter;

class CommonNavToolParametersEditor
extends StackPane
implements DevTool {
    private GridContainer editorPane;
    private GridCell<ClearableTextField> nameCell;
    private GridCell<ComboBoxWidget<NavTool<?>>> typeCell;
    FxWorkspaceItem workspaceItem;
    boolean initialized;
    private DelayedChangeListener<String> nameChangeListener;

    CommonNavToolParametersEditor() {
        this.createGUI();
        this.createBindings();
        this.createListeners();
    }

    private void createGUI() {
        this.createEditorPane();
        this.getChildren().setAll((Object[])new Node[]{this.editorPane});
    }

    private void createEditorPane() {
        this.nameCell = new GridCell(Messages.Name, (Node)new ClearableTextField());
        this.typeCell = new GridCell(Messages.Element_type, (Node)new ComboBoxWidget(false));
        ((ComboBoxWidget)this.typeCell.getPayload()).setNoNulls(true);
        ((ComboBoxWidget)this.typeCell.getPayload()).setLive(true);
        ((ComboBoxWidget)this.typeCell.getPayload()).setItemsSupplier(this.createToolsSupplier());
        ((ComboBoxWidget)this.typeCell.getPayload()).setConverter(new StringConverter<NavTool<?>>(){

            public String toString(NavTool<?> object) {
                return object != null ? object.getName() : UiUtil.NULL_TEXT;
            }

            public NavTool<?> fromString(String string) {
                return null;
            }
        });
        this.editorPane = new GridContainer(3);
        this.editorPane.getCells().addAll((Object[])new GridCell[]{this.nameCell, this.typeCell});
    }

    private Supplier<List<NavTool<?>>> createToolsSupplier() {
        ValueHolder list = new ValueHolder(Collections.emptyList());
        Notifications.get().submitTask(() -> {
            ArrayList tools = new ArrayList(ClientRegistry.get().allOf(NavTool.TYPE).values());
            HashMap<String, AclQuery> map = new HashMap<String, AclQuery>();
            for (NavTool tool : tools) {
                AclQuery query = tool.toolACLQuery();
                if (query == null) continue;
                map.put(tool.getId(), query);
            }
            Set grantedIds = FxAclUtil.applyACL(map);
            Iterator it = tools.iterator();
            while (it.hasNext()) {
                NavTool tool = (NavTool)it.next();
                if (!map.containsKey(tool.getId()) || grantedIds.contains(tool.getId())) continue;
                it.remove();
            }
            list.set(tools);
        }, Messages.Form_list_of_instruments);
        return () -> ((ValueHolder)list).get();
    }

    private void createBindings() {
    }

    private void createListeners() {
        this.nameChangeListener = new DelayedChangeListener<String>(Duration.millis((double)700.0)){

            protected void handle(String value) {
                if (CommonNavToolParametersEditor.this.initialized) {
                    CommonNavToolParametersEditor.this.workspaceItem.setName(!TextUtil.isBlank((String)value) ? value : null);
                    EventBus.get().publishSync((Event)new WorkspaceItemChangedEvent(WorkspaceItemChangedEvent.ChangeType.NAME));
                }
            }
        };
        ((ClearableTextField)this.nameCell.getPayload()).textProperty().addListener(this.nameChangeListener);
        ((ComboBoxWidget)this.typeCell.getPayload()).valueProperty().addListener((observable, oldValue, newValue) -> {
            if (this.initialized) {
                this.workspaceItem.setToolId(newValue != null ? newValue.getId() : null);
                this.workspaceItem.setParameters(null);
                EventBus.get().publishSync((Event)new WorkspaceItemChangedEvent(WorkspaceItemChangedEvent.ChangeType.TYPE));
            }
        });
    }

    GridCell<ComboBoxWidget<NavTool<?>>> getTypeCell() {
        return this.typeCell;
    }

    boolean isDataChanged() {
        if (this.workspaceItem == null) {
            return false;
        }
        if (!MiscUtil.equals((Object)this.workspaceItem.getName(), (Object)((ClearableTextField)this.nameCell.getPayload()).getText())) {
            return true;
        }
        return !MiscUtil.equals((Object)this.workspaceItem.getToolId(), ((ComboBoxWidget)this.typeCell.getPayload()).getValue() != null ? ((NavTool)((ComboBoxWidget)this.typeCell.getPayload()).getValue()).getId() : null);
    }

    void readData(FxWorkspaceItem item) {
        this.initialized = false;
        ((ClearableTextField)this.nameCell.getPayload()).textProperty().removeListener(this.nameChangeListener);
        this.workspaceItem = item;
        ((ClearableTextField)this.nameCell.getPayload()).setText(!TextUtil.isBlank((String)item.getName()) ? item.getName() : null);
        ((ComboBoxWidget)this.typeCell.getPayload()).setValue((Object)NavTool.forId((String)item.getToolId()));
        ((ClearableTextField)this.nameCell.getPayload()).textProperty().addListener(this.nameChangeListener);
        this.initialized = true;
    }

    void writeData(FxWorkspaceItem item) {
        item.setName(!TextUtil.isBlank((String)((ClearableTextField)this.nameCell.getPayload()).getText()) ? ((ClearableTextField)this.nameCell.getPayload()).getText() : null);
        item.setToolId(((ComboBoxWidget)this.typeCell.getPayload()).getValue() != null ? ((NavTool)((ComboBoxWidget)this.typeCell.getPayload()).getValue()).getId() : null);
    }

    public DevToolItem asDevToolItem() {
        return new DevToolItem(){

            public Collection<?> getSubItems() {
                return Collections.singleton(CommonNavToolParametersEditor.this.editorPane);
            }

            public String getInfo() {
                return ((Object)((Object)CommonNavToolParametersEditor.this)).getClass().getSimpleName();
            }
        };
    }
}

