/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.workspace.util;

import com.gridnine.xtrip.client.fx.core.lib.components.table.TableColumnSettings;
import com.gridnine.xtrip.client.fx.standard.entity.navtool.IndexListNavToolData;
import com.gridnine.xtrip.client.fx.standard.helpers.IndexHelper;
import com.gridnine.xtrip.common.fx.assets.FxWorkspace;
import com.gridnine.xtrip.common.fx.assets.FxWorkspaceItem;
import com.gridnine.xtrip.common.model.assets.Repository;
import com.gridnine.xtrip.common.model.assets.SmartFolder;
import com.gridnine.xtrip.common.model.assets.Workspace;
import com.gridnine.xtrip.common.restriction.RestrictionGroup;
import com.gridnine.xtrip.common.restriction.helper.RestrictionsHelper;
import com.gridnine.xtrip.common.restriction.resource.RestrictionResourceProperty;
import com.gridnine.xtrip.common.restriction.resource.RestrictionResourcesRegistry;
import com.gridnine.xtrip.common.restriction.util.RestrictionsUtil;
import com.gridnine.xtrip.common.search.FilterQuery;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.SortOrder;
import com.gridnine.xtrip.common.util.DebugUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.xml.XSHelper;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkspaceUtil {
    private static final Logger log = LoggerFactory.getLogger(WorkspaceUtil.class);

    public static FxWorkspace toWorkspace(Workspace workspace) throws Exception {
        FxWorkspace fxWorkspace = new FxWorkspace();
        fxWorkspace.setOwner(workspace.getOwner());
        fxWorkspace.setName(workspace.getName());
        for (Repository repository : workspace.getRepositories()) {
            WorkspaceUtil.handleRepository(fxWorkspace, repository);
        }
        return fxWorkspace;
    }

    private static void handleRepository(FxWorkspace fxWorkspace, Repository repository) throws Exception {
        FxWorkspaceItem item = new FxWorkspaceItem();
        item.setName(repository.getName());
        item.setToolId("folder-nav-tool");
        for (SmartFolder folder : repository.getFolders()) {
            WorkspaceUtil.handleSmartFolder(item, folder);
        }
        if (item.getSubItems().size() > 0) {
            fxWorkspace.getItems().add(item);
        }
    }

    private static void handleSmartFolder(FxWorkspaceItem item, SmartFolder folder) throws Exception {
        FxWorkspaceItem subItem = new FxWorkspaceItem();
        subItem.setName(folder.getName());
        subItem.setToolId("index-list-nav-tool");
        IndexListNavToolData data = new IndexListNavToolData();
        Class indexType = null;
        String id = (String)folder.getCustomData().get("index-class");
        try {
            indexType = XSHelper.getClass((String)id);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (indexType != null) {
            boolean supported = IndexHelper.getAvalableIndexTypes().stream().anyMatch(type -> type.getId().equals(id));
            if (supported) {
                data.setIndexType(indexType);
                if (folder.getCustomData().get("query") != null) {
                    TableColumnSettings settings;
                    RestrictionResourceProperty property;
                    String propertyId;
                    SearchQuery query = (SearchQuery)folder.getCustomData().get("query");
                    data.getRestrictionGroups().addAll(query.getCriteria().getCriterions().stream().map(criterion -> RestrictionsUtil.toRestrictionGroupFromQuery((SearchCriterion)criterion, data.getIndexType(), Collections.emptyList())).collect(Collectors.toList()));
                    data.setLimit(200);
                    for (Map.Entry entry : query.getCriteria().getOrders().entrySet()) {
                        String key = (String)entry.getKey();
                        SortOrder value = (SortOrder)entry.getValue();
                        String propertyId2 = String.format("%s.%s", data.getIndexType().getName(), key);
                        RestrictionResourceProperty property2 = RestrictionResourcesRegistry.get().getProperty(propertyId2);
                        if (property2 == null) {
                            log.warn(String.format("unsupported property %s", propertyId2));
                            continue;
                        }
                        data.getSortings().put(key, value);
                    }
                    for (String preferredProperty : query.getPreferredProperties()) {
                        propertyId = String.format("%s.%s", data.getIndexType().getName(), preferredProperty);
                        property = RestrictionResourcesRegistry.get().getProperty(propertyId);
                        if (property == null) {
                            log.warn(String.format("unsupported property %s", propertyId));
                            continue;
                        }
                        settings = new TableColumnSettings();
                        settings.setId(preferredProperty);
                        settings.setDisplayName(null);
                        data.getColumns().add(settings);
                    }
                    for (FilterQuery filter : query.getFilters()) {
                        propertyId = String.format("%s.%s", data.getIndexType().getName(), filter.getProperty());
                        property = RestrictionResourcesRegistry.get().getProperty(propertyId);
                        if (property == null) {
                            log.warn(String.format("unsupported property %s", propertyId));
                            continue;
                        }
                        settings = new TableColumnSettings();
                        settings.setId(filter.getProperty());
                        settings.setDisplayName(null);
                        data.getFilters().add(settings);
                    }
                    subItem.setParameters(IndexListNavToolData.SERIALIZER.serialize((Object)data));
                }
                for (SmartFolder subFolder : folder.getSubFolders()) {
                    WorkspaceUtil.handleSmartFolder(subItem, subFolder);
                }
                item.getSubItems().add(subItem);
            } else {
                log.warn(String.format("unsupported index type %s", id));
            }
        }
    }

    public static String toString(FxWorkspace workspace) throws Exception {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("owner -> " + workspace.getOwner());
        stringBuilder.append("\n");
        stringBuilder.append("name -> " + workspace.getName());
        stringBuilder.append("\n");
        if (workspace.getItems().size() > 0) {
            stringBuilder.append(DebugUtil.decorate((Iterable)workspace.getItems().stream().map(item -> (String)MiscUtil.uncheckCall(() -> WorkspaceUtil.toString(item))).collect(Collectors.toList()), null, (String)"items", (boolean)true));
        }
        return stringBuilder.toString();
    }

    public static String toString(FxWorkspaceItem workspaceItem) throws Exception {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("name -> " + workspaceItem.getName());
        stringBuilder.append("\n");
        stringBuilder.append("toolId -> " + workspaceItem.getToolId());
        stringBuilder.append("\n");
        if (workspaceItem.getParameters() != null && workspaceItem.getToolId().equals("index-list-nav-tool")) {
            IndexListNavToolData data = (IndexListNavToolData)IndexListNavToolData.SERIALIZER.deserialize(workspaceItem.getParameters());
            stringBuilder.append(DebugUtil.decorate((String)WorkspaceUtil.toString(data), null, (String)"parameters", (boolean)true));
        }
        if (workspaceItem.getSubItems().size() > 0) {
            stringBuilder.append(DebugUtil.decorate((Iterable)workspaceItem.getSubItems().stream().map(item -> (String)MiscUtil.uncheckCall(() -> WorkspaceUtil.toString(item))).collect(Collectors.toList()), null, (String)"subItems", (boolean)true));
        }
        return stringBuilder.toString();
    }

    public static String toString(IndexListNavToolData data) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("limit -> " + data.getLimit());
        stringBuilder.append("\n");
        if (data.getRestrictionGroups().size() > 0) {
            stringBuilder.append(DebugUtil.decorate((Iterable)data.getRestrictionGroups().stream().map(item -> RestrictionsHelper.toString((RestrictionGroup)item)).collect(Collectors.toList()), null, (String)"restrictionGroups", (boolean)true));
        }
        if (data.getSortings().size() > 0) {
            stringBuilder.append(DebugUtil.decorate((Iterable)data.getSortings().entrySet().stream().map(item -> WorkspaceUtil.toString("id", "sortOrder", item)).collect(Collectors.toList()), null, (String)"sortings", (boolean)true));
        }
        if (data.getColumns().size() > 0) {
            stringBuilder.append(DebugUtil.decorate((Iterable)data.getColumns().stream().map(item -> WorkspaceUtil.toString(item)).collect(Collectors.toList()), null, (String)"columns", (boolean)true));
        }
        if (data.getFilters().size() > 0) {
            stringBuilder.append(DebugUtil.decorate((Iterable)data.getFilters().stream().map(item -> WorkspaceUtil.toString(item)).collect(Collectors.toList()), null, (String)"filters", (boolean)true));
        }
        return stringBuilder.toString();
    }

    public static String toString(String keyTitle, String valueTitle, Map.Entry<?, ?> entry) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(keyTitle + " -> " + entry.getKey());
        stringBuilder.append("\n");
        stringBuilder.append(valueTitle + " -> " + entry.getValue());
        stringBuilder.append("\n");
        return stringBuilder.toString();
    }

    public static String toString(TableColumnSettings settings) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("id -> " + settings.getId());
        stringBuilder.append("\n");
        stringBuilder.append("displayName -> " + settings.getDisplayName());
        stringBuilder.append("\n");
        return stringBuilder.toString();
    }
}

