/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.hotels2.rules;

import com.gridnine.xtrip.common.hotels2.model.HotelsAggregatorGdsAccount;
import com.gridnine.xtrip.common.hotels2.rules.HotelsParametersActionsProvider;
import com.gridnine.xtrip.common.hotels2.rules.HotelsSearchResultActionsProvider;
import com.gridnine.xtrip.common.l10n.messages.L10n;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProvider;
import com.gridnine.xtrip.common.model.rules.l10n.Messages;
import com.gridnine.xtrip.common.model.rules.standard.ValueTypes;
import com.gridnine.xtrip.common.rules.elements.RuleAction;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.common.util.CollectionUtil;
import java.util.Collection;

public enum HotelsActions implements RuleAction
{
    APPLICABLE_HOTEL_ACCOUNTS{

        public void buildInfo(StringBuilder buf, Object value) {
            if (value == null) {
                return;
            }
            Collection accounts = (Collection)value;
            if (accounts.size() == 0) {
                return;
            }
            buf.append(L10nResourcesManager.getStr((String)Messages.RuleAction_ApplicableGDSAccounts_info, (Object[])new Object[]{CollectionUtil.collectionToString((Iterable)accounts, (String)", ", (boolean)false)}));
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleAction_ApplicableGDSAccounts);
        }

        public String getRendererId() {
            return com.gridnine.xtrip.common.gds.rules.ValueTypes.GDS_ACCOUNT_LIST.name();
        }

        public boolean hasValue() {
            return true;
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) {
            HotelsParametersActionsProvider as = (HotelsParametersActionsProvider)proxy.getActionSet();
            for (EntityReference gdsAcc : (Collection)value) {
                as.addApplicableGDSAccount((EntityReference<HotelsAggregatorGdsAccount>)gdsAcc);
            }
            proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(as, value));
        }

        public String getRuleCategoryValue(Object actionSet, Object value) {
            return "\"applicable-Hotel-Aggregator-accounts\"";
        }
    }
    ,
    HOTEL_PROVIDERS_PRIORITY{

        public void buildInfo(StringBuilder buf, Object value) {
            if (value == null) {
                return;
            }
            Collection providers = (Collection)value;
            if (providers.size() == 0) {
                return;
            }
            buf.append(L10n.replace((String)L10n.get((String)"RuleAction_HOTEL_PROVIDERS_PRIORITY_info"), (Object[])new Object[]{CollectionUtil.collectionToString((Iterable)providers, (String)", ", (boolean)false)}));
        }

        public String getDisplayName() {
            return L10n.get((String)"RuleAction_HOTEL_PROVIDERS_PRIORITY");
        }

        public String getRendererId() {
            return ValueTypes.HOTEL_PROVIDER_ORDERED_LIST.name();
        }

        public boolean hasValue() {
            return true;
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) {
            HotelsSearchResultActionsProvider as = (HotelsSearchResultActionsProvider)proxy.getActionSet();
            for (HotelProvider provider : (Collection)value) {
                as.addHotelProvider(provider);
            }
            proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(as, value));
        }

        public String getRuleCategoryValue(Object actionSet, Object value) {
            return "\"hotel_providers_priority\"";
        }
    }
    ,
    BOOKING_MANAGER_NAME{

        public void buildInfo(StringBuilder buf, Object value) {
            if (value == null) {
                return;
            }
            String name = (String)value;
            buf.append(L10n.replace((String)L10n.get((String)"RuleAction_BOOKING_MANAGER_NAME_info"), (Object[])new Object[]{name}));
        }

        public String getDisplayName() {
            return L10n.get((String)"RuleAction_BOOKING_MANAGER_NAME");
        }

        public String getRendererId() {
            return ValueTypes.STRING.name();
        }

        public boolean hasValue() {
            return true;
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) {
            HotelsParametersActionsProvider as = (HotelsParametersActionsProvider)proxy.getActionSet();
            as.setBookingManagerName((String)value);
            proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(as, value));
        }

        public String getRuleCategoryValue(Object actionSet, Object value) {
            return "\"booking-manager-name\"";
        }
    }
    ,
    BOOKING_MANAGER_EMAIL{

        public void buildInfo(StringBuilder buf, Object value) {
            if (value == null) {
                return;
            }
            String email = (String)value;
            buf.append(L10n.replace((String)L10n.get((String)"RuleAction_BOOKING_MANAGER_EMAIL_info"), (Object[])new Object[]{email}));
        }

        public String getDisplayName() {
            return L10n.get((String)"RuleAction_BOOKING_MANAGER_EMAIL");
        }

        public String getRendererId() {
            return ValueTypes.STRING.name();
        }

        public boolean hasValue() {
            return true;
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) {
            HotelsParametersActionsProvider as = (HotelsParametersActionsProvider)proxy.getActionSet();
            as.setBookingManagerEmail((String)value);
            proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(as, value));
        }

        public String getRuleCategoryValue(Object actionSet, Object value) {
            return "\"booking-manager-email\"";
        }
    }
    ,
    BOOKING_MANAGER_PHONE{

        public void buildInfo(StringBuilder buf, Object value) {
            if (value == null) {
                return;
            }
            String phone = (String)value;
            buf.append(L10n.replace((String)L10n.get((String)"RuleAction_BOOKING_MANAGER_PHONE_info"), (Object[])new Object[]{phone}));
        }

        public String getDisplayName() {
            return L10n.get((String)"RuleAction_BOOKING_MANAGER_PHONE");
        }

        public String getRendererId() {
            return ValueTypes.STRING.name();
        }

        public boolean hasValue() {
            return true;
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) {
            HotelsParametersActionsProvider as = (HotelsParametersActionsProvider)proxy.getActionSet();
            as.setBookingManagerPhone((String)value);
            proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(as, value));
        }

        public String getRuleCategoryValue(Object actionSet, Object value) {
            return "\"booking-manager-phone\"";
        }
    }
    ,
    SEND_PAYER_INFO{

        public String getDisplayName() {
            return L10n.get((String)"RuleAction_SEND_PAYER_INFO");
        }

        public void buildInfo(StringBuilder buf, Object value) {
            buf.append(this.getDisplayName()).append(": ").append((Boolean)value);
        }

        public String getRendererId() {
            return ValueTypes.YES_NO.name();
        }

        public boolean hasValue() {
            return true;
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) {
            HotelsParametersActionsProvider as = (HotelsParametersActionsProvider)proxy.getActionSet();
            as.sendPayerInfo(Boolean.TRUE.equals(value));
            proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(as, value));
        }

        public String getRuleCategoryValue(Object actionSet, Object value) {
            return "send-final-client";
        }
    }
    ,
    HOTEL_SEARCH_BY_RADIUS{

        public String getDisplayName() {
            return L10n.get((String)"RuleAction_HOTEL_SEARCH_BY_RADIUS");
        }

        public void buildInfo(StringBuilder buf, Object value) {
            buf.append(this.getDisplayName()).append(": ").append((Boolean)value);
        }

        public String getRendererId() {
            return ValueTypes.YES_NO.name();
        }

        public boolean hasValue() {
            return true;
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) {
            HotelsParametersActionsProvider as = (HotelsParametersActionsProvider)proxy.getActionSet();
            as.setSearchByRadius(Boolean.TRUE.equals(value));
            proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(as, value));
        }

        public String getRuleCategoryValue(Object actionSet, Object value) {
            return "hotel-search-by-radius";
        }
    };


    public String getId() {
        return this.name();
    }
}

