/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.gen;

import com.gridnine.xtrip.common.gen.GenerationContext;
import com.gridnine.xtrip.common.meta.BaseProperty;
import com.gridnine.xtrip.common.meta.EntityCollection;
import com.gridnine.xtrip.common.meta.EntityType;
import com.gridnine.xtrip.common.meta.IndexProperty;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.Map;
import java.util.TreeMap;

public final class GenUtil {
    public static String capitalize(String name) {
        return name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    public static String getPackageName(String fullClassName) {
        int p = fullClassName.lastIndexOf(46);
        return p == -1 ? null : fullClassName.substring(0, p);
    }

    public static String getSimpleClassName(String fullClassName) {
        int p = fullClassName.lastIndexOf(46);
        return p == -1 ? fullClassName : fullClassName.substring(p + 1);
    }

    public static <P extends BaseProperty> long generateSerialVersionUID(String name, Map<String, P> properties, Map<String, ? extends EntityCollection> collections) {
        long result = 65882L * (long)name.hashCode();
        for (BaseProperty baseProperty : new TreeMap<String, P>(properties).values()) {
            result += 35732L * (long)baseProperty.getId().hashCode() * (long)baseProperty.getType().hashCode();
        }
        for (EntityCollection entityCollection : new TreeMap<String, EntityCollection>(collections).values()) {
            result += 597418L * (long)entityCollection.getId().hashCode() * (long)entityCollection.getType().hashCode() * (long)entityCollection.getElementType().hashCode();
        }
        return result;
    }

    public static long generateSerialVersionUID(String name, Map<String, IndexProperty> properties) {
        long result = 65881L * (long)name.hashCode();
        for (IndexProperty prop : new TreeMap<String, IndexProperty>(properties).values()) {
            result += 35732L * (long)prop.getId().hashCode() * (long)prop.getType().hashCode();
        }
        return result;
    }

    private GenUtil() {
    }

    public static boolean isExtendsAbstractRootEntity(String extendsId, GenerationContext ctx) throws Exception {
        if (TextUtil.isBlank(extendsId)) {
            return false;
        }
        EntityType entityType = ctx.getMetaRegistry().getEntities().get(extendsId);
        if (entityType == null) {
            throw new Exception("Entity  " + extendsId + " is used as extends but is not defined");
        }
        return entityType.isAbstract() && entityType.isRoot();
    }
}

