/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.gen;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Stack;

public class YamlWriter {
    private static final String NL = System.getProperty("line.separator");
    private Writer writer;
    private Stack<Boolean> idents = new Stack();
    private boolean list;
    private boolean first;

    public void beginFile(File file) throws IOException {
        this.writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "utf-8");
        this.list = false;
        this.idents.clear();
        this.header();
    }

    public void endFile() throws IOException {
        if (this.writer == null) {
            throw new IllegalStateException("no compilation unit started");
        }
        this.writer.close();
        this.writer = null;
    }

    private void addIdents() throws IOException {
        int count = this.idents.size();
        if (this.list && this.first) {
            --count;
        }
        for (int i = 0; i < count; ++i) {
            this.writer.append("  ");
        }
        if (this.list && this.first) {
            this.writer.append("- ");
            this.first = false;
        }
    }

    public void list(String name) throws IOException {
        this.addIdents();
        this.writer.append(name).append(":").append(NL);
        this.idents.push(this.list);
        this.list = true;
        this.first = true;
    }

    public void item() {
        this.first = true;
    }

    public void emptyList(String name) throws IOException {
        this.addIdents();
        this.writer.append(name).append(": []").append(NL);
    }

    public void end() {
        this.list = this.idents.pop();
    }

    public void object(String name) throws IOException {
        this.addIdents();
        this.writer.append(name).append(":").append(NL);
        this.idents.push(this.list);
        this.list = false;
    }

    public void key(String name) throws IOException {
        this.addIdents();
        this.writer.append("\"").append(name).append("\":").append(NL);
        this.idents.push(this.list);
        this.list = false;
    }

    public void property(String name, String value) throws IOException {
        this.addIdents();
        this.writer.append(name).append(": \"").append(value).append("\"").append(NL);
    }

    public void property(String name, boolean value) throws IOException {
        this.addIdents();
        this.writer.append(name).append(": ").append(Boolean.toString(value)).append(NL);
    }

    public void property(String name, int value) throws IOException {
        this.addIdents();
        this.writer.append(name).append(": \"").append(Integer.toString(value)).append("\"").append(NL);
    }

    public void property(String value) throws IOException {
        this.addIdents();
        this.writer.append("\"").append(value).append("\"").append(NL);
    }

    public void comment(String text) throws IOException {
        this.writer.append("# ").append(text);
    }

    private void header() throws IOException {
        this.writer.append("##########################################################").append(NL);
        this.writer.append("# Gridnine AB http://www.gridnine.com").append(NL);
        this.writer.append("# This is automatically generated file.").append(NL);
        this.writer.append("# Don't change it manually to avoid losing modifications.").append(NL);
        this.writer.append("##########################################################").append(NL);
        this.writer.append(NL);
    }
}

