/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.gen.export;

import com.gridnine.xtrip.common.gen.CodeGen;
import com.gridnine.xtrip.common.gen.GenUtil;
import com.gridnine.xtrip.common.gen.GenerationContext;
import com.gridnine.xtrip.common.gen.JavaWriter;
import com.gridnine.xtrip.common.meta.export.BaseExportedElementType;
import com.gridnine.xtrip.common.meta.export.ExportedCollectionType;
import com.gridnine.xtrip.common.meta.export.ExportedEntityType;
import com.gridnine.xtrip.common.meta.export.ExportedObjectsMetadataHelper;
import com.gridnine.xtrip.common.meta.export.ExportedPropertyType;
import com.gridnine.xtrip.common.model.export.BaseEntityExport;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportModelGenerator
implements CodeGen {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    public void generate(GenerationContext ctx) throws Exception {
        JavaWriter writer = new JavaWriter();
        for (ExportedEntityType ett : ctx.getExportMetaRegistry().getEntities().values()) {
            if (!ctx.getExchangeTypeFilter().accept(ett)) continue;
            this.generateEntity(writer, ctx, ett);
        }
    }

    static void generateTypeDoc(JavaWriter writer, GenerationContext ctx, BaseExportedElementType type, String typeName) throws IOException {
        List<URL> sources = ctx.getExportMetaRegistry().getSources(type);
        StringBuilder buf = new StringBuilder();
        buf.append(typeName).append(" generated from metadata.\n");
        buf.append("<dl>\n");
        buf.append("<dt>ID</dt><dd>").append(type.getId()).append("</dd>\n");
        buf.append("<dt>sources</dt><dd>").append((Object)sources.stream().map(url -> {
            String result = url.toExternalForm();
            int p = result.indexOf("plugins/");
            return p == -1 ? result : result.substring(p);
        }).collect(Collectors.joining("<br>\n"))).append("</dd>\n");
        buf.append("</dl>");
        writer.doc(buf.toString(), new Object[0]);
    }

    private void generateEntity(JavaWriter writer, GenerationContext ctx, ExportedEntityType ett) throws Exception {
        String propertyName;
        this.log.debug("generating entity " + ett.getId());
        writer.beginCompilationUnit(ctx.getOutFolder(), ett.getId());
        ExportModelGenerator.generateTypeDoc(writer, ctx, ett, "Entity");
        String extendsId = BaseEntityExport.class.getName();
        writer.beginBlock("public class %s extends %s", GenUtil.getSimpleClassName(ett.getId()), extendsId);
        writer.blank();
        writer.comment("BEGIN properties", new Object[0]);
        for (ExportedPropertyType exportedPropertyType : ett.getProperties().values()) {
            ExportModelGenerator.generateAccessors(writer, exportedPropertyType, ett, ctx);
        }
        writer.comment("END properties", new Object[0]);
        writer.blank();
        writer.comment("BEGIN collections", new Object[0]);
        for (ExportedCollectionType exportedCollectionType : ett.getCollections().values()) {
            ExportModelGenerator.generateAccessors(writer, exportedCollectionType, ett, ctx);
        }
        writer.comment("END collections", new Object[0]);
        writer.blank();
        writer.comment("implement com.gridnine.xtrip.common.meta.Introspectable", new Object[0]);
        writer.blank();
        writer.beginBlock("public Object getValue(final String memberId)", ett.getId());
        writer.comment("BEGIN properties", new Object[0]);
        for (BaseExportedElementType baseExportedElementType : ett.getProperties().values()) {
            propertyName = ExportedObjectsMetadataHelper.getPropertyName(baseExportedElementType.getId());
            if (propertyName.equals(baseExportedElementType.getId())) {
                writer.beginBlock("if (\"%s\".equals(memberId))", baseExportedElementType.getId());
            } else {
                writer.beginBlock("if (\"%s\".equals(memberId) || \"%s\".equals(memberId))", baseExportedElementType.getId(), propertyName);
            }
            writer.code("return this.%s;", ExportedObjectsMetadataHelper.getPropertyName(baseExportedElementType.getId()));
            writer.endBlock();
        }
        writer.comment("END properties", new Object[0]);
        writer.blank();
        writer.comment("BEGIN collections", new Object[0]);
        for (ExportedCollectionType exportedCollectionType : ett.getCollections().values()) {
            propertyName = ExportedObjectsMetadataHelper.getPropertyName(exportedCollectionType.getId());
            if (propertyName.equals(exportedCollectionType.getId())) {
                writer.beginBlock("if (\"%s\".equals(memberId))", exportedCollectionType.getId());
            } else {
                writer.beginBlock("if (\"%s\".equals(memberId) || \"%s\".equals(memberId))", exportedCollectionType.getId(), propertyName);
            }
            writer.code("return this.%s;", propertyName);
            writer.endBlock();
        }
        writer.comment("END collections", new Object[0]);
        writer.code("return super.getValue(memberId);", new Object[0]);
        writer.endBlock();
        writer.beginBlock("public void setValue(final String memberId, Object value)", ett.getId());
        writer.comment("BEGIN properties", new Object[0]);
        for (ExportedPropertyType exportedPropertyType : ett.getProperties().values()) {
            propertyName = ExportedObjectsMetadataHelper.getPropertyName(exportedPropertyType.getId());
            if (propertyName.equals(exportedPropertyType.getId())) {
                writer.beginBlock("if (\"%s\".equals(memberId))", exportedPropertyType.getId());
            } else {
                writer.beginBlock("if (\"%s\".equals(memberId) || \"%s\".equals(memberId))", exportedPropertyType.getId(), propertyName);
            }
            writer.code("this.%s = (%s) value;", ExportedObjectsMetadataHelper.getPropertyName(exportedPropertyType.getId()), ExportedObjectsMetadataHelper.getValueType(exportedPropertyType));
            writer.code("return;", new Object[0]);
            writer.endBlock();
        }
        writer.comment("END properties", new Object[0]);
        writer.code("super.setValue(memberId, value);", new Object[0]);
        writer.endBlock();
        writer.endBlock();
        writer.endCompilationUnit();
    }

    public static void generateAccessors(JavaWriter writer, ExportedCollectionType coll, ExportedEntityType ett, GenerationContext ctx) throws Exception {
        String valueType = ExportedObjectsMetadataHelper.getValueType(coll, ctx.getExportMetaRegistry());
        String propertyName = ExportedObjectsMetadataHelper.getPropertyName(coll.getId());
        writer.code("private final %s<%s> %s = new %s<%s>();", List.class.getName(), valueType, propertyName, ArrayList.class.getName(), valueType);
        writer.blank();
        writer.beginBlock("public %s<%s> get%s()", List.class.getName(), valueType, GenUtil.capitalize(propertyName));
        writer.code("return %s;", propertyName);
        writer.endBlock();
    }

    static void generateAccessors(JavaWriter writer, ExportedPropertyType prop, ExportedEntityType ett, GenerationContext ctx) throws Exception {
        String valueType = ExportedObjectsMetadataHelper.getValueType(prop);
        String propertyName = ExportedObjectsMetadataHelper.getPropertyName(prop.getId());
        writer.code("private %s %s;", valueType, propertyName, valueType);
        writer.blank();
        boolean booleanProperty = false;
        if (booleanProperty) {
            writer.beginBlock("public boolean is%s()", GenUtil.capitalize(propertyName));
        } else {
            writer.beginBlock("public %s get%s()", valueType, GenUtil.capitalize(propertyName));
        }
        writer.code("return %s;", propertyName);
        writer.endBlock();
        writer.blank();
        writer.beginBlock("public void set%s(final %s value)", GenUtil.capitalize(propertyName), valueType);
        writer.code("this.%s = value;", propertyName);
        writer.endBlock();
    }
}

