/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.gen.model;

import com.gridnine.xtrip.common.gen.GenUtil;
import com.gridnine.xtrip.common.gen.GenerationContext;
import com.gridnine.xtrip.common.gen.JavaWriter;
import com.gridnine.xtrip.common.gen.model.ModelCodeGenHelper;
import com.gridnine.xtrip.common.meta.BaseType;
import com.gridnine.xtrip.common.meta.EntityCollection;
import com.gridnine.xtrip.common.meta.EntityType;
import com.gridnine.xtrip.common.meta.IndexCollection;
import com.gridnine.xtrip.common.meta.MetaRegistryHelper;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.usage.IndexUsageHandler;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.common.xml.XSHelper;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.w3c.dom.Element;

final class CollectionGenerator {
    CollectionGenerator() {
    }

    static void generateAccessors(JavaWriter writer, EntityCollection coll, BaseType bt, GenerationContext ctx) throws Exception {
        String implType;
        String keyType = ModelCodeGenHelper.getType(coll, ctx, true);
        String elementType = ModelCodeGenHelper.getType(coll, ctx, false);
        if (Set.class.getName().equals(coll.getType())) {
            implType = HashSet.class.getName();
        } else if (List.class.getName().equals(coll.getType())) {
            implType = ArrayList.class.getName();
        } else if (Map.class.getName().equals(coll.getType())) {
            implType = LinkedHashMap.class.getName();
        } else if (LinkedHashSet.class.getName().equals(coll.getType())) {
            implType = LinkedHashSet.class.getName();
        } else {
            throw new Exception(String.format("unsupported %s of collection %s in entity %s", coll.getType(), coll.getId(), bt.getId()));
        }
        String customInstantiator = coll.getInstantiator();
        if (Map.class.getName().equals(coll.getType())) {
            ModelCodeGenHelper.maybeDeprecated(coll, writer);
            if (TextUtil.isBlank(customInstantiator)) {
                writer.code("private final %s<%s, %s> %s = new %s<%2$s, %3$s>();", coll.getType(), keyType, elementType, coll.getId(), implType);
            } else {
                writer.code("private final %s<%s, %s> %s = %s;", coll.getType(), keyType, elementType, coll.getId(), customInstantiator);
            }
            writer.blank();
            ModelCodeGenHelper.maybeDeprecated(coll, writer);
            writer.beginBlock("public %s<%s, %s> get%s()", coll.getType(), keyType, elementType, GenUtil.capitalize(coll.getId()));
            writer.code("return %s;", coll.getId());
            writer.endBlock();
        } else {
            ModelCodeGenHelper.maybeDeprecated(coll, writer);
            if (TextUtil.isBlank(customInstantiator)) {
                writer.code("private final %s<%s> %s = new %s<%2$s>();", coll.getType(), elementType, coll.getId(), implType);
            } else {
                writer.code("private final %s<%s> %s = %s;", coll.getType(), elementType, coll.getId(), customInstantiator);
            }
            writer.blank();
            if (coll.isPrivateCollection()) {
                return;
            }
            ModelCodeGenHelper.maybeDeprecated(coll, writer);
            writer.beginBlock("public %s<%s> get%s()", coll.getType(), elementType, GenUtil.capitalize(coll.getId()));
            writer.code("return %s;", coll.getId());
            writer.endBlock();
        }
        if (coll.isNullable()) {
            String propName = MetaRegistryHelper.getNullableCollectionPropName(coll.getId());
            writer.code("private boolean %s;", propName);
            writer.blank();
            writer.beginBlock("public boolean is%s()", GenUtil.capitalize(propName));
            writer.code("return %s;", propName);
            writer.endBlock();
            writer.beginBlock("public void set%s(final boolean value)", GenUtil.capitalize(propName));
            writer.code("this.%s = value;", propName);
            writer.endBlock();
        }
    }

    static void generateAccessors(JavaWriter writer, IndexCollection coll, BaseType bt, GenerationContext ctx) throws Exception {
        String implType;
        String elementType = CollectionGenerator.getType(coll, ctx);
        if (Set.class.getName().equals(coll.getType())) {
            implType = HashSet.class.getName();
        } else if (List.class.getName().equals(coll.getType())) {
            implType = ArrayList.class.getName();
        } else {
            throw new Exception(String.format("unsupported %s of collection %s in entity index %s", coll.getType(), coll.getId(), bt.getId()));
        }
        ModelCodeGenHelper.maybeDeprecated(coll, writer);
        writer.code("private final %s<%s> %s = new %s<%2$s>();", coll.getType(), elementType, coll.getId(), implType);
        writer.blank();
        ModelCodeGenHelper.maybeDeprecated(coll, writer);
        writer.beginBlock("public %s<%s> get%s()", coll.getType(), elementType, GenUtil.capitalize(coll.getId()));
        writer.code("return %s;", coll.getId());
        writer.endBlock();
    }

    static void generateInstrumentedAccessors(JavaWriter writer, IndexCollection coll, BaseType bt, GenerationContext ctx) throws Exception {
        String elementType = CollectionGenerator.getType(coll, ctx);
        if (Set.class.getName().equals(coll.getType())) {
            String implType = HashSet.class.getName();
        } else if (List.class.getName().equals(coll.getType())) {
            String implType = ArrayList.class.getName();
        } else {
            throw new Exception(String.format("unsupported %s of collection %s in entity index %s", coll.getType(), coll.getId(), bt.getId()));
        }
        ModelCodeGenHelper.maybeDeprecated(coll, writer);
        writer.beginBlock("public %s<%s> get%s()", coll.getType(), elementType, GenUtil.capitalize(coll.getId()));
        writer.code("%s.get().statRetrieving(\"%s\",\"%s\" );", IndexUsageHandler.class.getName(), bt.getId(), coll.getId());
        writer.code("return super.get%s();", GenUtil.capitalize(coll.getId()));
        writer.endBlock();
    }

    static void generateFromXML(JavaWriter writer, EntityCollection coll, BaseType bt, GenerationContext ctx) throws Exception {
        writer.comment("COLLECTION %s", coll.getId());
        if (coll.isNullable()) {
            String propName = MetaRegistryHelper.getNullableCollectionPropName(coll.getId());
            writer.code("%s = %s.readBoolean(elm, \"%1$s\", false);", propName, XHelper.class.getName());
        }
        writer.code("%s.clear();", coll.getId());
        if (Map.class.getName().equals(coll.getType())) {
            writer.beginBlock("for (%s entryElm : %s.getElements(elm, \"%s/entry\"))", Element.class.getName(), XmlUtil.class.getName(), coll.getId());
            writer.code("%s keyElm = %s.getElement(entryElm, \"key\");", Element.class.getName(), XmlUtil.class.getName());
            writer.code("%s valueElm = %s.getElement(entryElm, \"value\");", Element.class.getName(), XmlUtil.class.getName());
            CollectionGenerator.generateItemFromXML(writer, coll, bt, ctx, "key", "keyElm", true);
            CollectionGenerator.generateItemFromXML(writer, coll, bt, ctx, "value", "valueElm", false);
            writer.beginBlock("if(key != null && value != null)", new Object[0]);
            writer.code("this.%s.put(key, value);", coll.getId());
            writer.endBlock();
        } else {
            writer.beginBlock("for (%s itemElm : %s.getElements(elm, \"%s/item\"))", Element.class.getName(), XmlUtil.class.getName(), coll.getId());
            CollectionGenerator.generateItemFromXML(writer, coll, bt, ctx, "item", "itemElm", false);
            writer.beginBlock("if(item != null)", new Object[0]);
            writer.code("this.%s.add(item);", coll.getId());
            writer.endBlock();
        }
        writer.endBlock();
    }

    static void generateItemFromXML(JavaWriter writer, EntityCollection coll, BaseType bt, GenerationContext ctx, String itemName, String itemElement, boolean key) throws Exception {
        boolean reference;
        String type = key ? coll.getKeyType() : coll.getElementType();
        boolean bl = reference = key ? coll.isKeyReference() : coll.isReference();
        if (ctx.getMetaRegistry().getEnums().containsKey(type) || ctx.getMetaRegistry().getEnumRefs().containsKey(type)) {
            Set<String> enumItemRenamers = null;
            enumItemRenamers = ctx.getMetaRegistry().getEnumRefs().containsKey(type) ? ctx.getMetaRegistry().getEnumRefs().get(type).getEnumItemRenamers() : ctx.getMetaRegistry().getEnums().get(type).getEnumItemRenamers();
            ModelCodeGenHelper.generateEnumItemRenamerCode(writer, enumItemRenamers, type, itemElement);
            writer.code("%s %s = %s.readEnum(%s, \".\", %1$s.class);", type, itemName, XHelper.class.getName(), itemElement);
        } else if (ctx.getMetaRegistry().getEntities().containsKey(type) || ctx.getMetaRegistry().getEntityRefs().containsKey(type)) {
            if (reference) {
                ModelCodeGenHelper.generateRenameReferenceCode(writer, ModelCodeGenHelper.getEntityRenamersClassNames(ctx.getMetaRegistry(), type), itemElement);
                writer.code("%s<%s> %s = null;", EntityReference.class.getName(), type, itemName);
                writer.code("String className = %s.getAttribute(\"class\");", itemElement);
                writer.beginBlock("if(%s.isBlank(className))", TextUtil.class.getName());
                writer.code("String ecUid = %s.getValue(%s, \"uid\");", XmlUtil.class.getName(), itemElement);
                writer.code("String refCaption = %s.getValue(%s, \"caption\");", XmlUtil.class.getName(), itemElement);
                writer.code("Class<%s> etType = (Class<%1$s>) %s.getClass(%s.getValue(%s, \"type\"));", type, XHelper.class.getName(), XmlUtil.class.getName(), itemElement);
                writer.beginBlock("if(!%s.isBlank(ecUid))", TextUtil.class.getName());
                writer.code("%s = new %s<%s>(ecUid, etType, refCaption);", itemName, EntityReference.class.getName(), type);
                writer.endBlock();
                writer.restartBlock("else", new Object[0]);
                writer.code("%s = (%s<%s>) %s.readObject(%s, \".\");", itemName, EntityReference.class.getName(), type, XHelper.class.getName(), itemElement);
                writer.endBlock();
            } else {
                ModelCodeGenHelper.generateRenameEntityCode(writer, ModelCodeGenHelper.getEntityRenamersClassNames(ctx.getMetaRegistry(), type), itemElement);
                writer.code("%s %s = (%1$s) %s.readObject(%s, \".\");", type, itemName, XHelper.class.getName(), itemElement);
            }
        } else if (ctx.getMetaRegistry().getDictionaries().containsKey(type)) {
            writer.code("%sReference %s = new %1$sReference(%s.getValue(%s), %3$s.getValue(%4$s, \"@caption\"));", type, itemName, XmlUtil.class.getName(), itemElement);
        } else if ("String".equals(type) || "text".equals(type)) {
            writer.code("String %s = %s.readString(%s, \".\");", itemName, XHelper.class.getName(), itemElement);
        } else if ("Boolean".equals(type)) {
            writer.code("Boolean %s = %s.readBoolean(%s, \".\");", itemName, XHelper.class.getName(), itemElement);
        } else if ("Byte".equals(type)) {
            writer.code("Byte %s = %s.readByte(%s, \".\");", itemName, XHelper.class.getName(), itemElement);
        } else if ("Character".equals(type)) {
            writer.code("Character %s = %s.readChar(%s, \".\");", itemName, XHelper.class.getName(), itemElement);
        } else if ("Short".equals(type)) {
            writer.code("Short %s = %s.readShort(%s, \".\");", itemName, XHelper.class.getName(), itemElement);
        } else if ("Integer".equals(type)) {
            writer.code("Integer %s = %s.readInt(%s, \".\");", itemName, XHelper.class.getName(), itemElement);
        } else if ("Long".equals(type)) {
            writer.code("Long %s = %s.readLong(%s, \".\");", itemName, XHelper.class.getName(), itemElement);
        } else if ("Float".equals(type)) {
            writer.code("Float %s = %s.readFloat(%s, \".\");", itemName, XHelper.class.getName(), itemElement);
        } else if ("Double".equals(type)) {
            writer.code("Double %s = %s.readDouble(%s, \".\");", itemName, XHelper.class.getName(), itemElement);
        } else if (BigDecimal.class.getName().equals(type)) {
            writer.code("%s %s = %s.readBigDecimal(%s, \".\");", BigDecimal.class.getName(), itemName, XHelper.class.getName(), itemElement);
        } else if (BigInteger.class.getName().equals(type)) {
            writer.code("%s %s = %s.readBigInteger(%s, \".\");", BigInteger.class.getName(), itemName, XHelper.class.getName(), itemElement);
        } else if (Date.class.getName().equals(type)) {
            writer.code("%s %s = %s.readDate(%s, \".\");", Date.class.getName(), itemName, XHelper.class.getName(), itemElement);
        } else if (LocalDate.class.getName().equals(type)) {
            writer.code("%s %s = %s.readJavaLocalDate(%s, \".\");", LocalDate.class.getName(), itemName, XHelper.class.getName(), itemElement);
        } else if (LocalDateTime.class.getName().equals(type)) {
            writer.code("%s %s = %s.readJavaLocalDateTime(%s, \".\");", LocalDateTime.class.getName(), itemName, XHelper.class.getName(), itemElement);
        } else if (LocalTime.class.getName().equals(type)) {
            writer.code("%s %s = %s.readJavaLocalTime(%s, \".\");", LocalTime.class.getName(), itemName, XHelper.class.getName(), itemElement);
        } else if (OffsetDateTime.class.getName().equals(type)) {
            writer.code("%s %s = %s.readJavaOffsetDateTime(%s, \".\");", OffsetDateTime.class.getName(), itemName, XHelper.class.getName(), itemElement);
        } else if (DayOfWeek.class.getName().equals(type)) {
            writer.code("%s %s = %s.readJavaDayOfWeek(%s, \".\");", DayOfWeek.class.getName(), itemName, XHelper.class.getName(), itemElement);
        } else if (Locale.class.getName().equals(type)) {
            writer.code("%s %s = %s.readLocale(%s, \".\");", Locale.class.getName(), itemName, XHelper.class.getName(), itemElement);
        } else if (URL.class.getName().equals(type)) {
            writer.code("%s %s = %s.readURL(%s, \".\");", URL.class.getName(), itemName, XHelper.class.getName(), itemElement);
        } else if (URI.class.getName().equals(type)) {
            writer.code("%s %s = %s.readURI(%s, \".\");", URI.class.getName(), itemName, XHelper.class.getName(), itemElement);
        } else if (UUID.class.getName().equals(type)) {
            writer.code("%s %s = %s.readUUID(%s, \".\");", UUID.class.getName(), itemName, XHelper.class.getName(), itemElement);
        } else if ("byte[]".equals(type)) {
            writer.code("byte[] %s = %s.readBytes(%s, \".\");", itemName, XHelper.class.getName(), itemElement);
        } else if ("Object".equals(type) || "java.lang.Object".equals(type)) {
            writer.code("Object %s = %s.readObject(%s, \".\");", itemName, XHelper.class.getName(), itemElement);
        } else {
            throw new Exception(String.format("fromXML(): unsupported element type %s of collection %s in entity %s", type, coll.getId(), bt.getId()));
        }
    }

    static void generateToXML(JavaWriter writer, EntityCollection coll, BaseType bt, GenerationContext ctx) throws Exception {
        writer.comment("COLLECTION %s", coll.getId());
        if (coll.isNullable()) {
            String propName = MetaRegistryHelper.getNullableCollectionPropName(coll.getId());
            writer.code("%s.writeBoolean(elm, \"%s\", %2$s);", XHelper.class.getName(), propName);
        }
        if (Map.class.getName().equals(coll.getType())) {
            String keyType = ModelCodeGenHelper.getType(coll, ctx, true);
            String elementType = ModelCodeGenHelper.getType(coll, ctx, false);
            writer.beginBlock("for (java.util.Map.Entry<%s, %s> entry : %s.entrySet())", keyType, elementType, coll.getId());
            writer.code("%s key = entry.getKey();", keyType);
            writer.code("%s value = entry.getValue();", elementType);
            writer.code("%s entryElm = %s.addElement(elm, \"%s/entry\");", Element.class.getName(), XmlUtil.class.getName(), coll.getId());
            CollectionGenerator.generateItemToXML(writer, coll, bt, ctx, "key", "key", "entryElm", true);
            CollectionGenerator.generateItemToXML(writer, coll, bt, ctx, "value", "value", "entryElm", false);
        } else {
            String elementType = ModelCodeGenHelper.getType(coll, ctx, false);
            writer.beginBlock("for (%s item : %s)", elementType, coll.getId());
            CollectionGenerator.generateItemToXML(writer, coll, bt, ctx, "item", String.format("%s/item", coll.getId()), "elm", false);
        }
        writer.endBlock();
    }

    static void generateWriteXMLElements(JavaWriter writer, EntityCollection coll, BaseType bt, GenerationContext ctx) throws Exception {
        writer.comment("COLLECTION %s", coll.getId());
        if (coll.isNullable()) {
            String propName = MetaRegistryHelper.getNullableCollectionPropName(coll.getId());
            writer.code("%s.writeBoolean(writer, \"%s\", %2$s);", XSHelper.class.getName(), propName);
        }
        if (Map.class.isAssignableFrom(Class.forName(coll.getType()))) {
            writer.beginBlock("if (!%s.isEmpty())", coll.getId());
        } else {
            writer.beginBlock("if (!%s.isEmpty() && !%s.containsOnlyNulls(%1$s))", coll.getId(), CollectionUtil.class.getName());
        }
        writer.code("writer.writeStartElement(\"%s\");", coll.getId());
        if (Map.class.getName().equals(coll.getType())) {
            String keyType = ModelCodeGenHelper.getType(coll, ctx, true);
            String elementType = ModelCodeGenHelper.getType(coll, ctx, false);
            writer.beginBlock("for (java.util.Map.Entry<%s, %s> entry : %s.entrySet())", keyType, elementType, coll.getId());
            writer.code("%s key = entry.getKey();", keyType);
            writer.code("%s value = entry.getValue();", elementType);
            writer.code("writer.writeStartElement(\"entry\");", new Object[0]);
            CollectionGenerator.generateItemWriteXMLElements(writer, coll, bt, ctx, "key", "key", true);
            CollectionGenerator.generateItemWriteXMLElements(writer, coll, bt, ctx, "value", "value", false);
            writer.code("writer.writeEndElement();", new Object[0]);
        } else {
            String elementType = ModelCodeGenHelper.getType(coll, ctx, false);
            writer.beginBlock("for (%s item : %s)", elementType, coll.getId());
            CollectionGenerator.generateItemWriteXMLElements(writer, coll, bt, ctx, "item", "item", false);
        }
        writer.endBlock();
        writer.code("writer.writeEndElement();", new Object[0]);
        writer.endBlock();
    }

    static void generateCopyFrom(JavaWriter writer, EntityCollection coll, BaseType bt, GenerationContext ctx) throws Exception {
        writer.comment("COLLECTION %s", coll.getId());
        if (coll.isNullable()) {
            String propName = MetaRegistryHelper.getNullableCollectionPropName(coll.getId());
            writer.code("this.%s = source.%1$s;", propName);
        }
        if (Map.class.isAssignableFrom(Class.forName(coll.getType()))) {
            writer.code("this.%s.clear(); this.%1$s.putAll(%s.cloneMap(source.%1$s, newUids, uids));", coll.getId(), XCloneHelper.class.getName());
        } else {
            writer.code("this.%s.clear(); this.%1$s.addAll(%s.cloneCollection(source.%1$s, newUids, uids));", coll.getId(), XCloneHelper.class.getName());
        }
    }

    static void generateItemWriteXMLElements(JavaWriter writer, EntityCollection coll, BaseType bt, GenerationContext ctx, String itemVariable, String itemName, boolean key) throws Exception {
        String type;
        String string = type = key ? coll.getKeyType() : coll.getElementType();
        if (ctx.getMetaRegistry().getEnums().containsKey(type) || ctx.getMetaRegistry().getEnumRefs().containsKey(type)) {
            writer.code("%s.writeEnum(writer, \"%s\", %s);", XSHelper.class.getName(), itemName, itemVariable);
        } else if (ctx.getMetaRegistry().getEntities().containsKey(type) || ctx.getMetaRegistry().getEntityRefs().containsKey(type)) {
            writer.code("%s.writeObject(writer, \"%s\", %s);", XSHelper.class.getName(), itemName, itemVariable);
        } else if (ctx.getMetaRegistry().getDictionaries().containsKey(type)) {
            writer.beginBlock();
            writer.code("%s<String, String> attributes = new %s<String, String>();", Map.class.getName(), HashMap.class.getName());
            writer.code("attributes.put(\"class\", \"%sReference\");", type);
            writer.beginBlock("if (!%s.isBlank(%s.getCaption()))", TextUtil.class.getName(), itemVariable);
            writer.code("attributes.put(\"caption\", %s.getCaption());", itemVariable);
            writer.endBlock();
            writer.code("%s.writeString(writer, \"%s\", %s.getCode(), attributes);", XSHelper.class.getName(), itemName, itemVariable);
            writer.endBlock();
        } else if ("String".equals(type)) {
            writer.code("%s.writeString(writer, \"%s\", %s);", XSHelper.class.getName(), itemName, itemVariable);
        } else if ("text".equals(type)) {
            writer.code("%s.writeString(writer, \"%s\", %s, true);", XSHelper.class.getName(), itemName, itemVariable);
        } else if ("Boolean".equals(type)) {
            writer.code("%s.writeBoolean(writer, \"%s\", %s);", XSHelper.class.getName(), itemName, itemVariable);
        } else if ("Byte".equals(type)) {
            writer.code("%s.writeByte(writer, \"%s\", %s);", XSHelper.class.getName(), itemName, itemVariable);
        } else if ("Character".equals(type)) {
            writer.code("%s.writeChar(writer, \"%s\", %s);", XSHelper.class.getName(), itemName, itemVariable);
        } else if ("Short".equals(type)) {
            writer.code("%s.writeShort(writer, \"%s\", %s);", XSHelper.class.getName(), itemName, itemVariable);
        } else if ("Integer".equals(type)) {
            writer.code("%s.writeInt(writer, \"%s\", %s);", XSHelper.class.getName(), itemName, itemVariable);
        } else if ("Long".equals(type)) {
            writer.code("%s.writeLong(writer, \"%s\", %s);", XSHelper.class.getName(), itemName, itemVariable);
        } else if ("Float".equals(type)) {
            writer.code("%s.writeFloat(writer, \"%s\", %s);", XSHelper.class.getName(), itemName, itemVariable);
        } else if ("Double".equals(type)) {
            writer.code("%s.writeDouble(writer, \"%s\", %s);", XSHelper.class.getName(), itemName, itemVariable);
        } else if (BigDecimal.class.getName().equals(type)) {
            writer.code("%s.writeBigDecimal(writer, \"%s\", %s);", XSHelper.class.getName(), itemName, itemVariable);
        } else if (BigInteger.class.getName().equals(type)) {
            writer.code("%s.writeBigInteger(writer, \"%s\", %s);", XSHelper.class.getName(), itemName, itemVariable);
        } else if (Date.class.getName().equals(type)) {
            writer.code("%s.writeDate(writer, \"%s\", %s);", XSHelper.class.getName(), itemName, itemVariable);
        } else if (LocalDate.class.getName().equals(type)) {
            writer.code("%s.writeJavaLocalDate(writer, \"%s\", %s);", XSHelper.class.getName(), itemName, itemVariable);
        } else if (LocalDateTime.class.getName().equals(type)) {
            writer.code("%s.writeJavaLocalDateTime(writer, \"%s\", %s);", XSHelper.class.getName(), itemName, itemVariable);
        } else if (LocalTime.class.getName().equals(type)) {
            writer.code("%s.writeJavaLocalTime(writer, \"%s\", %s);", XSHelper.class.getName(), itemName, itemVariable);
        } else if (OffsetDateTime.class.getName().equals(type)) {
            writer.code("%s.writeJavaOffsetDateTime(writer, \"%s\", %s);", XSHelper.class.getName(), itemName, itemVariable);
        } else if (DayOfWeek.class.getName().equals(type)) {
            writer.code("%s.writeJavaDayOfWeek(writer, \"%s\", %s);", XSHelper.class.getName(), itemName, itemVariable);
        } else if (Locale.class.getName().equals(type)) {
            writer.code("%s.writeLocale(writer, \"%s\", %s);", XSHelper.class.getName(), itemName, itemVariable);
        } else if (URL.class.getName().equals(type)) {
            writer.code("%s.writeURL(writer, \"%s\", %s);", XSHelper.class.getName(), itemName, itemVariable);
        } else if (URI.class.getName().equals(type)) {
            writer.code("%s.writeURI(writer, \"%s\", %s);", XSHelper.class.getName(), itemName, itemVariable);
        } else if (UUID.class.getName().equals(type)) {
            writer.code("%s.writeUUID(writer, \"%s\", %s);", XSHelper.class.getName(), itemName, itemVariable);
        } else if ("byte[]".equals(type)) {
            writer.code("%s.writeBytes(writer, \"%s\", %s, \"base64\");", XSHelper.class.getName(), itemName, itemVariable);
        } else if ("Object".equals(type) || "java.lang.Object".equals(type)) {
            writer.code("%s.writeObject(writer, \"%s\", %s);", XSHelper.class.getName(), itemName, itemVariable);
        } else {
            throw new Exception(String.format("toXML(): unsupported element type %s of collection %s in entity %s", type, coll.getId(), bt.getId()));
        }
    }

    static void generateItemToXML(JavaWriter writer, EntityCollection coll, BaseType bt, GenerationContext ctx, String itemName, String itemPath, String itemElement, boolean key) throws Exception {
        String type;
        String string = type = key ? coll.getKeyType() : coll.getElementType();
        if (ctx.getMetaRegistry().getEnums().containsKey(type) || ctx.getMetaRegistry().getEnumRefs().containsKey(type)) {
            writer.code("%s.writeEnum(%s, \"%s\", %s);", XHelper.class.getName(), itemElement, itemPath, itemName);
        } else if (ctx.getMetaRegistry().getEntities().containsKey(type) || ctx.getMetaRegistry().getEntityRefs().containsKey(type)) {
            writer.code("%s.writeObject(%s, \"%s\", %s);", XHelper.class.getName(), itemElement, itemPath, itemName);
        } else if (ctx.getMetaRegistry().getDictionaries().containsKey(type)) {
            writer.beginBlock();
            writer.code("%s elm2 = %s.writeString(%s, \"%s\", %s.getCode());", Element.class.getName(), XHelper.class.getName(), itemElement, itemPath, itemName);
            writer.code("elm2.setAttribute(\"class\", \"%sReference\");", type);
            writer.beginBlock("if (!%s.isBlank(%s.getCaption()))", TextUtil.class.getName(), itemName);
            writer.code("elm2.setAttribute(\"caption\", %s.getCaption());", itemName);
            writer.endBlock();
            writer.endBlock();
        } else if ("String".equals(type)) {
            writer.code("%s.writeString(%s, \"%s\", %s);", XHelper.class.getName(), itemElement, itemPath, itemName);
        } else if ("text".equals(type)) {
            writer.code("%s.writeString(%s, \"%s\", %s, true);", XHelper.class.getName(), itemElement, itemPath, itemName);
        } else if ("Boolean".equals(type)) {
            writer.code("%s.writeBoolean(%s, \"%s\", %s);", XHelper.class.getName(), itemElement, itemPath, itemName);
        } else if ("Byte".equals(type)) {
            writer.code("%s.writeByte(%s, \"%s\", %s);", XHelper.class.getName(), itemElement, itemPath, itemName);
        } else if ("Character".equals(type)) {
            writer.code("%s.writeChar(%s, \"%s\", %s);", XHelper.class.getName(), itemElement, itemPath, itemName);
        } else if ("Short".equals(type)) {
            writer.code("%s.writeShort(%s, \"%s\", %s);", XHelper.class.getName(), itemElement, itemPath, itemName);
        } else if ("Integer".equals(type)) {
            writer.code("%s.writeInt(%s, \"%s\", %s);", XHelper.class.getName(), itemElement, itemPath, itemName);
        } else if ("Long".equals(type)) {
            writer.code("%s.writeLong(%s, \"%s\", %s);", XHelper.class.getName(), itemElement, itemPath, itemName);
        } else if ("Float".equals(type)) {
            writer.code("%s.writeFloat(%s, \"%s\", %s);", XHelper.class.getName(), itemElement, itemPath, itemName);
        } else if ("Double".equals(type)) {
            writer.code("%s.writeDouble(%s, \"%s\", %s);", XHelper.class.getName(), itemElement, itemPath, itemName);
        } else if (BigDecimal.class.getName().equals(type)) {
            writer.code("%s.writeBigDecimal(%s, \"%s\", %s);", XHelper.class.getName(), itemElement, itemPath, itemName);
        } else if (BigInteger.class.getName().equals(type)) {
            writer.code("%s.writeBigInteger(%s, \"%s\", %s);", XHelper.class.getName(), itemElement, itemPath, itemName);
        } else if (Date.class.getName().equals(type)) {
            writer.code("%s.writeDate(%s, \"%s\", %s);", XHelper.class.getName(), itemElement, itemPath, itemName);
        } else if (LocalDate.class.getName().equals(type)) {
            writer.code("%s.writeJavaLocalDate(%s, \"%s\", %s);", XHelper.class.getName(), itemElement, itemPath, itemName);
        } else if (LocalDateTime.class.getName().equals(type)) {
            writer.code("%s.writeJavaLocalDateTime(%s, \"%s\", %s);", XHelper.class.getName(), itemElement, itemPath, itemName);
        } else if (LocalTime.class.getName().equals(type)) {
            writer.code("%s.writeJavaLocalTime(%s, \"%s\", %s);", XHelper.class.getName(), itemElement, itemPath, itemName);
        } else if (OffsetDateTime.class.getName().equals(type)) {
            writer.code("%s.writeJavaOffsetDateTime(%s, \"%s\", %s);", XHelper.class.getName(), itemElement, itemPath, itemName);
        } else if (DayOfWeek.class.getName().equals(type)) {
            writer.code("%s.writeJavaDayOfWeek(%s, \"%s\", %s);", XHelper.class.getName(), itemElement, itemPath, itemName);
        } else if (Locale.class.getName().equals(type)) {
            writer.code("%s.writeLocale(%s, \"%s\", %s);", XHelper.class.getName(), itemElement, itemPath, itemName);
        } else if (URL.class.getName().equals(type)) {
            writer.code("%s.writeURL(%s, \"%s\", %s);", XHelper.class.getName(), itemElement, itemPath, itemName);
        } else if (URI.class.getName().equals(type)) {
            writer.code("%s.writeURI(%s, \"%s\", %s);", XHelper.class.getName(), itemElement, itemPath, itemName);
        } else if (UUID.class.getName().equals(type)) {
            writer.code("%s.writeUUID(%s, \"%s\", %s);", XHelper.class.getName(), itemElement, itemPath, itemName);
        } else if ("byte[]".equals(type)) {
            writer.code("%s.writeBytes(%s, \"%s\", %s, \"base64\");", XHelper.class.getName(), itemElement, itemPath, itemName);
        } else if ("Object".equals(type) || "java.lang.Object".equals(type)) {
            writer.code("%s.writeObject(%s, \"%s\", %s);", XHelper.class.getName(), itemElement, itemPath, itemName);
        } else {
            throw new Exception(String.format("toXML(): unsupported element type %s of collection %s in entity %s", type, coll.getId(), bt.getId()));
        }
    }

    private static String getType(IndexCollection coll, GenerationContext ctx) {
        String elementType;
        if (ctx.getMetaRegistry().getDictionaries().containsKey(coll.getElementType())) {
            elementType = String.format("%s<%s>", DictionaryReference.class.getName(), coll.getElementType());
        } else if (ModelCodeGenHelper.isNestedEntityReferenceType(coll.getElementType())) {
            MiscUtil.Pair<String, String> types = ModelCodeGenHelper.getNestedEntityReferenceTypes(coll.getElementType());
            elementType = String.format("%s<%s, %s>", NestedEntityReference.class.getName(), types.getFirst(), types.getSecond());
        } else if (ctx.getMetaRegistry().getEntities().containsKey(coll.getElementType()) || ctx.getMetaRegistry().getEntityRefs().containsKey(coll.getElementType())) {
            String subtype = coll.getElementType();
            EntityType ett = ctx.getMetaRegistry().getEntities().get(coll.getElementType());
            if (ett == null || ett.isAbstract()) {
                subtype = "? extends " + subtype;
            }
            elementType = EntityReference.class.getName() + "<" + subtype + ">";
        } else {
            elementType = "text".equals(coll.getElementType()) ? "String" : coll.getElementType();
        }
        return elementType;
    }
}

