/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.gen.model;

import com.gridnine.xtrip.common.gen.CodeGen;
import com.gridnine.xtrip.common.gen.GenUtil;
import com.gridnine.xtrip.common.gen.GenerationContext;
import com.gridnine.xtrip.common.gen.JavaWriter;
import com.gridnine.xtrip.common.gen.model.CollectionGenerator;
import com.gridnine.xtrip.common.gen.model.ModelCodeGenHelper;
import com.gridnine.xtrip.common.gen.model.PropertyGenerator;
import com.gridnine.xtrip.common.gen.model.ValidationContextGenerator;
import com.gridnine.xtrip.common.l10n.model.LocaleString;
import com.gridnine.xtrip.common.meta.BaseMetaElement;
import com.gridnine.xtrip.common.meta.BaseProperty;
import com.gridnine.xtrip.common.meta.BaseReferenceProperty;
import com.gridnine.xtrip.common.meta.BaseType;
import com.gridnine.xtrip.common.meta.DictionaryProperty;
import com.gridnine.xtrip.common.meta.DictionaryType;
import com.gridnine.xtrip.common.meta.EntityCollection;
import com.gridnine.xtrip.common.meta.EntityType;
import com.gridnine.xtrip.common.meta.EnumItem;
import com.gridnine.xtrip.common.meta.EnumType;
import com.gridnine.xtrip.common.meta.IndexCollection;
import com.gridnine.xtrip.common.meta.IndexProperty;
import com.gridnine.xtrip.common.meta.IndexType;
import com.gridnine.xtrip.common.meta.InterfaceType;
import com.gridnine.xtrip.common.meta.MetaRegistry;
import com.gridnine.xtrip.common.meta.MetaRegistryHelper;
import com.gridnine.xtrip.common.meta.Property;
import com.gridnine.xtrip.common.meta.ValidationMessageItem;
import com.gridnine.xtrip.common.meta.ValidationMessagesType;
import com.gridnine.xtrip.common.meta.reflection.MetaReflectionHelper;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Validatable;
import com.gridnine.xtrip.common.model.ValidationContext;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.validation.ValidationMessage;
import com.gridnine.xtrip.common.model.validation.ValidationMessagesFactory;
import com.gridnine.xtrip.common.usage.IndexUsageHandler;
import com.gridnine.xtrip.common.util.Identity;
import com.gridnine.xtrip.common.util.InvocationContext;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XReference;
import com.gridnine.xtrip.common.util.XSerializable;
import com.gridnine.xtrip.common.xml.XHelper;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class ModelCodeGen
implements CodeGen {
    private final transient Logger log = LoggerFactory.getLogger(this.getClass());
    private static final String LOCALE_STRING_INTERFACE = LocaleString.class.getName();
    private static final Map<String, String> PRIMITIVES_TO_WRAPPERS = new HashMap<String, String>();

    @Override
    public void generate(GenerationContext ctx) throws Exception {
        JavaWriter writer = new JavaWriter();
        for (EnumType enm : ctx.getMetaRegistry().getEnums().values()) {
            if (!ctx.getTypeFilter().accept(enm)) continue;
            this.generateEnum(writer, ctx, enm);
        }
        for (ValidationMessagesType vmt : ctx.getMetaRegistry().getValidationMessages().values()) {
            if (!ctx.getTypeFilter().accept(vmt)) continue;
            this.generateValidationMessages(writer, ctx, vmt);
        }
        for (DictionaryType dict : ctx.getMetaRegistry().getDictionaries().values()) {
            if (!ctx.getTypeFilter().accept(dict)) continue;
            this.generateDictionary(writer, ctx, dict);
            if (dict.isAbstract()) continue;
            this.generateDictionaryReference(writer, ctx, dict);
        }
        for (InterfaceType intrf : ctx.getMetaRegistry().getInterfaces().values()) {
            if (!ctx.getTypeFilter().accept(intrf)) continue;
            this.generateInterface(writer, ctx, intrf);
        }
        for (EntityType ett : ctx.getMetaRegistry().getEntities().values()) {
            if (!ctx.getTypeFilter().accept(ett)) continue;
            this.generateEntity(writer, ctx, ett);
        }
        for (IndexType idx : ctx.getMetaRegistry().getIndexes().values()) {
            if (!ctx.getTypeFilter().accept(idx)) continue;
            this.generateIndex(writer, ctx, idx);
            this.generateInstrumentedIndex(writer, ctx, idx);
        }
    }

    private void generateEnum(JavaWriter writer, GenerationContext ctx, EnumType enm) throws IOException {
        this.log.debug("generating enum " + enm.getId());
        writer.beginCompilationUnit(ctx.getOutFolder(), enm.getId());
        ModelCodeGenHelper.generateTypeDoc(writer, ctx, enm, "Enum");
        if (enm.isDeprecated()) {
            writer.code("@Deprecated", new Object[0]);
        }
        StringBuilder impl = new StringBuilder();
        List<String> interfaces = enm.getInterfaces();
        if (!interfaces.contains(LOCALE_STRING_INTERFACE)) {
            impl.append(LOCALE_STRING_INTERFACE);
        }
        for (String string : interfaces) {
            if (impl.length() > 0) {
                impl.append(", ");
            }
            impl.append(string);
        }
        if (impl.length() > 0) {
            impl.insert(0, "implements ");
        }
        writer.beginBlock("public enum %s %s", GenUtil.getSimpleClassName(enm.getId()), impl);
        writer.comment("BEGIN items", new Object[0]);
        int i = 1;
        for (EnumItem item : enm.getItems().values()) {
            if (TextUtil.nonBlank(item.getCodeFragment())) {
                writer.code("%s {", item.getId());
                writer.code(item.getCodeFragment(), new Object[0]);
                writer.code("}%s", i++ == enm.getItems().size() ? ";" : ",");
                continue;
            }
            writer.code("%s%s", item.getId(), i++ == enm.getItems().size() ? ";" : ",");
        }
        if (enm.getItems().values().isEmpty()) {
            writer.code(";", new Object[0]);
        }
        writer.comment("END items", new Object[0]);
        writer.comment("BEGIN code fragments", new Object[0]);
        for (String string : enm.getCodeFragments("model")) {
            writer.code(string, new Object[0]);
            writer.blank();
        }
        writer.comment("END code fragments", new Object[0]);
        writer.beginBlock("public String toString(final java.util.Locale locale)", new Object[0]);
        writer.code("%s et = %s.get().getEnums().get(\"%s\");", EnumType.class.getName(), MetaRegistry.class.getName(), enm.getId());
        writer.beginBlock("if (et == null)", new Object[0]);
        writer.code("return name();", new Object[0]);
        writer.endBlock();
        writer.code("%s ei = et.getItems().get(name());", EnumItem.class.getName());
        writer.code("return (ei == null) ? name() : (locale == null) ? ei.getDisplayName() : ei.getDisplayName(locale);", new Object[0]);
        writer.endBlock();
        writer.blank();
        writer.beginBlock("public String toString()", new Object[0]);
        writer.code("return this.toString(null);", new Object[0]);
        writer.endBlock();
        writer.endBlock();
        writer.endCompilationUnit();
    }

    private void generateValidationMessages(JavaWriter writer, GenerationContext ctx, ValidationMessagesType vmt) throws IOException {
        this.log.debug("generating validation messages " + vmt.getId());
        writer.beginCompilationUnit(ctx.getOutFolder(), vmt.getId());
        ModelCodeGenHelper.generateTypeDoc(writer, ctx, vmt, "Validation messages");
        if (vmt.isDeprecated()) {
            writer.code("@Deprecated", new Object[0]);
        }
        writer.beginBlock("public final class %s extends %s", GenUtil.getSimpleClassName(vmt.getId()), ValidationMessagesFactory.class.getName());
        for (ValidationMessageItem item : vmt.getMessages().values()) {
            String spec = "";
            String args = "";
            for (Map.Entry<String, String> entry : item.getParameters().entrySet()) {
                if (spec.length() > 0) {
                    spec = spec + ", ";
                }
                spec = spec + ModelCodeGenHelper.getJavaType(entry.getValue(), ctx) + ' ' + entry.getKey();
                args = args + ", " + entry.getKey();
            }
            if (item.isDeprecated()) {
                writer.code("@Deprecated", new Object[0]);
            }
            writer.beginBlock("public static %s get%s(%s)", ValidationMessage.class.getName(), GenUtil.capitalize(item.getId()), spec);
            writer.code("return getMessage(\"%s\", \"%s\"%s);", vmt.getId(), item.getId(), args);
            writer.endBlock();
        }
        writer.beginBlock("private %s()", GenUtil.getSimpleClassName(vmt.getId()));
        writer.comment("no-op", new Object[0]);
        writer.endBlock();
        writer.endBlock();
        writer.endCompilationUnit();
    }

    private void generateDictionary(JavaWriter writer, GenerationContext ctx, DictionaryType dict) throws Exception {
        String propName;
        String extendsId;
        this.log.debug("generating dictionary " + dict.getId());
        writer.beginCompilationUnit(ctx.getOutFolder(), dict.getId());
        ModelCodeGenHelper.generateTypeDoc(writer, ctx, dict, "Dictionary");
        String baseName = GenUtil.getSimpleClassName(dict.getId());
        String modifier = "";
        if (dict.isAbstract()) {
            modifier = modifier + "abstract";
        }
        if (TextUtil.isBlank(extendsId = dict.getExtendsId())) {
            extendsId = BaseDictionary.class.getName();
        }
        StringBuilder impl = new StringBuilder();
        for (String string : dict.getInterfaces()) {
            if (impl.length() > 0) {
                impl.append(", ");
            }
            impl.append(string);
        }
        if (impl.length() > 0) {
            impl.insert(0, "implements ");
        }
        if (dict.isDeprecated()) {
            writer.code("@Deprecated", new Object[0]);
        }
        writer.beginBlock("public %s class %s extends %s %s", modifier, GenUtil.getSimpleClassName(dict.getId()), extendsId, impl);
        writer.code("private static final long serialVersionUID = %sL;", GenUtil.generateSerialVersionUID(dict.getId(), dict.getProperties(), dict.getCollections()));
        writer.blank();
        writer.comment("BEGIN factory support", new Object[0]);
        writer.beginBlock("public %s()", GenUtil.getSimpleClassName(dict.getId()));
        writer.code("super();", new Object[0]);
        writer.endBlock();
        writer.beginBlock("public %s(final String uid)", GenUtil.getSimpleClassName(dict.getId()));
        writer.code("super(uid);", new Object[0]);
        writer.endBlock();
        if (!dict.isAbstract()) {
            writer.beginBlock("public %s newInstance(final String uid)", BaseEntity.class.getName());
            writer.code("return new %s(uid);", GenUtil.getSimpleClassName(dict.getId()));
            writer.endBlock();
        }
        writer.comment("END factory support", new Object[0]);
        writer.beginBlock("public static enum Property", new Object[0]);
        writer.comment("properties", new Object[0]);
        for (DictionaryProperty dictionaryProperty : dict.getProperties().values()) {
            writer.code("%s,", dictionaryProperty.getId());
        }
        writer.comment("collections", new Object[0]);
        for (EntityCollection entityCollection : dict.getCollections().values()) {
            writer.code("%s,", entityCollection.getId());
        }
        writer.endBlock();
        writer.comment("BEGIN properties", new Object[0]);
        for (DictionaryProperty dictionaryProperty : dict.getProperties().values()) {
            PropertyGenerator.generateAccessors(writer, dictionaryProperty, dict, ctx);
        }
        writer.comment("END properties", new Object[0]);
        writer.comment("BEGIN collections", new Object[0]);
        for (EntityCollection entityCollection : dict.getCollections().values()) {
            CollectionGenerator.generateAccessors(writer, entityCollection, (BaseType)dict, ctx);
        }
        writer.comment("END collections", new Object[0]);
        writer.comment("BEGIN code fragments", new Object[0]);
        for (String string : dict.getCodeFragments("model")) {
            writer.code(string, new Object[0]);
            writer.blank();
        }
        writer.comment("END code fragments", new Object[0]);
        writer.beginBlock("public Object getValue(final String memberId)", dict.getId());
        writer.beginBlock("switch (memberId)", new Object[0]);
        writer.comment("BEGIN properties", new Object[0]);
        for (DictionaryProperty dictionaryProperty : dict.getProperties().values()) {
            writer.beginBlock("case \"%s\":", dictionaryProperty.getId());
            if (!this.handlePrimitiveWrappingInIntrospectable(writer, dictionaryProperty)) {
                writer.code("return this.%s;", dictionaryProperty.getId());
            }
            writer.endBlock();
        }
        writer.comment("END properties", new Object[0]);
        writer.comment("BEGIN collections", new Object[0]);
        for (EntityCollection entityCollection : dict.getCollections().values()) {
            writer.beginBlock("case \"%s\":", entityCollection.getId());
            writer.code("return this.%s;", entityCollection.getId());
            writer.endBlock();
            if (!entityCollection.isNullable()) continue;
            propName = MetaRegistryHelper.getNullableCollectionPropName(entityCollection.getId());
            writer.beginBlock("case \"%s\":", propName);
            writer.code("return this.%s;", propName);
            writer.endBlock();
        }
        writer.comment("END collections", new Object[0]);
        writer.beginBlock("default:", new Object[0]);
        writer.code("return super.getValue(memberId);", new Object[0]);
        writer.endBlock();
        writer.endBlock();
        writer.endBlock();
        writer.beginBlock("public void setValue(final String memberId, Object value)", new Object[0]);
        writer.beginBlock("switch (memberId)", new Object[0]);
        writer.comment("BEGIN properties", new Object[0]);
        for (DictionaryProperty dictionaryProperty : dict.getProperties().values()) {
            if (dictionaryProperty.isHistorical() || dictionaryProperty.isPeriodical()) continue;
            writer.beginBlock("case \"%s\":", dictionaryProperty.getId());
            writer.code("this.%s = (%s) value;", dictionaryProperty.getId(), MetaReflectionHelper.getTypeForIntrospection(dictionaryProperty, ctx.getMetaRegistry()));
            writer.code("return;", new Object[0]);
            writer.endBlock();
        }
        writer.comment("END properties", new Object[0]);
        writer.comment("BEGIN collections", new Object[0]);
        for (EntityCollection entityCollection : dict.getCollections().values()) {
            if (!entityCollection.isNullable()) continue;
            propName = MetaRegistryHelper.getNullableCollectionPropName(entityCollection.getId());
            writer.beginBlock("case \"%s\":", propName);
            writer.code("this.%s = (Boolean) value;", propName);
            writer.code("return;", new Object[0]);
            writer.endBlock();
        }
        writer.comment("END collections", new Object[0]);
        writer.beginBlock("default:", new Object[0]);
        writer.code("super.setValue(memberId, value);", new Object[0]);
        writer.endBlock();
        writer.endBlock();
        writer.endBlock();
        writer.comment("BEGIN %s implementation", XSerializable.class.getName());
        writer.code("@Override", new Object[0]);
        writer.beginBlock("public void fromXML(final %s elm) throws Exception", Element.class.getName());
        writer.code("boolean doExit = %s.get(\"entityDeserialize\").enter(this);", InvocationContext.class.getName());
        writer.beginBlock("try", new Object[0]);
        ModelCodeGenHelper.generatePropertyRenamerCode(writer, dict.getPropertiesRenamers(), "elm");
        writer.code("super.fromXML(elm);", new Object[0]);
        for (DictionaryProperty dictionaryProperty : dict.getProperties().values()) {
            PropertyGenerator.generateFromXML(writer, dictionaryProperty, dict, ctx);
        }
        for (EntityCollection entityCollection : dict.getCollections().values()) {
            CollectionGenerator.generateFromXML(writer, entityCollection, dict, ctx);
        }
        writer.restartBlock("finally", new Object[0]);
        writer.beginBlock("if (doExit)", new Object[0]);
        writer.code("%s.get(\"entityDeserialize\").exit();", InvocationContext.class.getName());
        writer.endBlock();
        writer.endBlock();
        writer.endBlock();
        writer.code("@Override", new Object[0]);
        writer.beginBlock("public void toXML(final %s elm) throws Exception", Element.class.getName());
        writer.code("boolean doExit = %s.get(\"entitySerialize\").enter(this);", InvocationContext.class.getName());
        writer.beginBlock("try", new Object[0]);
        writer.code("super.toXML(elm);", new Object[0]);
        for (DictionaryProperty dictionaryProperty : dict.getProperties().values()) {
            PropertyGenerator.generateToXML(writer, dictionaryProperty, dict, ctx);
        }
        for (EntityCollection entityCollection : dict.getCollections().values()) {
            CollectionGenerator.generateToXML(writer, entityCollection, dict, ctx);
        }
        writer.restartBlock("finally", new Object[0]);
        writer.beginBlock("if (doExit)", new Object[0]);
        writer.code("%s.get(\"entitySerialize\").exit();", InvocationContext.class.getName());
        writer.endBlock();
        writer.endBlock();
        writer.endBlock();
        writer.comment("END %s implementation", XSerializable.class.getName());
        writer.blank();
        writer.comment("BEGIN %s implementation", BaseEntity.class.getName());
        writer.code("@Override", new Object[0]);
        writer.beginBlock("protected boolean readXMLElement(final %s reader) throws Exception", XMLStreamReader.class.getName());
        writer.code("throw new UnsupportedOperationException();", new Object[0]);
        writer.endBlock();
        writer.code("@Override", new Object[0]);
        writer.beginBlock("protected void writeXMLElements(final %s writer) throws Exception", XMLStreamWriter.class.getName());
        writer.code("boolean doExit = %s.get(\"entitySerialize\").enter(this);", InvocationContext.class.getName());
        writer.beginBlock("try", new Object[0]);
        writer.code("super.writeXMLElements(writer);", new Object[0]);
        for (DictionaryProperty dictionaryProperty : dict.getProperties().values()) {
            PropertyGenerator.generateWriteXMLElements(writer, dictionaryProperty, dict, ctx);
        }
        for (EntityCollection entityCollection : dict.getCollections().values()) {
            CollectionGenerator.generateWriteXMLElements(writer, entityCollection, dict, ctx);
        }
        writer.restartBlock("finally", new Object[0]);
        writer.beginBlock("if (doExit)", new Object[0]);
        writer.code("%s.get(\"entitySerialize\").exit();", InvocationContext.class.getName());
        writer.endBlock();
        writer.endBlock();
        writer.endBlock();
        writer.code("@Override", new Object[0]);
        writer.beginBlock("public void copyFrom(final %s sourceEntity, final boolean newUids, final %s<String, String> uids) throws Exception", BaseEntity.class.getName(), Map.class.getName());
        writer.code("super.copyFrom(sourceEntity, newUids, uids);", new Object[0]);
        writer.beginBlock("if (sourceEntity instanceof %s)", dict.getId());
        writer.code("%s source = (%1$s) sourceEntity;", dict.getId());
        for (DictionaryProperty dictionaryProperty : dict.getProperties().values()) {
            PropertyGenerator.generateCopyFrom(writer, dictionaryProperty, dict, ctx);
        }
        for (EntityCollection entityCollection : dict.getCollections().values()) {
            CollectionGenerator.generateCopyFrom(writer, entityCollection, dict, ctx);
        }
        writer.endBlock();
        writer.endBlock();
        writer.comment("END %s implementation", BaseEntity.class.getName());
        writer.blank();
        if (!dict.isAbstract()) {
            writer.beginBlock("public %sReference toReference()", baseName);
            writer.code("return new %sReference(this);", baseName);
            writer.endBlock();
        }
        writer.endBlock();
        writer.endCompilationUnit();
    }

    private void generateDictionaryReference(JavaWriter writer, GenerationContext ctx, DictionaryType dict) throws Exception {
        this.log.debug("generating reference to dictionary " + dict.getId());
        writer.beginCompilationUnit(ctx.getOutFolder(), dict.getId() + "Reference");
        ModelCodeGenHelper.generateTypeDoc(writer, ctx, dict, "Dictionary reference");
        if (dict.isDeprecated()) {
            writer.code("@Deprecated", new Object[0]);
        }
        String baseName = GenUtil.getSimpleClassName(dict.getId());
        writer.beginBlock("public class %sReference extends %s<%1$s>", baseName, DictionaryReference.class.getName());
        writer.code("private static final long serialVersionUID = %sL;", GenUtil.generateSerialVersionUID(dict.getId() + "Reference", new HashMap(), new HashMap()));
        writer.blank();
        writer.beginBlock("public %sReference(final String code)", baseName);
        writer.code("super(code);", new Object[0]);
        writer.endBlock();
        writer.beginBlock("public %sReference(final String code, final String caption)", baseName);
        writer.code("super(code, caption);", new Object[0]);
        writer.endBlock();
        writer.beginBlock("public %sReference(final %1$s dict)", baseName);
        writer.code("super(dict);", new Object[0]);
        writer.endBlock();
        writer.beginBlock("public %sReference()", baseName);
        writer.code("super();", new Object[0]);
        writer.endBlock();
        writer.code("@Override", new Object[0]);
        writer.beginBlock("public Class<%s> getType()", baseName);
        writer.code("return %s.class;", baseName);
        writer.endBlock();
        writer.endBlock();
        writer.endCompilationUnit();
    }

    private void generateInterface(JavaWriter writer, GenerationContext ctx, InterfaceType intrf) throws Exception {
        this.log.debug("generating interface " + intrf.getId());
        writer.beginCompilationUnit(ctx.getOutFolder(), intrf.getId());
        ModelCodeGenHelper.generateTypeDoc(writer, ctx, intrf, "Interface");
        StringBuilder impl = new StringBuilder();
        for (String itf : intrf.getInterfaces()) {
            if (impl.length() > 0) {
                impl.append(", ");
            }
            impl.append(itf);
        }
        if (impl.length() > 0) {
            impl.insert(0, "extends ");
        }
        if (intrf.isDeprecated()) {
            writer.code("@Deprecated", new Object[0]);
        }
        writer.beginBlock("public interface %s %s", GenUtil.getSimpleClassName(intrf.getId()), impl);
        writer.blank();
        writer.comment("BEGIN properties", new Object[0]);
        for (Property prop : intrf.getProperties().values()) {
            String type;
            if (prop.isDeprecated()) {
                writer.code("@Deprecated", new Object[0]);
            }
            if ("boolean".equals(type = ModelCodeGenHelper.getType(prop, ctx))) {
                writer.code("%s is%s();", type, GenUtil.capitalize(prop.getId()));
            } else {
                writer.code("%s get%s();", type, GenUtil.capitalize(prop.getId()));
            }
            writer.blank();
        }
        writer.comment("END properties", new Object[0]);
        writer.blank();
        writer.comment("BEGIN collections", new Object[0]);
        for (EntityCollection coll : intrf.getCollections().values()) {
            if (coll.isDeprecated()) {
                writer.code("@Deprecated", new Object[0]);
            }
            String keyType = ModelCodeGenHelper.getType(coll, ctx, true);
            String elementType = ModelCodeGenHelper.getType(coll, ctx, false);
            if (Map.class.getName().equals(coll.getType())) {
                writer.code("%s<%s, %s> get%s();", coll.getType(), keyType, elementType, GenUtil.capitalize(coll.getId()));
            } else {
                writer.code("%s<%s> get%s();", coll.getType(), elementType, GenUtil.capitalize(coll.getId()));
            }
            writer.blank();
        }
        writer.comment("END collections", new Object[0]);
        writer.blank();
        writer.comment("BEGIN code fragments", new Object[0]);
        for (String codeFragment : intrf.getCodeFragments("model")) {
            writer.code(codeFragment, new Object[0]);
            writer.blank();
        }
        writer.comment("END code fragments", new Object[0]);
        writer.endBlock();
        writer.endCompilationUnit();
    }

    private void generateEntity(JavaWriter writer, GenerationContext ctx, EntityType ett) throws Exception {
        String propName;
        Object validContextName;
        String extendsId;
        this.log.debug("generating entity " + ett.getId());
        writer.beginCompilationUnit(ctx.getOutFolder(), ett.getId());
        ModelCodeGenHelper.generateTypeDoc(writer, ctx, ett, ModelCodeGenHelper.isRoot(ctx, ett) ? "<b>Root</b> entity" : "Entity");
        String modifier = "";
        if (ett.isAbstract()) {
            modifier = modifier + "abstract ";
        }
        if (TextUtil.isBlank(extendsId = ett.getExtendsId())) {
            extendsId = BaseEntity.class.getName();
        }
        StringBuilder impl = new StringBuilder();
        for (String itf : ett.getInterfaces()) {
            if (impl.length() > 0) {
                impl.append(", ");
            }
            impl.append(itf);
        }
        if (ModelCodeGenHelper.isValidatable(ett, ctx)) {
            if (impl.length() > 0) {
                impl.append(", ");
            }
            impl.append(Validatable.class.getName());
        }
        if (impl.length() > 0) {
            impl.insert(0, "implements ");
        }
        if (ett.isDeprecated()) {
            writer.code("@Deprecated", new Object[0]);
        }
        writer.beginBlock("public %sclass %s extends %s %s", modifier, GenUtil.getSimpleClassName(ett.getId()), extendsId, impl);
        writer.code("private static final long serialVersionUID = %sL;", GenUtil.generateSerialVersionUID(ett.getId(), ett.getProperties(), ett.getCollections()));
        writer.blank();
        writer.comment("BEGIN properties", new Object[0]);
        for (Property prop : ett.getProperties().values()) {
            if ("uid".equals(prop.getId())) {
                throw new Exception(String.format("'uid' property in entity %s is hiding the 'uid' property of BaseEntity", ett.getId()));
            }
            PropertyGenerator.generateAccessors(writer, prop, ett, ctx);
        }
        writer.comment("END properties", new Object[0]);
        writer.comment("BEGIN collections", new Object[0]);
        for (EntityCollection coll : ett.getCollections().values()) {
            CollectionGenerator.generateAccessors(writer, coll, (BaseType)ett, ctx);
        }
        writer.comment("END collections", new Object[0]);
        writer.comment("BEGIN code fragments", new Object[0]);
        for (String codeFragment : ett.getCodeFragments("model")) {
            writer.code(codeFragment, new Object[0]);
            writer.blank();
        }
        writer.comment("END code fragments", new Object[0]);
        if (ModelCodeGenHelper.isValidatable(ett, ctx)) {
            String validContextType = ModelCodeGenHelper.genValidationContextClassName(ett.getId());
            validContextName = "validationContext";
            writer.code("private final %s %s = new %s();", validContextType, validContextName, validContextType);
            writer.blank();
            writer.beginBlock("public %s get%s()", validContextType, GenUtil.capitalize(MiscUtil.getSimpleClassName(ValidationContext.class)));
            writer.code("return %s;", validContextName);
            writer.endBlock();
        }
        writer.comment("BEGIN factory support", new Object[0]);
        Iterator<BaseMetaElement> constructorCodeFragments = ett.getCodeFragments("constructor");
        if (constructorCodeFragments.isEmpty()) {
            writer.beginBlock("public %s()", GenUtil.getSimpleClassName(ett.getId()));
            writer.code("super();", new Object[0]);
            writer.endBlock();
            writer.beginBlock("public %s(final String uid)", GenUtil.getSimpleClassName(ett.getId()));
            writer.code("super(uid);", new Object[0]);
            writer.endBlock();
        } else {
            validContextName = constructorCodeFragments.iterator();
            while (validContextName.hasNext()) {
                String codeFragment = (String)validContextName.next();
                writer.code(codeFragment, new Object[0]);
                writer.blank();
            }
        }
        if (!ett.isAbstract()) {
            writer.beginBlock("public %s newInstance(final String uid)", BaseEntity.class.getName());
            writer.code("return new %s(uid);", GenUtil.getSimpleClassName(ett.getId()));
            writer.endBlock();
        }
        writer.comment("END factory support", new Object[0]);
        writer.beginBlock("public Object getValue(final String memberId)", ett.getId());
        writer.beginBlock("switch(memberId)", new Object[0]);
        writer.comment("BEGIN properties", new Object[0]);
        for (Property prop : ett.getProperties().values()) {
            writer.beginBlock("case \"%s\":", prop.getId());
            if (prop.isFinalProperty()) {
                writer.beginBlock("if(this.%s == null)", prop.getId());
                writer.code("this.%s = new %s();", prop.getId(), prop.getType());
                writer.endBlock();
            }
            if (!this.handlePrimitiveWrappingInIntrospectable(writer, prop)) {
                writer.code("return this.%s;", prop.getId());
            }
            writer.endBlock();
        }
        writer.comment("END properties", new Object[0]);
        writer.comment("BEGIN collections", new Object[0]);
        for (EntityCollection coll : ett.getCollections().values()) {
            writer.beginBlock("case \"%s\":", coll.getId());
            writer.code("return this.%s;", coll.getId());
            writer.endBlock();
            if (!coll.isNullable()) continue;
            propName = MetaRegistryHelper.getNullableCollectionPropName(coll.getId());
            writer.beginBlock("case \"%s\":", propName);
            writer.code("return this.%s;", propName);
            writer.endBlock();
        }
        writer.comment("END collections", new Object[0]);
        writer.beginBlock("default:", new Object[0]);
        writer.code("return super.getValue(memberId);", new Object[0]);
        writer.endBlock();
        writer.endBlock();
        writer.endBlock();
        writer.beginBlock("public void setValue(final String memberId, Object value)", ett.getId());
        writer.beginBlock("switch(memberId)", new Object[0]);
        writer.comment("BEGIN properties", new Object[0]);
        for (Property prop : ett.getProperties().values()) {
            if (prop.isHistorical() || prop.isPeriodical()) continue;
            writer.beginBlock("case \"%s\":", prop.getId());
            writer.code("this.%s = (%s) value;", prop.getId(), MetaReflectionHelper.getTypeForIntrospection(prop, ctx.getMetaRegistry()));
            writer.code("return;", new Object[0]);
            writer.endBlock();
        }
        writer.comment("END properties", new Object[0]);
        writer.comment("BEGIN collections", new Object[0]);
        for (EntityCollection coll : ett.getCollections().values()) {
            if (!coll.isNullable()) continue;
            propName = MetaRegistryHelper.getNullableCollectionPropName(coll.getId());
            writer.beginBlock("case \"%s\":", propName);
            writer.code("this.%s = (Boolean) value;", propName);
            writer.code("return;", new Object[0]);
            writer.endBlock();
        }
        writer.comment("END collections", new Object[0]);
        writer.beginBlock("default:", new Object[0]);
        writer.code("super.setValue(memberId, value);", new Object[0]);
        writer.endBlock();
        writer.endBlock();
        writer.endBlock();
        writer.comment("BEGIN %s implementation", XSerializable.class.getName());
        boolean isXReference = ett.getInterfaces().stream().anyMatch(i -> XReference.class.getName().equals(i));
        writer.code("@Override", new Object[0]);
        writer.beginBlock("public void fromXML(final %s elm) throws Exception", Element.class.getName());
        if (!isXReference) {
            writer.code("boolean doExit = false;", new Object[0]);
            writer.beginBlock("if (this instanceof %s)", Identity.class.getName());
            writer.comment("WE SET UID EXPLICITLY IN ORDER METHOD entityDeserialize TO HANDLE THIS IDENTITY CORRECTLY", new Object[0]);
            writer.code("String value = %s.readString(elm, \"uid\");", XHelper.class.getName());
            writer.beginBlock("if (value == null)", new Object[0]);
            writer.code("value = %s.readString(elm, \"@uid\");", XHelper.class.getName());
            writer.endBlock();
            writer.beginBlock("if (value != null)", new Object[0]);
            writer.code("setUid(value);", new Object[0]);
            writer.endBlock();
            writer.code("doExit = %s.get(\"entityDeserialize\").enter((%s) this);", InvocationContext.class.getName(), Identity.class.getName());
            writer.endBlock();
            writer.beginBlock("try", new Object[0]);
        }
        writer.code("super.fromXML(elm);", new Object[0]);
        ModelCodeGenHelper.generatePropertyRenamerCode(writer, ett.getPropertiesRenamers(), "elm");
        for (Property prop : ett.getProperties().values()) {
            PropertyGenerator.generateFromXML(writer, prop, ett, ctx);
        }
        for (EntityCollection coll : ett.getCollections().values()) {
            CollectionGenerator.generateFromXML(writer, coll, ett, ctx);
        }
        if (!isXReference) {
            writer.restartBlock("finally", new Object[0]);
            writer.beginBlock("if (doExit)", Identity.class.getName());
            writer.code("%s.get(\"entityDeserialize\").exit();", InvocationContext.class.getName());
            writer.endBlock();
            writer.endBlock();
        }
        writer.endBlock();
        writer.code("@Override", new Object[0]);
        writer.beginBlock("public void toXML(final %s elm) throws Exception", Element.class.getName());
        if (!isXReference) {
            writer.code("boolean doExit = false;", new Object[0]);
            writer.beginBlock("if (this instanceof %s)", Identity.class.getName());
            writer.code("doExit = %s.get(\"entitySerialize\").enter((%s) this);", InvocationContext.class.getName(), Identity.class.getName());
            writer.endBlock();
            writer.beginBlock("try", new Object[0]);
        }
        writer.code("super.toXML(elm);", new Object[0]);
        for (Property prop : ett.getProperties().values()) {
            PropertyGenerator.generateToXML(writer, prop, ett, ctx);
        }
        for (EntityCollection coll : ett.getCollections().values()) {
            CollectionGenerator.generateToXML(writer, coll, ett, ctx);
        }
        if (!isXReference) {
            writer.restartBlock("finally", new Object[0]);
            writer.beginBlock("if (doExit)", Identity.class.getName());
            writer.code("%s.get(\"entitySerialize\").exit();", InvocationContext.class.getName());
            writer.endBlock();
            writer.endBlock();
        }
        writer.endBlock();
        writer.comment("END %s implementation", XSerializable.class.getName());
        writer.blank();
        writer.comment("BEGIN %s implementation", BaseEntity.class.getName());
        writer.code("@Override", new Object[0]);
        writer.beginBlock("protected boolean readXMLElement(final %s reader) throws Exception", XMLStreamReader.class.getName());
        writer.code("throw new UnsupportedOperationException();", new Object[0]);
        writer.endBlock();
        writer.code("@Override", new Object[0]);
        writer.beginBlock("protected void writeXMLElements(final %s writer) throws Exception", XMLStreamWriter.class.getName());
        if (!isXReference) {
            writer.code("boolean doExit = false;", new Object[0]);
            writer.beginBlock("if (this instanceof %s)", Identity.class.getName());
            writer.code("doExit = %s.get(\"entitySerialize\").enter((%s) this);", InvocationContext.class.getName(), Identity.class.getName());
            writer.endBlock();
            writer.beginBlock("try", new Object[0]);
        }
        writer.code("super.writeXMLElements(writer);", new Object[0]);
        for (Property prop : ett.getProperties().values()) {
            PropertyGenerator.generateWriteXMLElements(writer, prop, ett, ctx);
        }
        for (EntityCollection coll : ett.getCollections().values()) {
            CollectionGenerator.generateWriteXMLElements(writer, coll, ett, ctx);
        }
        if (!isXReference) {
            writer.restartBlock("finally", new Object[0]);
            writer.beginBlock("if (doExit)", Identity.class.getName());
            writer.code("%s.get(\"entitySerialize\").exit();", InvocationContext.class.getName());
            writer.endBlock();
            writer.endBlock();
        }
        writer.endBlock();
        writer.code("@Override", new Object[0]);
        writer.beginBlock("public void copyFrom(final %s sourceEntity, final boolean newUids, final %s<String, String> uids) throws Exception", BaseEntity.class.getName(), Map.class.getName());
        writer.code("super.copyFrom(sourceEntity, newUids, uids);", new Object[0]);
        writer.beginBlock("if (sourceEntity instanceof %s)", ett.getId());
        writer.code("%s source = (%1$s) sourceEntity;", ett.getId());
        for (Property prop : ett.getProperties().values()) {
            PropertyGenerator.generateCopyFrom(writer, prop, ett, ctx);
        }
        for (EntityCollection coll : ett.getCollections().values()) {
            CollectionGenerator.generateCopyFrom(writer, coll, ett, ctx);
        }
        writer.endBlock();
        writer.endBlock();
        writer.comment("END %s implementation", BaseEntity.class.getName());
        if (ModelCodeGenHelper.isValidatable(ett, ctx)) {
            ValidationContextGenerator.generateValidationContextClass(writer, ctx, ett);
        }
        writer.endBlock();
        writer.endCompilationUnit();
    }

    private void generateInstrumentedIndex(JavaWriter writer, GenerationContext ctx, IndexType ixt) throws Exception {
        int index = ixt.getId().lastIndexOf(".");
        String instrumentedIndexClassName = String.format("%s.Instrumented%s", ixt.getId().substring(0, index), ixt.getId().substring(index + 1));
        this.log.debug("generating instrumented index " + instrumentedIndexClassName);
        writer.beginCompilationUnit(ctx.getOutFolder(), instrumentedIndexClassName);
        if (ixt.isDeprecated()) {
            writer.code("@Deprecated", new Object[0]);
        }
        writer.beginBlock("public class %s extends %s", GenUtil.getSimpleClassName(instrumentedIndexClassName), ixt.getId());
        writer.code("private static final long serialVersionUID = %sL;", GenUtil.generateSerialVersionUID(instrumentedIndexClassName, ixt.getProperties()));
        writer.blank();
        writer.beginBlock("public %s(final String uidValue)", GenUtil.getSimpleClassName(instrumentedIndexClassName));
        writer.code("super(uidValue);", new Object[0]);
        writer.endBlock();
        writer.comment("BEGIN properties", new Object[0]);
        for (IndexProperty prop : ixt.getProperties().values()) {
            PropertyGenerator.generateInstumentedIndexAccessors(writer, prop, ixt, ctx);
        }
        writer.comment("END properties", new Object[0]);
        writer.comment("BEGIN collections", new Object[0]);
        for (IndexCollection coll : ixt.getCollections().values()) {
            CollectionGenerator.generateInstrumentedAccessors(writer, coll, ixt, ctx);
        }
        writer.comment("END collections", new Object[0]);
        writer.beginBlock("public Object getValue(final String memberId)", ixt.getId());
        writer.code("%s.get().statRetrieving(\"%s\",memberId );", IndexUsageHandler.class.getName(), ixt.getId());
        writer.code("return super.getValue(memberId);", new Object[0]);
        writer.endBlock();
        writer.endCompilationUnit();
    }

    private void generateIndex(JavaWriter writer, GenerationContext ctx, IndexType ixt) throws Exception {
        this.log.debug("generating index " + ixt.getId());
        writer.beginCompilationUnit(ctx.getOutFolder(), ixt.getId());
        ModelCodeGenHelper.generateTypeDoc(writer, ctx, ixt, "Index");
        if (ixt.isDeprecated()) {
            writer.code("@Deprecated", new Object[0]);
        }
        StringBuilder impl = new StringBuilder();
        for (String itf : ixt.getInterfaces()) {
            impl.append(", ").append(itf);
        }
        writer.beginBlock("public class %s implements %s<%s>%s", GenUtil.getSimpleClassName(ixt.getId()), EntityIndex.class.getName(), ixt.getEntityId(), impl.toString());
        writer.code("private static final long serialVersionUID = %sL;", GenUtil.generateSerialVersionUID(ixt.getId(), ixt.getProperties()));
        writer.blank();
        writer.beginBlock("public static enum Property", new Object[0]);
        writer.comment("properties", new Object[0]);
        for (IndexProperty prop : ixt.getProperties().values()) {
            writer.code("%s,", prop.getId());
        }
        writer.comment("collections", new Object[0]);
        for (IndexCollection coll : ixt.getCollections().values()) {
            writer.code("%s,", coll.getId());
        }
        writer.endBlock();
        writer.beginBlock("public %s(final String uidValue)", GenUtil.getSimpleClassName(ixt.getId()));
        writer.code("uid = uidValue;", new Object[0]);
        writer.endBlock();
        writer.comment("BEGIN properties", new Object[0]);
        for (IndexProperty prop : ixt.getProperties().values()) {
            PropertyGenerator.generateIndexAccessors(writer, prop, ixt, ctx);
        }
        writer.comment("END properties", new Object[0]);
        writer.code("private %s modified;", Date.class.getName());
        writer.beginBlock("public %s getModified()", Date.class.getName());
        writer.code("return modified;", new Object[0]);
        writer.endBlock();
        writer.beginBlock("public void setModified(%s value)", Date.class.getName());
        writer.code("modified = value;", new Object[0]);
        writer.endBlock();
        writer.comment("BEGIN collections", new Object[0]);
        for (IndexCollection coll : ixt.getCollections().values()) {
            CollectionGenerator.generateAccessors(writer, coll, (BaseType)ixt, ctx);
        }
        writer.comment("END collections", new Object[0]);
        writer.comment("BEGIN code fragments", new Object[0]);
        for (String codeFragment : ixt.getCodeFragments("model")) {
            writer.code(codeFragment, new Object[0]);
            writer.blank();
        }
        writer.comment("END code fragments", new Object[0]);
        writer.code("private %s<%s> source;", EntityReference.class.getName(), ixt.getEntityId());
        writer.blank();
        writer.beginBlock("public %s<%s> getSource()", EntityReference.class.getName(), ixt.getEntityId());
        writer.code("return source;", new Object[0]);
        writer.endBlock();
        writer.beginBlock("public void setSource(final %s<%s> value)", EntityReference.class.getName(), ixt.getEntityId());
        writer.code("source = value;", new Object[0]);
        writer.endBlock();
        writer.code("private String navigationKey;", new Object[0]);
        writer.blank();
        writer.beginBlock("public String getNavigationKey()", new Object[0]);
        writer.code("return navigationKey;", new Object[0]);
        writer.endBlock();
        writer.beginBlock("public void setNavigationKey(final String value)", new Object[0]);
        writer.code("navigationKey = value;", new Object[0]);
        writer.endBlock();
        writer.code("private String uid;", new Object[0]);
        writer.blank();
        writer.beginBlock("public String getUid()", new Object[0]);
        writer.code("return uid;", new Object[0]);
        writer.endBlock();
        writer.beginBlock("public void setUid(final String value)", new Object[0]);
        writer.code("uid = value;", new Object[0]);
        writer.endBlock();
        writer.beginBlock("public Object getValue(final String memberId)", ixt.getId());
        this.addIntegratedPropGetValue(writer, "uid");
        this.addIntegratedPropGetValue(writer, "source");
        this.addIntegratedPropGetValue(writer, "navigationKey");
        writer.comment("BEGIN properties", new Object[0]);
        for (IndexProperty prop : ixt.getProperties().values()) {
            writer.beginBlock("if (\"%s\".equals(memberId))", prop.getId());
            if (!this.handlePrimitiveWrappingInIntrospectable(writer, prop)) {
                writer.code("return %s;", prop.getId());
            }
            writer.endBlock();
        }
        writer.comment("END properties", new Object[0]);
        writer.comment("BEGIN collections", new Object[0]);
        for (IndexCollection coll : ixt.getCollections().values()) {
            writer.beginBlock("if (\"%s\".equals(memberId))", coll.getId());
            writer.code("return %s;", coll.getId());
            writer.endBlock();
        }
        writer.comment("END collections", new Object[0]);
        writer.code("throw new IllegalArgumentException(\"unknown member ID \" + memberId);", new Object[0]);
        writer.endBlock();
        writer.beginBlock("public void setValue(final String memberId, Object value)", ixt.getId());
        this.addIntegratedPropSetValue(writer, "uid", "String");
        this.addIntegratedPropSetValue(writer, "source", String.format("%s<%s>", EntityReference.class.getName(), ixt.getEntityId()));
        this.addIntegratedPropSetValue(writer, "navigationKey", "String");
        writer.comment("BEGIN properties", new Object[0]);
        for (IndexProperty prop : ixt.getProperties().values()) {
            writer.beginBlock("if (\"%s\".equals(memberId))", prop.getId());
            writer.code("%s = (%s) value;", prop.getId(), MetaReflectionHelper.getTypeForIntrospection(prop, ctx.getMetaRegistry()));
            writer.code("return;", new Object[0]);
            writer.endBlock();
        }
        writer.comment("END properties", new Object[0]);
        writer.code("throw new IllegalArgumentException(\"unknown member ID \" + memberId);", new Object[0]);
        writer.endBlock();
        writer.endBlock();
        writer.endCompilationUnit();
    }

    private void addIntegratedPropGetValue(JavaWriter writer, String propId) throws IOException {
        writer.beginBlock("if (\"%s\".equals(memberId))", propId);
        writer.code("return %s;", propId);
        writer.endBlock();
    }

    private void addIntegratedPropSetValue(JavaWriter writer, String propId, String typeId) throws IOException {
        writer.beginBlock("if (\"%s\".equals(memberId))", propId);
        writer.code("%s = (%s) value;", propId, typeId);
        writer.code("return;", new Object[0]);
        writer.endBlock();
    }

    private boolean baseHandlePrimitiveWrappingInIntrospectable(JavaWriter writer, BaseProperty prop) throws Exception {
        if (PRIMITIVES_TO_WRAPPERS.containsKey(prop.getType())) {
            writer.code("return %s.valueOf(this.%s);", PRIMITIVES_TO_WRAPPERS.get(prop.getType()), prop.getId());
            return true;
        }
        return false;
    }

    private boolean handlePrimitiveWrappingInIntrospectable(JavaWriter writer, BaseReferenceProperty prop) throws Exception {
        if (prop.isHistorical()) {
            return false;
        }
        return this.baseHandlePrimitiveWrappingInIntrospectable(writer, prop);
    }

    private boolean handlePrimitiveWrappingInIntrospectable(JavaWriter writer, IndexProperty prop) throws Exception {
        return this.baseHandlePrimitiveWrappingInIntrospectable(writer, prop);
    }

    static {
        PRIMITIVES_TO_WRAPPERS.put("boolean", "Boolean");
        PRIMITIVES_TO_WRAPPERS.put("byte", "Byte");
        PRIMITIVES_TO_WRAPPERS.put("char", "Character");
        PRIMITIVES_TO_WRAPPERS.put("double", "Double");
        PRIMITIVES_TO_WRAPPERS.put("float", "Float");
        PRIMITIVES_TO_WRAPPERS.put("int", "Integer");
        PRIMITIVES_TO_WRAPPERS.put("long", "Long");
        PRIMITIVES_TO_WRAPPERS.put("short", "Short");
    }
}

