/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.gen.model;

import com.gridnine.xtrip.common.gen.GenUtil;
import com.gridnine.xtrip.common.gen.GenerationContext;
import com.gridnine.xtrip.common.gen.JavaWriter;
import com.gridnine.xtrip.common.meta.BaseMetaElement;
import com.gridnine.xtrip.common.meta.BaseProperty;
import com.gridnine.xtrip.common.meta.BaseReferenceProperty;
import com.gridnine.xtrip.common.meta.BaseType;
import com.gridnine.xtrip.common.meta.EntityCollection;
import com.gridnine.xtrip.common.meta.EntityRef;
import com.gridnine.xtrip.common.meta.EntityType;
import com.gridnine.xtrip.common.meta.MetaRegistry;
import com.gridnine.xtrip.common.meta.MetaRegistryHelper;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.xml.XHelper;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public final class ModelCodeGenHelper {
    public static void generateEnumItemRenamerCode(JavaWriter writer, Set<String> renamers, String propertyId, String elementName) throws IOException {
        if (renamers.isEmpty()) {
            return;
        }
        writer.beginBlock();
        writer.code("String oldValue = %s.readString(%s, \"%s\");", XHelper.class.getName(), elementName, propertyId);
        for (String className : renamers) {
            writer.beginBlock("if(!%s.isBlank(oldValue))", TextUtil.class.getName());
            writer.beginBlock("if(%s.get().findEnumItemRenamer(\"%s\") != null)", MetaRegistry.class.getName(), className);
            writer.code("String newValue = %s.get().findEnumItemRenamer(\"%s\").getNewName(oldValue);", MetaRegistry.class.getName(), className);
            writer.beginBlock("if(!oldValue.equals(newValue))", TextUtil.class.getName());
            writer.code("%s.writeString(%s, \"%s\", newValue);", XHelper.class.getName(), elementName, propertyId);
            writer.code("oldValue = newValue;", new Object[0]);
            writer.endBlock();
            writer.endBlock();
            writer.endBlock();
        }
        writer.endBlock();
    }

    public static void generatePropertyRenamerCode(JavaWriter writer, Set<String> renamers, String elementName) throws IOException {
        if (renamers.isEmpty()) {
            return;
        }
        for (String className : renamers) {
            writer.beginBlock("if(%s.get().findPropertiesRenamer(\"%s\") != null)", MetaRegistry.class.getName(), className);
            writer.code("%s.get().findPropertiesRenamer(\"%s\").renameProperties(%s);", MetaRegistry.class.getName(), className, elementName);
            writer.endBlock();
        }
    }

    public static void generateRenameReferenceCode(JavaWriter writer, Set<String> renamers, String elementName) throws IOException {
        ModelCodeGenHelper.generateEntityModificationCode(writer, renamers, elementName, "renameReference");
    }

    public static void generateRenameEntityCode(JavaWriter writer, Set<String> renamers, String elementName) throws IOException {
        ModelCodeGenHelper.generateEntityModificationCode(writer, renamers, elementName, "renameEntity");
    }

    private static void generateEntityModificationCode(JavaWriter writer, Set<String> renamers, String elementName, String method) throws IOException {
        if (renamers.isEmpty()) {
            return;
        }
        for (String className : renamers) {
            writer.beginBlock("if(%s.get().findEntityRenamer(\"%s\") != null)", MetaRegistry.class.getName(), className);
            writer.code("%s.get().findEntityRenamer(\"%s\").%s(%s);", MetaRegistry.class.getName(), className, method, elementName);
            writer.endBlock();
        }
    }

    public static Set<String> getEntityRenamersClassNames(MetaRegistry metaRegistry, String typeId) {
        EntityRef entityRefType = metaRegistry.getEntityRefs().get(typeId);
        if (entityRefType != null) {
            return entityRefType.getEntityRenamers();
        }
        EntityType entityType = metaRegistry.getEntities().get(typeId);
        if (entityType == null) {
            return Collections.emptySet();
        }
        HashSet<String> result = new HashSet<String>(entityType.getEntityRenamers());
        if (!entityType.isAbstract()) {
            return result;
        }
        for (EntityType ett : metaRegistry.getEntities().values()) {
            if (!typeId.equals(ett.getExtendsId())) continue;
            result.addAll(ModelCodeGenHelper.getEntityRenamersClassNames(metaRegistry, ett.getId()));
        }
        return result;
    }

    public static String getJavaType(String metaType, GenerationContext ctx) {
        if (ctx.getMetaRegistry().getDictionaries().containsKey(metaType)) {
            return String.format("%s<%s>", DictionaryReference.class.getName(), metaType);
        }
        EntityType ett = ctx.getMetaRegistry().getEntities().get(metaType);
        if (ett != null) {
            if (MetaRegistryHelper.isRoot(ett)) {
                return EntityReference.class.getName() + "<" + metaType + ">";
            }
            return metaType;
        }
        if ("text".equals(metaType)) {
            return "String";
        }
        if ("compressed".equals(metaType)) {
            return "byte[]";
        }
        return metaType;
    }

    public static <P extends BaseProperty> String getType(P prop, GenerationContext ctx) {
        String type;
        if (ctx.getMetaRegistry().getDictionaries().containsKey(prop.getType())) {
            type = String.format("%s<%s>", DictionaryReference.class.getName(), prop.getType());
        } else if (prop instanceof BaseReferenceProperty && ((BaseReferenceProperty)prop).isReference()) {
            String subtype = prop.getType();
            EntityType ett = ctx.getMetaRegistry().getEntities().get(prop.getType());
            if (ett == null || ett.isAbstract()) {
                subtype = "? extends " + subtype;
            }
            type = EntityReference.class.getName() + "<" + subtype + ">";
        } else {
            type = "text".equals(prop.getType()) ? "String" : ("compressed".equals(prop.getType()) ? "byte[]" : (!TextUtil.isBlank(prop.getGenerics()) ? String.format("%s<%s>", prop.getType(), prop.getGenerics()) : prop.getType()));
        }
        return type;
    }

    public static String getType(EntityCollection coll, GenerationContext ctx, boolean key) {
        String elementType;
        boolean reference;
        String type = key ? coll.getKeyType() : coll.getElementType();
        boolean bl = reference = key ? coll.isKeyReference() : coll.isReference();
        if (ctx.getMetaRegistry().getDictionaries().containsKey(type)) {
            elementType = String.format("%s<%s>", DictionaryReference.class.getName(), type);
        } else if (reference) {
            String subtype = type;
            EntityType ett = ctx.getMetaRegistry().getEntities().get(type);
            if (ett == null || ett.isAbstract()) {
                subtype = "? extends " + subtype;
            }
            elementType = EntityReference.class.getName() + "<" + subtype + ">";
        } else {
            elementType = "text".equals(type) ? "String" : type;
        }
        return elementType;
    }

    public static void maybeDeprecated(BaseMetaElement meta, JavaWriter writer) throws IOException {
        if (meta.isDeprecated()) {
            writer.code("@Deprecated", new Object[0]);
        }
    }

    public static String genValidationContextClassName(String mainClassId) {
        return GenUtil.getSimpleClassName(mainClassId) + "ValidationContext";
    }

    public static boolean isValidatable(EntityType type, GenerationContext ctx) {
        if (type.isValidatable()) {
            return true;
        }
        if (type.getExtendsId() == null) {
            return false;
        }
        EntityType parent = ModelCodeGenHelper.getEntityType(ctx, type.getExtendsId());
        if (parent == null) {
            return false;
        }
        return ModelCodeGenHelper.isValidatable(parent, ctx);
    }

    public static EntityType getEntityType(GenerationContext ctx, String id) {
        return ctx.getMetaRegistry().getEntities().get(id);
    }

    public static boolean isNestedEntityReferenceType(String type) {
        return type != null && type.contains("||");
    }

    public static MiscUtil.Pair<String, String> getNestedEntityReferenceTypes(String type) {
        int index = type.indexOf("||");
        String mainType = type.substring(0, index);
        String nestedType = type.substring(index + 2);
        return new MiscUtil.Pair<String, String>(mainType, nestedType);
    }

    static boolean isRoot(GenerationContext ctx, EntityType type) {
        if (type.isRoot()) {
            return true;
        }
        if (type.getExtendsId() == null) {
            return false;
        }
        EntityType parent = ctx.getMetaRegistry().getEntities().get(type.getExtendsId());
        if (parent == null) {
            return false;
        }
        return ModelCodeGenHelper.isRoot(ctx, parent);
    }

    static void generateTypeDoc(JavaWriter writer, GenerationContext ctx, BaseType type, String typeName) throws IOException {
        StringBuilder buf = new StringBuilder();
        buf.append(typeName).append(" generated from metadata.\n");
        buf.append("<dl>\n");
        buf.append("<dt>ID</dt><dd>").append(type.getId()).append("</dd>\n");
        buf.append("<dt>sources</dt><dd>").append((Object)type.getSources().stream().map(url -> {
            String result = url.toExternalForm();
            int p = result.indexOf("plugins/");
            return p == -1 ? result : result.substring(p);
        }).collect(Collectors.joining("<br>\n"))).append("</dd>\n");
        buf.append("</dl>");
        if (!type.getParameters().isEmpty()) {
            buf.append("\nParameters:\n");
            buf.append("<table border=1 cellspacing=0 cellpadding=5>\n");
            buf.append("<tr><th>Name</th><th>Value</th></tr>\n");
            for (Map.Entry<String, String> entry : type.getParameters().entrySet()) {
                buf.append("<tr><td>").append(entry.getKey()).append("</td><td>").append(entry.getValue()).append("</td></tr>\n");
            }
            buf.append("</table>");
        }
        writer.doc(buf.toString(), new Object[0]);
    }

    private ModelCodeGenHelper() {
    }
}

