/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.incidents;

import java.util.Map;
import java.util.Objects;

public class IncidentsHelper {
    private IncidentsHelper() {
        throw new RuntimeException("don't do this");
    }

    public static StackTraceElement getContextStackTraceElement(String name, String value) {
        return new StackTraceElement("<<Context>>", name, value, -1);
    }

    public static <E extends Throwable> E addStackTraceElement(E throwable, StackTraceElement ... elements) {
        StackTraceElement[] newStackTrace;
        if (Objects.isNull(throwable)) {
            return throwable;
        }
        StackTraceElement[] oldStackTrace = throwable.getStackTrace();
        if (oldStackTrace != (newStackTrace = IncidentsHelper.addStackTraceElement(oldStackTrace, elements))) {
            throwable.setStackTrace(newStackTrace);
        }
        return throwable;
    }

    public static StackTraceElement[] addStackTraceElement(StackTraceElement[] oldStackTrace, StackTraceElement ... elements) {
        if (Objects.isNull(oldStackTrace) || Objects.isNull(elements)) {
            return oldStackTrace;
        }
        int elementsLength = elements.length;
        if (elementsLength == 0) {
            return oldStackTrace;
        }
        StackTraceElement[] newStackTrace = new StackTraceElement[oldStackTrace.length + elementsLength];
        for (int i = 0; i < elementsLength; ++i) {
            newStackTrace[i] = elements[i];
        }
        System.arraycopy(oldStackTrace, 0, newStackTrace, elementsLength, oldStackTrace.length);
        return newStackTrace;
    }

    public static <T extends Exception> T findCause(Throwable throwable, Class<T> causeClass) {
        if (causeClass.isInstance(throwable)) {
            return (T)((Exception)throwable);
        }
        if (throwable.getCause() != null) {
            return IncidentsHelper.findCause(throwable.getCause(), causeClass);
        }
        return null;
    }

    public static void enrichStacktrace(Exception e, Map<String, String> context) {
        if (Objects.isNull(e) || context == null || context.isEmpty()) {
            return;
        }
        StackTraceElement[] stackTraceElements = (StackTraceElement[])context.entrySet().stream().filter(Objects::nonNull).map(entryMap -> IncidentsHelper.getContextStackTraceElement(String.valueOf(entryMap.getKey()), String.valueOf(entryMap.getValue()))).toArray(StackTraceElement[]::new);
        IncidentsHelper.addStackTraceElement(e, stackTraceElements);
    }
}

