/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.json;

import com.gridnine.xtrip.common.meta.BaseMetaElement;
import com.gridnine.xtrip.common.meta.EntityCollection;
import com.gridnine.xtrip.common.meta.EntityType;
import com.gridnine.xtrip.common.meta.IndexCollection;
import com.gridnine.xtrip.common.meta.IndexProperty;
import com.gridnine.xtrip.common.meta.IndexType;
import com.gridnine.xtrip.common.meta.MetaRegistry;
import com.gridnine.xtrip.common.meta.MetaRegistryHelper;
import com.gridnine.xtrip.common.meta.Property;
import com.gridnine.xtrip.common.meta.reflection.MetaReflectionHelper;
import com.gridnine.xtrip.common.meta.rest.RestCollection;
import com.gridnine.xtrip.common.meta.rest.RestEntityType;
import com.gridnine.xtrip.common.meta.rest.RestMap;
import com.gridnine.xtrip.common.meta.rest.RestMetaRegistry;
import com.gridnine.xtrip.common.meta.rest.RestMetaRegistryHelper;
import com.gridnine.xtrip.common.meta.rest.RestProperty;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONException;

public class IntrospectableEntityWrapper {
    public boolean validatable;
    public final List<IntrospectableEntityPropertyWrapper> properties = new ArrayList<IntrospectableEntityPropertyWrapper>();
    public final List<IntrospectableEntityCollectionWrapper> collections = new ArrayList<IntrospectableEntityCollectionWrapper>();
    public final List<IntrospectableEntityMapWrapper> maps = new ArrayList<IntrospectableEntityMapWrapper>();

    public Set<String> getAllFields() {
        HashSet<String> res = new HashSet<String>(this.properties.size() + this.collections.size() + this.maps.size());
        this.properties.stream().map(IntrospectableEntityBaseWrapper::getId).forEach(res::add);
        this.collections.stream().map(IntrospectableEntityBaseWrapper::getId).forEach(res::add);
        this.maps.stream().map(IntrospectableEntityBaseWrapper::getId).forEach(res::add);
        return res;
    }

    private static boolean isWithMessages(RestEntityType type) {
        while (type != null) {
            if (type.isWithMessages()) {
                return true;
            }
            type = TextUtil.isBlank(type.getExtendsId()) ? null : RestMetaRegistry.get().getEntities().get(type.getExtendsId());
        }
        return false;
    }

    IntrospectableEntityWrapper(EntityType type) throws Exception {
        this.validatable = type.isValidatable();
        for (Property item : MetaRegistryHelper.getAllProperties(type).values()) {
            this.properties.add(new IntrospectableEntityPropertyWrapper(item));
        }
        for (EntityCollection collection : MetaRegistryHelper.getAllCollections(type).values()) {
            if (Map.class.getName().equals(collection.getType())) {
                this.maps.add(new IntrospectableEntityMapWrapper(collection));
                continue;
            }
            this.collections.add(new IntrospectableEntityCollectionWrapper(collection));
        }
    }

    IntrospectableEntityWrapper(RestEntityType type) throws Exception {
        this.validatable = type.isValidatable();
        for (RestProperty item : RestMetaRegistryHelper.getAllProperties(type).values()) {
            this.properties.add(new IntrospectableEntityPropertyWrapper(item));
        }
        for (RestCollection collection : RestMetaRegistryHelper.getAllCollections(type).values()) {
            this.collections.add(new IntrospectableEntityCollectionWrapper(collection));
        }
        for (RestMap map : RestMetaRegistryHelper.getAllMaps(type).values()) {
            this.maps.add(new IntrospectableEntityMapWrapper(map));
        }
        if (IntrospectableEntityWrapper.isWithMessages(type)) {
            this.collections.add(new IntrospectableEntityCollectionWrapper(){
                {
                    this.synthetic = true;
                    this.id = "messages";
                    this.originalType = this.elementType = "com.gridnine.xtrip.common.rest.InformationMessage";
                }
            });
        }
    }

    IntrospectableEntityWrapper(IndexType indexType) throws Exception {
        this.validatable = false;
        for (IndexProperty item : indexType.getProperties().values()) {
            this.properties.add(new IntrospectableEntityPropertyWrapper(item));
        }
        for (IndexCollection collection : indexType.getCollections().values()) {
            if (Map.class.getName().equals(collection.getType())) {
                this.maps.add(new IntrospectableEntityMapWrapper(collection));
                continue;
            }
            this.collections.add(new IntrospectableEntityCollectionWrapper(collection));
        }
    }

    public static IntrospectableEntityWrapper create(String clasName) throws JSONException {
        EntityType et = MetaRegistryHelper.getEntityType(clasName);
        if (et != null) {
            try {
                return new IntrospectableEntityWrapper(et);
            }
            catch (Exception e) {
                throw new JSONException((Throwable)e);
            }
        }
        RestEntityType ret = RestMetaRegistryHelper.getEntityType(clasName);
        if (ret != null) {
            try {
                return new IntrospectableEntityWrapper(ret);
            }
            catch (Exception e) {
                throw new JSONException((Throwable)e);
            }
        }
        IndexType indexType = MetaRegistryHelper.getIndexType(clasName);
        if (indexType != null) {
            try {
                return new IntrospectableEntityWrapper(indexType);
            }
            catch (Exception e) {
                throw new JSONException((Throwable)e);
            }
        }
        throw new IllegalArgumentException(String.format("unsupported type %s", clasName));
    }

    public static class IntrospectableEntityMapWrapper
    extends IntrospectableEntityBaseWrapper {
        public boolean nullable;
        boolean elementValidatable;
        public String keyType;
        public String keyOriginalType;
        public boolean isKeyEnum;
        public boolean isKeyDict;
        public String elementType;
        public String elementOriginalType;

        public IntrospectableEntityMapWrapper(BaseMetaElement element) {
            this.id = element.getId();
        }

        IntrospectableEntityMapWrapper(RestMap map) {
            this((BaseMetaElement)map);
            String valueType;
            this.nullable = false;
            this.elementType = valueType = MetaReflectionHelper.getTypeForIntrospection(map.getValueType(), MetaRegistry.get(), RestMetaRegistry.get(), true);
            this.elementOriginalType = MetaReflectionHelper.getOriginalType(map.getValueType(), MetaRegistry.get(), RestMetaRegistry.get());
            RestEntityType valueEntityType = RestMetaRegistryHelper.getEntityType(valueType);
            this.elementValidatable = valueEntityType != null && valueEntityType.isValidatable();
            this.keyType = map.getKeyType();
            this.keyOriginalType = MetaReflectionHelper.getOriginalType(this.keyType, MetaRegistry.get(), RestMetaRegistry.get());
            this.isKeyEnum = MetaRegistry.get().getEnums().containsKey(map.getKeyType()) || RestMetaRegistry.get().getEnums().containsKey(map.getKeyType());
            this.isKeyDict = MetaRegistry.get().getDictionaries().containsKey(map.getKeyType());
        }

        public IntrospectableEntityMapWrapper(EntityCollection collection) {
            this((BaseMetaElement)collection);
            this.nullable = collection.isNullable();
            this.elementType = collection.getElementType();
            EntityType valueType = MetaRegistryHelper.getEntityType(collection.getElementType());
            this.elementValidatable = valueType != null && valueType.isValidatable();
            this.keyType = collection.getKeyType();
            this.isKeyEnum = MetaRegistry.get().getEnums().containsKey(collection.getKeyType());
            this.isKeyDict = MetaRegistry.get().getDictionaries().containsKey(collection.getKeyType());
        }

        public IntrospectableEntityMapWrapper(IndexCollection collection) {
            throw new IllegalArgumentException(String.format("IndexCollection=[%s] not supported Map", collection.getId()));
        }
    }

    public static class IntrospectableEntityCollectionWrapper
    extends IntrospectableEntityBaseWrapper {
        public boolean nullable;
        boolean elementValidatable;
        public String elementType;
        public String originalType;
        public boolean synthetic;

        protected IntrospectableEntityCollectionWrapper() {
        }

        IntrospectableEntityCollectionWrapper(EntityCollection collection) {
            this.id = collection.getId();
            this.nullable = collection.isNullable();
            EntityType elementEt = MetaRegistryHelper.getEntityType(collection.getElementType());
            this.elementValidatable = elementEt != null && elementEt.isValidatable();
            this.elementType = collection.getElementType();
        }

        IntrospectableEntityCollectionWrapper(RestCollection collection) {
            this.id = collection.getId();
            this.nullable = false;
            String type = MetaReflectionHelper.getTypeForIntrospection(collection.getElementType(), MetaRegistry.get(), RestMetaRegistry.get(), true);
            RestEntityType elementEt = RestMetaRegistryHelper.getEntityType(type);
            this.elementValidatable = elementEt != null && elementEt.isValidatable();
            this.elementType = type;
            this.originalType = MetaReflectionHelper.getOriginalType(collection.getElementType(), MetaRegistry.get(), RestMetaRegistry.get());
        }

        IntrospectableEntityCollectionWrapper(IndexCollection collection) {
            this.id = collection.getId();
            this.nullable = false;
            EntityType elementEt = MetaRegistryHelper.getEntityType(collection.getElementType());
            this.elementValidatable = elementEt != null && elementEt.isValidatable();
            this.elementType = collection.getElementType();
        }
    }

    public static class IntrospectableEntityPropertyWrapper
    extends IntrospectableEntityBaseWrapper {
        public String typeForIntrospection;
        public String originalType;

        IntrospectableEntityPropertyWrapper(Property item) throws Exception {
            this.id = item.getId();
            this.typeForIntrospection = MetaReflectionHelper.getTypeForIntrospection(item);
        }

        IntrospectableEntityPropertyWrapper(RestProperty item) throws Exception {
            this.id = item.getId();
            this.typeForIntrospection = MetaReflectionHelper.getTypeForIntrospection(item.getType(), MetaRegistry.get(), RestMetaRegistry.get(), true);
            this.originalType = MetaReflectionHelper.getOriginalType(item.getType(), MetaRegistry.get(), RestMetaRegistry.get());
        }

        public IntrospectableEntityPropertyWrapper(IndexProperty item) throws Exception {
            this.id = item.getId();
            this.typeForIntrospection = MetaReflectionHelper.getTypeForIntrospection(item);
        }
    }

    public static class IntrospectableEntityBaseWrapper {
        public String id;

        public String getId() {
            return this.id;
        }
    }
}

