/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.json;

import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.util.CollectionUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class JSONHelper {
    public static void writeBoolean(JSONObject json, String name, boolean value) throws JSONException {
        json.put(name, value ? 1 : 0);
    }

    public static boolean readBoolean(JSONObject json, String name) {
        return json.optInt(name) != 0;
    }

    public static void writeDate(JSONObject json, String name, Date value) throws JSONException {
        if (value == null) {
            return;
        }
        json.put(name, value.getTime() / 1000L / 60L);
    }

    public static Date readDate(JSONObject json, String name) {
        int result = json.optInt(name, -1);
        return result == -1 ? null : new Date((long)result * 60L * 1000L);
    }

    public static void writeBigDecimal(JSONObject json, String name, BigDecimal value) throws JSONException {
        if (value == null) {
            return;
        }
        json.put(name, (Object)value.toString());
    }

    public static BigDecimal readBigDecimal(JSONObject json, String name) {
        String str = json.optString(name, null);
        if (str == null) {
            return null;
        }
        return new BigDecimal(str);
    }

    public static void writeEnum(JSONObject json, String name, Enum<?> value) throws JSONException {
        if (value == null) {
            return;
        }
        json.put(name, (Object)value.name());
    }

    public static <T extends Enum<T>> T readEnum(JSONObject json, String name, Class<T> cls) {
        String item = json.optString(name, null);
        if (item == null) {
            return null;
        }
        return CollectionUtil.findEnumConstant(cls, item);
    }

    public static void writeDict(JSONObject json, String name, DictionaryReference<?> value) throws JSONException {
        if (value == null) {
            return;
        }
        json.put(name, (Object)value.getCode());
    }

    public static <T extends DictionaryReference<?>> T readDict(JSONObject json, String name, Class<T> cls) throws Exception {
        String code = json.optString(name, null);
        if (code == null) {
            return null;
        }
        DictionaryReference result = (DictionaryReference)cls.newInstance();
        result.setCode(code);
        return (T)result;
    }

    public static Collection<JSONObject> objects(JSONArray arr) throws JSONException {
        if (arr == null) {
            return null;
        }
        ArrayList<JSONObject> result = new ArrayList<JSONObject>(arr.length());
        for (int i = 0; i < arr.length(); ++i) {
            result.add(arr.getJSONObject(i));
        }
        return result;
    }

    public static void addNonNull(JSONArray arr, JSONObject obj) {
        if (obj != null) {
            arr.put((Object)obj);
        }
    }

    public static void writeEntityRef(JSONObject json, String name, EntityReference<?> value) throws JSONException {
        if (value == null) {
            return;
        }
        json.put(name, (Object)value.getUid());
    }

    public static <T extends BaseEntity> EntityReference<T> readEntityRef(JSONObject json, String name, Class<T> cls) throws JSONException {
        String uid = json.optString(name, null);
        if (uid == null) {
            return null;
        }
        EntityReference<T> ref = new EntityReference<T>(uid, cls, null);
        return ref;
    }

    private JSONHelper() {
    }
}

