/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.json;

import com.gridnine.xtrip.common.json.IntrospectableEntityWrapper;
import com.gridnine.xtrip.common.meta.EntityType;
import com.gridnine.xtrip.common.meta.MetaRegistryHelper;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Introspectable;
import com.gridnine.xtrip.common.model.Validatable;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.validation.ValidationHelper;
import com.gridnine.xtrip.common.model.validation.ValidationMessage;
import com.gridnine.xtrip.common.util.Base64;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.xml.XSHelper;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.joda.time.DateTime;
import org.joda.time.LocalTime;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;
import org.joda.time.format.ISODateTimeFormat;
import org.json.JSONArray;
import org.json.JSONObject;

public class JSONMarshaller {
    private static Map<String, Class> primitives = new HashMap<String, Class>();

    public static Object marshal(Object value) {
        boolean isValid;
        block2: {
            block1: {
                isValid = true;
                if (!(value instanceof Validatable)) break block1;
                isValid = ValidationHelper.isValid((Validatable)value);
                break block2;
            }
            if (!(value instanceof Collection)) break block2;
            for (Object item : (Collection)value) {
                if (item instanceof Validatable && !(isValid = ValidationHelper.isValid((Validatable)item))) break;
            }
        }
        return JSONMarshaller.marshal(value, isValid);
    }

    private static Object marshal(Object value, boolean isRootValid) {
        if (value instanceof Boolean || value instanceof Double || value instanceof Float || value instanceof Integer || value instanceof Long || value instanceof String) {
            return isRootValid ? value : null;
        }
        if (value instanceof org.joda.time.LocalDate) {
            return isRootValid ? ISODateTimeFormat.date().print((ReadablePartial)((org.joda.time.LocalDate)value)) : null;
        }
        if (value instanceof LocalTime) {
            return isRootValid ? ISODateTimeFormat.timeNoMillis().print((ReadablePartial)((LocalTime)value)) : null;
        }
        if (value instanceof org.joda.time.LocalDateTime) {
            return isRootValid ? ISODateTimeFormat.dateTimeNoMillis().print((ReadablePartial)((org.joda.time.LocalDateTime)value)) : null;
        }
        if (value instanceof DateTime) {
            return isRootValid ? ISODateTimeFormat.dateTime().print((ReadableInstant)((DateTime)value)) : null;
        }
        if (value instanceof LocalDate) {
            return isRootValid ? DateTimeFormatter.ISO_DATE.format((LocalDate)value) : null;
        }
        if (value instanceof java.time.LocalTime) {
            return isRootValid ? DateTimeFormatter.ISO_TIME.format((java.time.LocalTime)value) : null;
        }
        if (value instanceof LocalDateTime) {
            return isRootValid ? DateTimeFormatter.ISO_DATE_TIME.format((LocalDateTime)value) : null;
        }
        if (value instanceof Date) {
            return isRootValid ? DateTimeFormatter.ISO_DATE_TIME.format(MiscUtil.toLocalDateTime((Date)value)) : null;
        }
        if (value instanceof BigDecimal) {
            return isRootValid ? value.toString() : null;
        }
        if (value instanceof EntityReference) {
            if (!isRootValid) {
                return null;
            }
            EntityReference ref = (EntityReference)value;
            JSONObject result = new JSONObject();
            result.put("uid", (Object)ref.getUid());
            result.put("type", (Object)ref.getType().getName());
            if (ref.getCaption() != null) {
                result.put("caption", (Object)ref.getCaption());
            }
            return result;
        }
        if (value instanceof DictionaryReference) {
            if (!isRootValid) {
                return null;
            }
            DictionaryReference ref = (DictionaryReference)value;
            JSONObject result = new JSONObject();
            result.put("code", (Object)ref.getCode());
            result.put("type", (Object)ref.getType().getName());
            if (ref.getCaption() != null) {
                result.put("caption", (Object)ref.getCaption());
            }
            return result;
        }
        if (value instanceof Collection) {
            JSONArray result = new JSONArray();
            for (Object item : (Collection)value) {
                Object marshalledItem = JSONMarshaller.marshal(item, isRootValid);
                if (marshalledItem == null) continue;
                result.put(marshalledItem);
            }
            return result;
        }
        if (value instanceof Map) {
            JSONObject result = new JSONObject();
            for (Map.Entry item : ((Map)value).entrySet()) {
                Object val = JSONMarshaller.marshal(item.getValue(), isRootValid);
                if (val == null) continue;
                Object key = item.getKey();
                if (key instanceof Integer) {
                    result.put(((Integer)key).toString(), val);
                    continue;
                }
                result.put((String)key, val);
            }
            return result;
        }
        if (value instanceof Introspectable) {
            Object marshalledPropertyValue;
            Object propertyValue;
            Map<Integer, Collection<ValidationMessage>> validationMessages;
            String name;
            JSONObject result = new JSONObject();
            boolean empty = true;
            IntrospectableEntityWrapper ew = IntrospectableEntityWrapper.create(value.getClass().getName());
            if (JSONMarshaller.isIncludeUidInJSON(value.getClass().getName())) {
                Object marshalledPropertyValue2;
                BaseEntity ref = (BaseEntity)value;
                String name2 = "uid";
                String propertyValue2 = ref.getUid();
                if (propertyValue2 != null && (marshalledPropertyValue2 = JSONMarshaller.marshal(propertyValue2, isRootValid)) != null) {
                    result.put(name2, marshalledPropertyValue2);
                    empty = false;
                }
            }
            for (IntrospectableEntityWrapper.IntrospectableEntityPropertyWrapper property : ew.properties) {
                name = property.id;
                boolean valueSet = false;
                if (ew.validatable && value instanceof Validatable && !(validationMessages = ((Validatable)value).getValidationContext().getValidationMessages(name)).isEmpty()) {
                    result.put(name, JSONMarshaller.marshal(validationMessages, true));
                    empty = false;
                    valueSet = true;
                }
                if (valueSet || (propertyValue = ((Introspectable)value).getValue(name)) == null || (marshalledPropertyValue = JSONMarshaller.marshal(propertyValue, isRootValid)) == null) continue;
                result.put(name, marshalledPropertyValue);
                empty = false;
            }
            for (IntrospectableEntityWrapper.IntrospectableEntityCollectionWrapper collection : ew.collections) {
                name = collection.id;
                boolean generateEmptyArray = false;
                if (collection.nullable && Boolean.FALSE.equals(propertyValue = (Boolean)((Introspectable)value).getValue(MetaRegistryHelper.getNullableCollectionPropName(collection.id))) && isRootValid) {
                    generateEmptyArray = true;
                }
                if (ew.validatable && value instanceof Validatable) {
                    Object marshalledPropertyValue3;
                    Collection propertyValue3;
                    Validatable validatableValue;
                    Collection<ValidationMessage> validationMessages2;
                    validationMessages = ((Validatable)value).getValidationContext().getValidationMessagesForSimpleCollection(name);
                    if (!validationMessages.isEmpty()) {
                        result.put(name, JSONMarshaller.marshal(validationMessages, true));
                        empty = false;
                    }
                    if (!(validationMessages2 = (validatableValue = (Validatable)value).getValidationContext().getValidationMessages(name)).isEmpty()) {
                        result.put(name, JSONMarshaller.marshal(validationMessages2, true));
                        empty = false;
                        continue;
                    }
                    if (!ValidationHelper.isValid(validatableValue)) {
                        propertyValue3 = (Collection)((Introspectable)value).getValue(name);
                        if (propertyValue3 == null || propertyValue3.isEmpty()) continue;
                        JSONObject json = new JSONObject();
                        boolean jsonEmpty = true;
                        int i = 0;
                        for (Object item : propertyValue3) {
                            Object marshalledItem = JSONMarshaller.marshal(item, isRootValid);
                            if (marshalledItem != null) {
                                json.put(Integer.toString(i), marshalledItem);
                                jsonEmpty = false;
                            }
                            ++i;
                        }
                        if (jsonEmpty) continue;
                        result.put(name, (Object)json);
                        empty = false;
                        continue;
                    }
                    propertyValue3 = (Collection)((Introspectable)value).getValue(name);
                    if ((propertyValue3 == null || propertyValue3.isEmpty()) && !generateEmptyArray || (marshalledPropertyValue3 = JSONMarshaller.marshal(propertyValue3, isRootValid)) == null) continue;
                    boolean emptyArray = false;
                    if (marshalledPropertyValue3 instanceof JSONArray) {
                        boolean bl = emptyArray = ((JSONArray)marshalledPropertyValue3).length() == 0;
                    }
                    if (emptyArray && !generateEmptyArray) continue;
                    result.put(name, marshalledPropertyValue3);
                    empty = false;
                    continue;
                }
                propertyValue = (Collection)((Introspectable)value).getValue(name);
                if ((propertyValue == null || propertyValue.isEmpty()) && !generateEmptyArray || (marshalledPropertyValue = JSONMarshaller.marshal(propertyValue, isRootValid)) == null) continue;
                result.put(name, marshalledPropertyValue);
                empty = false;
            }
            return empty ? null : result;
        }
        if (value instanceof Enum) {
            return isRootValid ? ((Enum)value).name() : null;
        }
        if (value instanceof ValidationMessage) {
            ValidationMessage vm = (ValidationMessage)value;
            JSONObject result = new JSONObject();
            result.put("code", (Object)vm.getCode());
            result.put("text", (Object)vm.getText());
            return result;
        }
        if (value instanceof byte[]) {
            return isRootValid ? Base64.encode((byte[])value) : null;
        }
        if (value instanceof JSONObject) {
            return value;
        }
        throw new IllegalArgumentException("unsupported value type " + value.getClass().getName());
    }

    private static boolean isIncludeUidInJSON(String className) {
        EntityType et = MetaRegistryHelper.getEntityType(className);
        while (et != null) {
            if (MiscUtil.isTrue(et.getParameters().get("includeUidInJSON"))) {
                return true;
            }
            et = et.getExtendsId() != null ? (et = MetaRegistryHelper.getEntityType(et.getExtendsId())) : null;
        }
        return false;
    }

    public static <E> Collection<E> unmarshalCollection(JSONArray jsonArray, Class<E> elementType) throws Exception {
        LinkedList<Object> result = new LinkedList<Object>();
        for (int i = 0; i < jsonArray.length(); ++i) {
            result.add(JSONMarshaller.unmarshal(jsonArray.get(i), elementType));
        }
        return result;
    }

    public static Object unmarshal(Object object, Class<?> cls) throws Exception {
        if (Introspectable.class.isAssignableFrom(cls)) {
            Introspectable result = (Introspectable)cls.newInstance();
            if (object != null && !object.equals(JSONObject.NULL)) {
                String name;
                JSONObject json = (JSONObject)object;
                if (result instanceof BaseEntity && JSONMarshaller.isIncludeUidInJSON(result.getClass().getName())) {
                    ((BaseEntity)result).setUid(json.optString("uid"));
                }
                IntrospectableEntityWrapper ew = IntrospectableEntityWrapper.create(cls.getName());
                for (IntrospectableEntityWrapper.IntrospectableEntityPropertyWrapper property : ew.properties) {
                    name = property.id;
                    Object jsonChild = json.opt(name);
                    if (jsonChild == null || jsonChild.equals(JSONObject.NULL)) continue;
                    result.setValue(name, JSONMarshaller.unmarshal(jsonChild, JSONMarshaller.getClass(property.typeForIntrospection)));
                }
                for (IntrospectableEntityWrapper.IntrospectableEntityCollectionWrapper collection : ew.collections) {
                    name = collection.id;
                    JSONArray jsonArray = (JSONArray)json.opt(name);
                    if (jsonArray != null) {
                        Collection resultCol = (Collection)result.getValue(name);
                        for (int i = 0; i < jsonArray.length(); ++i) {
                            resultCol.add(JSONMarshaller.unmarshal(jsonArray.get(i), JSONMarshaller.getClass(collection.elementType)));
                        }
                        continue;
                    }
                    if (!collection.nullable) continue;
                    result.setValue(MetaRegistryHelper.getNullableCollectionPropName(collection.id), true);
                }
            }
            return result;
        }
        if (Enum.class.isAssignableFrom(cls)) {
            return Enum.valueOf(cls, (String)object);
        }
        if (EntityReference.class.isAssignableFrom(cls)) {
            JSONObject json = (JSONObject)object;
            return new EntityReference(json.getString("uid"), XSHelper.getClass(json.getString("type")), json.optString("caption"));
        }
        if (DictionaryReference.class.isAssignableFrom(cls)) {
            JSONObject json = (JSONObject)object;
            Class<?> dictClass = XSHelper.getClass(json.getString("type"));
            BaseDictionary dict = (BaseDictionary)dictClass.newInstance();
            dict.setCode(json.getString("code"));
            return dict.toReference();
        }
        if (BigDecimal.class.isAssignableFrom(cls)) {
            if (object instanceof Integer) {
                return new BigDecimal((Integer)object);
            }
            if (object instanceof BigDecimal) {
                return object;
            }
            if (object instanceof Number) {
                return new BigDecimal(((Number)object).doubleValue());
            }
            return new BigDecimal((String)object);
        }
        if (org.joda.time.LocalDate.class.isAssignableFrom(cls)) {
            return ISODateTimeFormat.dateParser().parseLocalDate((String)object);
        }
        if (LocalTime.class.isAssignableFrom(cls)) {
            return ISODateTimeFormat.timeParser().parseLocalDate((String)object);
        }
        if (org.joda.time.LocalDateTime.class.isAssignableFrom(cls)) {
            return ISODateTimeFormat.dateTimeParser().parseLocalDateTime((String)object);
        }
        if (DateTime.class.isAssignableFrom(cls)) {
            return ISODateTimeFormat.dateTimeParser().parseDateTime((String)object);
        }
        if (LocalDate.class.isAssignableFrom(cls)) {
            return LocalDate.parse((String)object, DateTimeFormatter.ISO_DATE);
        }
        if (java.time.LocalTime.class.isAssignableFrom(cls)) {
            return java.time.LocalTime.parse((String)object, DateTimeFormatter.ISO_TIME);
        }
        if (LocalDateTime.class.isAssignableFrom(cls)) {
            return LocalDateTime.parse((String)object, DateTimeFormatter.ISO_DATE_TIME);
        }
        if (Date.class.isAssignableFrom(cls)) {
            return MiscUtil.toDate(LocalDateTime.parse((String)object, DateTimeFormatter.ISO_DATE_TIME));
        }
        if (Boolean.class.isAssignableFrom(cls) || String.class.isAssignableFrom(cls)) {
            return object;
        }
        if (Double.class.isAssignableFrom(cls)) {
            return object == null ? null : Double.valueOf(((Number)object).doubleValue());
        }
        if (Float.class.isAssignableFrom(cls)) {
            return object == null ? null : Float.valueOf(((Number)object).floatValue());
        }
        if (Integer.class.isAssignableFrom(cls)) {
            return object == null ? null : Integer.valueOf(((Number)object).intValue());
        }
        if (byte[].class.isAssignableFrom(cls)) {
            return Base64.decode((String)object);
        }
        if (JSONObject.class.isAssignableFrom(cls)) {
            return object;
        }
        throw new IllegalArgumentException("unsupported class " + cls.getName());
    }

    private static Class<?> getClass(String name) throws ClassNotFoundException {
        String className = name;
        if (name.indexOf(46) == -1) {
            if (name.charAt(0) >= 'A' && name.charAt(0) <= 'Z') {
                className = "java.lang." + name;
            } else {
                Class clazz = primitives.get(name);
                if (null != clazz) {
                    return clazz;
                }
            }
        } else if (name.startsWith(EntityReference.class.getName())) {
            className = EntityReference.class.getName();
        }
        return Class.forName(className);
    }

    static {
        primitives.put("int", Integer.TYPE);
        primitives.put("long", Long.TYPE);
        primitives.put("double", Double.TYPE);
        primitives.put("float", Float.TYPE);
        primitives.put("boolean", Boolean.TYPE);
        primitives.put("char", Character.TYPE);
        primitives.put("byte", Byte.TYPE);
        primitives.put("short", Short.TYPE);
        primitives.put("byte[]", byte[].class);
    }
}

