/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.l10n;

import com.gridnine.xtrip.common.l10n.model.Number2WordsConverter;
import com.gridnine.xtrip.common.l10n.model.UnsupportedCurrencyException;
import com.ibm.icu.text.RuleBasedNumberFormat;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class EnglishNumber2WordsConverter
implements Number2WordsConverter {
    private static final String SEPARATOR = " ";
    private static final Locale locale = new Locale("en");
    private static final Map<String, CurrencyData> currencies = new HashMap<String, CurrencyData>();
    private final RuleBasedNumberFormat ruleBasedNumberFormat = new RuleBasedNumberFormat(new Locale("EN"), 1);

    @Override
    public Locale getLocale() {
        return locale;
    }

    private static void initCurrencies() {
        currencies.put("BGN", new CurrencyData("lv.", "Bulgarian lev", "Bulgarian levs", "stotinki", "stotinki"));
        currencies.put("HRK", new CurrencyData("kn", "Croatian kuna", "Croatian kunas", "lp", "lipas"));
        currencies.put("BYR", new CurrencyData("rub.", "Belarusian ruble", "Belarusian rubles", "kop.", "kapeykas"));
        currencies.put("NOK", new CurrencyData("kr", "Norwegian krone", "Norwegian kroner", "\u00f8re", "\u00f8re"));
        currencies.put("LTL", new CurrencyData("Lt", "Lithuanian litas", "Lithuanian litai", "ct", "centai"));
        currencies.put("SEK", new CurrencyData("kr", "Swedish krona", "Swedish kronor", "\u00f6re", "\u00f6re"));
        currencies.put("TRY", new CurrencyData("l.", "Turkish lira", "Turkish liras", "k.", "Kuru\u015f"));
        currencies.put("HUF", new CurrencyData("Ft", "Hungarian forint", "Hungarian forints", "f.", "fill\u00e9r"));
        currencies.put("ZAR", new CurrencyData("R", "South African rand", "South African rand", "c", "Cent"));
        currencies.put("USD", new CurrencyData("$", "United States dollar", "United States dollars", "\u00a2", "cents"));
        currencies.put("BRL", new CurrencyData("R$", "Brazilian real", "Brazilian reais", "c.", "centavos"));
        currencies.put("ISK", new CurrencyData("kr", "Icelandic kr\u00f3na", "Icelandic kr\u00f3nur", "e.", "eyrir"));
        currencies.put("CAD", new CurrencyData("$", "Canadian dollar", "Canadian dollars", "\u00a2", "cents"));
        currencies.put("PLN", new CurrencyData("z\u0142", "Polish z\u0142oty", "Polish z\u0142oty", "gr", "groszy"));
        currencies.put("CZK", new CurrencyData("K\u010d", "Czech koruna", "Czech korunas", "h", "hal\u00e9\u0159"));
        currencies.put("MKD", new CurrencyData("\u0434\u0435\u043d", "Macedonian denar", "Macedonian denari", "deni", "deni"));
        currencies.put("EUR", new CurrencyData("\u20ac", "Euro", "Euros", "c", "cent"));
        currencies.put("CHF", new CurrencyData("Fr", "Swiss franc", "Swiss francs", "centimes", "centimes"));
        currencies.put("ROL", new CurrencyData("leu", "Romanian leu", "Romanian lei", "bani", "bani"));
        currencies.put("DKK", new CurrencyData("kr.", "Danish krone", "Danish kroner", "\u00f8re", "\u00f8re"));
        currencies.put("RUR", new CurrencyData("rub.", "Russian Ruble", "Russian Rubles", "kop.", "kopecks"));
        currencies.put("RUB", new CurrencyData("rub.", "Russian Ruble", "Russian Rubles", "kop.", "kopecks"));
        currencies.put("AUD", new CurrencyData("A$", "Australian dollar", "Australian dollars", "c", "cent"));
        currencies.put("ALL", new CurrencyData("L", "Albanian lek", "Albanian lek\u00eb", "qindark\u00eb", "qindark\u00eb"));
        currencies.put("UAH", new CurrencyData("hrn", "Ukrainian hryvnia", "Ukrainian hryvni", "kop.", "kopiyky"));
        currencies.put("JPY", new CurrencyData("\u00a5", "Japanese yen", "Japanese yen", "sen", "sen"));
        currencies.put("KZT", new CurrencyData("tg", "Kazakhstani tenge", "Kazakhstani tenge", "tiyn", "tiyn"));
    }

    @Override
    public Set<String> getCurrencies() {
        return Collections.unmodifiableSet(currencies.keySet());
    }

    @Override
    public String toNumberWords(BigDecimal number) {
        return this.ruleBasedNumberFormat.format(number);
    }

    @Override
    public String toCurrencyWords(BigDecimal amount, String currency, boolean ignoreZeroDecimal, boolean ignoreZeroFraction, boolean convertFraction) throws UnsupportedCurrencyException {
        return this.toCurrencyWords(amount, currency, ignoreZeroDecimal, ignoreZeroFraction, convertFraction, false);
    }

    @Override
    public String toCurrencyWords(BigDecimal amount, String currency, boolean ignoreZeroDecimal, boolean ignoreZeroFraction, boolean convertFraction, boolean shortName) throws UnsupportedCurrencyException {
        String words;
        if (amount == null) {
            throw new IllegalArgumentException("Amount is null");
        }
        if (currency == null) {
            throw new IllegalArgumentException("Currency is null");
        }
        if (!this.getCurrencies().contains(currency)) {
            throw new UnsupportedCurrencyException(String.format("Currency %s is not supported", currency));
        }
        CurrencyData currencyData = currencies.get(currency);
        StringBuilder currencyWords = new StringBuilder();
        String[] entries = amount.setScale(2, RoundingMode.HALF_UP).toPlainString().split("\\.");
        BigDecimal decimal = new BigDecimal(entries[0]);
        BigDecimal fraction = new BigDecimal(entries[1]);
        if (!ignoreZeroDecimal || decimal.compareTo(BigDecimal.ZERO) != 0) {
            words = this.toNumberWords(decimal);
            currencyWords.append(words);
            currencyWords.append(SEPARATOR);
            if (shortName) {
                currencyWords.append(currencyData.decimalShortNameSingular);
            } else if (decimal.intValue() == 1) {
                currencyWords.append(currencyData.decimalNameSingular);
            } else {
                currencyWords.append(currencyData.decimalNamePlural);
            }
        }
        if (!ignoreZeroFraction || fraction.compareTo(BigDecimal.ZERO) != 0) {
            words = this.toNumberWords(fraction);
            if (currencyWords.length() > 0) {
                currencyWords.append(SEPARATOR);
            }
            if (convertFraction) {
                currencyWords.append(words);
            } else {
                currencyWords.append(String.format("%02d", fraction.intValue()));
            }
            currencyWords.append(SEPARATOR);
            if (!shortName || null == currencyData.fractionShortName) {
                currencyWords.append(currencyData.fractionName);
            } else {
                currencyWords.append(currencyData.fractionShortName);
            }
        }
        return currencyWords.toString();
    }

    static {
        EnglishNumber2WordsConverter.initCurrencies();
    }

    private static class CurrencyData {
        private final String decimalShortNameSingular;
        private final String decimalNameSingular;
        private final String decimalNamePlural;
        private final String fractionShortName;
        private final String fractionName;

        CurrencyData(String decimalShortNameSingular, String decimalNameSingular, String decimalNamePlural, String fractionShortName, String fractionName) {
            this.decimalShortNameSingular = decimalShortNameSingular;
            this.decimalNameSingular = decimalNameSingular;
            this.decimalNamePlural = decimalNamePlural;
            this.fractionShortName = fractionShortName;
            this.fractionName = fractionName;
        }
    }
}

