/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.l10n;

import com.gridnine.xtrip.common.l10n.RussianNumberConverter;
import com.gridnine.xtrip.common.l10n.model.Number2WordsConverter;
import com.gridnine.xtrip.common.l10n.model.UnsupportedCurrencyException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class RussiaNumber2WordsConverter
extends RussianNumberConverter
implements Number2WordsConverter {
    private static final String ZERO = "\u043d\u043e\u043b\u044c";
    private static final Locale locale = new Locale("ru");
    private static final Map<String, CurrencyData> currencies = new HashMap<String, CurrencyData>();

    @Override
    public Locale getLocale() {
        return locale;
    }

    @Override
    public Set<String> getCurrencies() {
        return Collections.unmodifiableSet(currencies.keySet());
    }

    @Override
    public String toNumberWords(BigDecimal number) {
        if (number == null) {
            throw new IllegalArgumentException("Amount is null");
        }
        String[] entries = number.toPlainString().split("\\.");
        BigDecimal decimal = new BigDecimal(entries[0]);
        if (decimal.compareTo(BigDecimal.ZERO) == 0) {
            return ZERO;
        }
        RussianNumberConverter.WordsData wordsData = this.convertNumber(decimal.toPlainString(), RussianNumberConverter.Gender.MASCULINE);
        return wordsData.words;
    }

    @Override
    public String toCurrencyWords(BigDecimal amount, String currency, boolean ignoreZeroDecimal, boolean ignoreZeroFraction, boolean convertFraction) throws UnsupportedCurrencyException {
        return this.toCurrencyWords(amount, currency, ignoreZeroDecimal, ignoreZeroFraction, convertFraction, false);
    }

    @Override
    public String toCurrencyWords(BigDecimal amount, String currency, boolean ignoreZeroDecimal, boolean ignoreZeroFraction, boolean convertFraction, boolean shortName) throws UnsupportedCurrencyException {
        RussianNumberConverter.Declension numberDeclension;
        String numberWords;
        RussianNumberConverter.WordsData wordsData;
        if (amount == null) {
            throw new IllegalArgumentException("Amount is null");
        }
        if (currency == null) {
            throw new IllegalArgumentException("Currency is null");
        }
        if (!this.getCurrencies().contains(currency)) {
            throw new UnsupportedCurrencyException(String.format("Currency %s is not supported", currency));
        }
        CurrencyData currencyData = currencies.get(currency);
        StringBuilder currencyWords = new StringBuilder();
        String[] entries = amount.setScale(2, RoundingMode.HALF_UP).toPlainString().split("\\.");
        BigDecimal decimal = new BigDecimal(entries[0]);
        BigDecimal fraction = new BigDecimal(entries[1]);
        if (!ignoreZeroDecimal || decimal.compareTo(BigDecimal.ZERO) != 0) {
            wordsData = this.convertNumber(decimal.toPlainString(), currencyData.decimalGender);
            numberWords = wordsData.words;
            numberDeclension = wordsData.declension;
            if (numberWords == null) {
                numberWords = ZERO;
                numberDeclension = RussianNumberConverter.Declension.THIRD;
            }
            currencyWords.append(numberWords);
            currencyWords.append(" ");
            if (!shortName || null == currencyData.decimalShortName) {
                currencyWords.append(currencyData.decimalNames.get((Object)numberDeclension));
            } else {
                currencyWords.append(currencyData.decimalShortName);
            }
        }
        if (!ignoreZeroFraction || fraction.compareTo(BigDecimal.ZERO) != 0) {
            wordsData = this.convertNumber(fraction.toPlainString(), currencyData.fractionGender);
            numberWords = wordsData.words;
            numberDeclension = wordsData.declension;
            if (numberWords == null) {
                numberWords = ZERO;
                numberDeclension = RussianNumberConverter.Declension.THIRD;
            }
            if (currencyWords.length() > 0) {
                currencyWords.append(" ");
            }
            if (convertFraction) {
                currencyWords.append(numberWords);
            } else {
                currencyWords.append(String.format("%02d", fraction.intValue()));
            }
            currencyWords.append(" ");
            if (!shortName || null == currencyData.fractionShortName) {
                currencyWords.append(currencyData.fractionNames.get((Object)numberDeclension));
            } else {
                currencyWords.append(currencyData.fractionShortName);
            }
        }
        return currencyWords.toString();
    }

    static {
        currencies.put("ALL", new CurrencyData(RussianNumberConverter.Gender.MASCULINE, new String[]{"\u043b\u0435\u043a", "\u043b\u0435\u043a\u0430", "\u043b\u0435\u043a\u043e\u0432"}, RussianNumberConverter.Gender.FEMININE, new String[]{"\u043a\u0438\u043d\u0434\u0430\u0440\u043a\u0430", "\u043a\u0438\u043d\u0434\u0430\u0440\u043a\u0438", "\u043a\u0438\u043d\u0434\u0430\u0440\u043e\u043a"}));
        currencies.put("AUD", new CurrencyData(RussianNumberConverter.Gender.MASCULINE, new String[]{"\u0430\u0432\u0441\u0442\u0440\u0430\u043b\u0438\u0439\u0441\u043a\u0438\u0439 \u0434\u043e\u043b\u043b\u0430\u0440", "\u0430\u0432\u0441\u0442\u0440\u0430\u043b\u0438\u0439\u0441\u043a\u0438\u0445 \u0434\u043e\u043b\u043b\u0430\u0440\u0430", "\u0430\u0432\u0441\u0442\u0440\u0430\u043b\u0438\u0439\u0441\u043a\u0438\u0445 \u0434\u043e\u043b\u043b\u0430\u0440\u043e\u0432"}, RussianNumberConverter.Gender.MASCULINE, new String[]{"\u0446\u0435\u043d\u0442", "\u0446\u0435\u043d\u0442\u0430", "\u0446\u0435\u043d\u0442\u043e\u0432"}));
        currencies.put("BGN", new CurrencyData(RussianNumberConverter.Gender.MASCULINE, new String[]{"\u043b\u0435\u0432", "\u043b\u0435\u0432\u0430", "\u043b\u0435\u0432\u043e\u0432"}, RussianNumberConverter.Gender.FEMININE, new String[]{"\u0441\u0442\u043e\u0442\u0438\u043d\u043a\u0430", "\u0441\u0442\u043e\u0442\u0438\u043d\u043a\u0438", "\u0441\u0442\u043e\u0442\u0438\u043d\u043e\u043a"}));
        currencies.put("BRL", new CurrencyData(RussianNumberConverter.Gender.MASCULINE, new String[]{"\u0431\u0440\u0430\u0437\u0438\u043b\u044c\u0441\u043a\u0438\u0439 \u0440\u0435\u0430\u043b", "\u0431\u0440\u0430\u0437\u0438\u043b\u044c\u0441\u043a\u0438\u0445 \u0440\u0435\u0430\u043b\u0430", "\u0431\u0440\u0430\u0437\u0438\u043b\u044c\u0441\u043a\u0438\u0445 \u0440\u0435\u0430\u043b\u043e\u0432"}, RussianNumberConverter.Gender.MASCULINE, new String[]{"\u0441\u0435\u043d\u0442\u0430\u0432\u043e", "\u0441\u0435\u043d\u0442\u0430\u0432\u043e", "\u0441\u0435\u043d\u0442\u0430\u0432\u043e"}));
        currencies.put("BYR", new CurrencyData(RussianNumberConverter.Gender.MASCULINE, new String[]{"\u0431\u0435\u043b\u043e\u0440\u0443\u0441\u0441\u043a\u0438\u0439 \u0440\u0443\u0431\u043b\u044c", "\u0431\u0435\u043b\u043e\u0440\u0443\u0441\u0441\u043a\u0438\u0445 \u0440\u0443\u0431\u043b\u044f", "\u0431\u0435\u043b\u043e\u0440\u0443\u0441\u0441\u043a\u0438\u0445 \u0440\u0443\u0431\u043b\u0435\u0439"}, RussianNumberConverter.Gender.FEMININE, new String[]{"\u043a\u043e\u043f\u0435\u0439\u043a\u0430", "\u043a\u043e\u043f\u0435\u0439\u043a\u0438", "\u043a\u043e\u043f\u0435\u0435\u043a"}));
        currencies.put("CAD", new CurrencyData(RussianNumberConverter.Gender.MASCULINE, new String[]{"\u043a\u0430\u043d\u0430\u0434\u0441\u043a\u0438\u0439 \u0434\u043e\u043b\u043b\u0430\u0440", "\u043a\u0430\u043d\u0430\u0434\u0441\u043a\u0438\u0445 \u0434\u043e\u043b\u043b\u0430\u0440\u0430", "\u043a\u0430\u043d\u0430\u0434\u0441\u043a\u0438\u0445 \u0434\u043e\u043b\u043b\u0430\u0440\u043e\u0432"}, RussianNumberConverter.Gender.MASCULINE, new String[]{"\u0446\u0435\u043d\u0442", "\u0446\u0435\u043d\u0442\u0430", "\u0446\u0435\u043d\u0442\u043e\u0432"}));
        currencies.put("CHF", new CurrencyData(RussianNumberConverter.Gender.MASCULINE, new String[]{"\u0448\u0432\u0435\u0439\u0446\u0430\u0440\u0441\u043a\u0438\u0439 \u0444\u0440\u0430\u043d\u043a", "\u0448\u0432\u0435\u0439\u0446\u0430\u0440\u0441\u043a\u0438\u0445 \u0444\u0440\u0430\u043d\u043a\u0430", "\u0448\u0432\u0435\u0439\u0446\u0430\u0440\u0441\u043a\u0438\u0445 \u0444\u0440\u0430\u043d\u043a\u043e\u0432"}, RussianNumberConverter.Gender.MASCULINE, new String[]{"\u0441\u0430\u043d\u0442\u0438\u043c", "\u0441\u0430\u043d\u0442\u0438\u043c\u0430", "\u0441\u0430\u043d\u0442\u0438\u043c\u043e\u0432"}));
        currencies.put("CYP", new CurrencyData(RussianNumberConverter.Gender.MASCULINE, new String[]{"\u043a\u0438\u043f\u0440\u0441\u043a\u0438\u0439 \u0444\u0443\u043d\u0442", "\u043a\u0438\u043f\u0440\u0441\u043a\u0438\u0445 \u0444\u0443\u043d\u0442\u0430", "\u043a\u0438\u043f\u0440\u0441\u043a\u0438\u0445 \u0444\u0443\u043d\u0442\u043e\u0432"}, RussianNumberConverter.Gender.MASCULINE, new String[]{"\u0446\u0435\u043d\u0442", "\u0446\u0435\u043d\u0442\u0430", "\u0446\u0435\u043d\u0442\u043e\u0432"}));
        currencies.put("CZK", new CurrencyData(RussianNumberConverter.Gender.FEMININE, new String[]{"\u0447\u0435\u0448\u0441\u043a\u0430\u044f \u043a\u0440\u043e\u043d\u0430", "\u0447\u0435\u0448\u0441\u043a\u0438\u0445 \u043a\u0440\u043e\u043d\u044b", "\u0447\u0435\u0448\u0441\u043a\u0438\u0445 \u043a\u0440\u043e\u043d"}, RussianNumberConverter.Gender.MASCULINE, new String[]{"\u0433\u0430\u043b\u0438\u0440\u0436", "\u0433\u0430\u043b\u0438\u0440\u0436\u0430", "\u0433\u0430\u043b\u0438\u0440\u0436\u0435\u0439"}));
        currencies.put("DKK", new CurrencyData(RussianNumberConverter.Gender.FEMININE, new String[]{"\u0434\u0430\u0442\u0441\u043a\u0430\u044f \u043a\u0440\u043e\u043d\u0430", "\u0434\u0430\u0442\u0441\u043a\u0438\u0445 \u043a\u0440\u043e\u043d\u044b", "\u0434\u0430\u0442\u0441\u043a\u0438\u0445 \u043a\u0440\u043e\u043d"}, RussianNumberConverter.Gender.MASCULINE, new String[]{"\u044d\u0440\u0435", "\u044d\u0440\u0435", "\u044d\u0440\u0435"}));
        currencies.put("EEK", new CurrencyData(RussianNumberConverter.Gender.FEMININE, new String[]{"\u044d\u0441\u0442\u043e\u043d\u0441\u043a\u0430\u044f \u043a\u0440\u043e\u043d\u0430", "\u044d\u0441\u0442\u043e\u043d\u0441\u043a\u0438\u0445 \u043a\u0440\u043e\u043d\u044b", "\u044d\u0441\u0442\u043e\u043d\u0441\u043a\u0438\u0445 \u043a\u0440\u043e\u043d"}, RussianNumberConverter.Gender.MASCULINE, new String[]{"\u0446\u0435\u043d\u0442", "\u0446\u0435\u043d\u0442\u0430", "\u0446\u0435\u043d\u0442\u043e\u0432"}));
        currencies.put("EUR", new CurrencyData(RussianNumberConverter.Gender.MASCULINE, new String[]{"\u0435\u0432\u0440\u043e", "\u0435\u0432\u0440\u043e", "\u0435\u0432\u0440\u043e"}, RussianNumberConverter.Gender.MASCULINE, new String[]{"\u0435\u0432\u0440\u043e\u0446\u0435\u043d\u0442", "\u0435\u0432\u0440\u043e\u0446\u0435\u043d\u0442\u0430", "\u0435\u0432\u0440\u043e\u0446\u0435\u043d\u0442\u043e\u0432"}));
        currencies.put("GBP", new CurrencyData(RussianNumberConverter.Gender.MASCULINE, new String[]{"\u0444\u0443\u043d\u0442 \u0441\u0442\u0435\u0440\u043b\u0438\u043d\u0433\u043e\u0432", "\u0444\u0443\u043d\u0442\u0430 \u0441\u0442\u0435\u0440\u043b\u0438\u043d\u0433\u043e\u0432", "\u0444\u0443\u043d\u0442\u043e\u0432 \u0441\u0442\u0435\u0440\u043b\u0438\u043d\u0433\u043e\u0432"}, RussianNumberConverter.Gender.MASCULINE, new String[]{"\u043f\u0435\u043d\u0441", "\u043f\u0435\u043d\u0441\u0430", "\u043f\u0435\u043d\u0441\u043e\u0432"}));
        currencies.put("HKD", new CurrencyData(RussianNumberConverter.Gender.MASCULINE, new String[]{"\u0433\u043e\u043d\u043a\u043e\u043d\u0433\u0441\u043a\u0438\u0439 \u0434\u043e\u043b\u043b\u0430\u0440", "\u0433\u043e\u043d\u043a\u043e\u043d\u0433\u0441\u043a\u0438\u0445 \u0434\u043e\u043b\u043b\u0430\u0440\u0430", "\u0433\u043e\u043d\u043a\u043e\u043d\u0433\u0441\u043a\u0438\u0445 \u0434\u043e\u043b\u043b\u0430\u0440\u043e\u0432"}, RussianNumberConverter.Gender.MASCULINE, new String[]{"\u0446\u0435\u043d\u0442", "\u0446\u0435\u043d\u0442\u0430", "\u0446\u0435\u043d\u0442\u043e\u0432"}));
        currencies.put("HRK", new CurrencyData(RussianNumberConverter.Gender.FEMININE, new String[]{"\u0445\u043e\u0440\u0432\u0430\u0442\u0441\u043a\u0430\u044f \u043a\u0443\u043d\u0430", "\u0445\u043e\u0440\u0432\u0430\u0442\u0441\u043a\u0438\u0445 \u043a\u0443\u043d\u044b", "\u0445\u043e\u0440\u0432\u0430\u0442\u0441\u043a\u0438\u0445 \u043a\u0443\u043d"}, RussianNumberConverter.Gender.FEMININE, new String[]{"\u043b\u0438\u043f\u0430", "\u043b\u0438\u043f\u044b", "\u043b\u0438\u043f"}));
        currencies.put("HUF", new CurrencyData(RussianNumberConverter.Gender.MASCULINE, new String[]{"\u0432\u0435\u043d\u0433\u0435\u0440\u0441\u043a\u0438\u0439 \u0444\u043e\u0440\u0438\u043d\u0442", "\u0432\u0435\u043d\u0433\u0435\u0440\u0441\u043a\u0438\u0445 \u0444\u043e\u0440\u0438\u043d\u0442\u0430", "\u0432\u0435\u043d\u0433\u0435\u0440\u0441\u043a\u0438\u0445 \u0444\u043e\u0440\u0438\u043d\u0442\u043e\u0432"}, RussianNumberConverter.Gender.MASCULINE, new String[]{"\u0444\u0438\u043b\u043b\u0435\u0440", "\u0444\u0438\u043b\u043b\u0435\u0440\u0430", "\u0444\u0438\u043b\u043b\u0435\u0440\u043e\u0432"}));
        currencies.put("ISK", new CurrencyData(RussianNumberConverter.Gender.FEMININE, new String[]{"\u0438\u0441\u043b\u0430\u043d\u0434\u0441\u043a\u0430\u044f \u043a\u0440\u043e\u043d\u0430", "\u0438\u0441\u043b\u0430\u043d\u0434\u0441\u043a\u0438\u0445 \u043a\u0440\u043e\u043d\u044b", "\u0438\u0441\u043b\u0430\u043d\u0434\u0441\u043a\u0438\u0445 \u043a\u0440\u043e\u043d"}, RussianNumberConverter.Gender.MASCULINE, new String[]{"\u044d\u0440\u0435", "\u044d\u0440\u0435", "\u044d\u0440\u0435"}));
        currencies.put("JPY", new CurrencyData(RussianNumberConverter.Gender.FEMININE, new String[]{"\u0438\u0435\u043d\u0430", "\u0438\u0435\u043d\u044b", "\u0438\u0435\u043d"}, RussianNumberConverter.Gender.FEMININE, new String[]{"\u0441\u0435\u043d\u0430", "\u0441\u0435\u043d\u044b", "\u0441\u0435\u043d"}));
        currencies.put("LTL", new CurrencyData(RussianNumberConverter.Gender.MASCULINE, new String[]{"\u043b\u0438\u0442", "\u043b\u0438\u0442\u0430", "\u043b\u0438\u0442\u043e\u0432"}, RussianNumberConverter.Gender.MASCULINE, new String[]{"\u0446\u0435\u043d\u0442", "\u0446\u0435\u043d\u0442\u0430", "\u0446\u0435\u043d\u0442\u043e\u0432"}));
        currencies.put("LVL", new CurrencyData(RussianNumberConverter.Gender.MASCULINE, new String[]{"\u043b\u0430\u0442", "\u043b\u0430\u0442\u0430", "\u043b\u0430\u0442\u043e\u0432"}, RussianNumberConverter.Gender.MASCULINE, new String[]{"\u0441\u0430\u043d\u0442\u0438\u043c", "\u0441\u0430\u043d\u0442\u0438\u043c\u0430", "\u0441\u0430\u043d\u0442\u0438\u043c\u043e\u0432"}));
        currencies.put("MKD", new CurrencyData(RussianNumberConverter.Gender.MASCULINE, new String[]{"\u043c\u0430\u043a\u0435\u0434\u043e\u043d\u0441\u043a\u0438\u0439 \u0434\u0438\u043d\u0430\u0440", "\u043c\u0430\u043a\u0435\u0434\u043e\u043d\u0441\u043a\u0438\u0445 \u0434\u0438\u043d\u0430\u0440\u0430", "\u043c\u0430\u043a\u0435\u0434\u043e\u043d\u0441\u043a\u0438\u0445 \u0434\u0438\u043d\u0430\u0440\u043e\u0432"}, RussianNumberConverter.Gender.MASCULINE, new String[]{"\u0434\u0435\u043d\u0438", "\u0434\u0435\u043d\u0438", "\u0434\u0435\u043d\u0438"}));
        currencies.put("MTL", new CurrencyData(RussianNumberConverter.Gender.FEMININE, new String[]{"\u043c\u0430\u043b\u044c\u0442\u0438\u0439\u0441\u043a\u0430\u044f \u043b\u0438\u0440\u0430", "\u043c\u0430\u043b\u044c\u0442\u0438\u0439\u0441\u043a\u0438\u0445 \u043b\u0438\u0440\u044b", "\u043c\u0430\u043b\u044c\u0442\u0438\u0439\u0441\u043a\u0438\u0445 \u043b\u0438\u0440"}, RussianNumberConverter.Gender.MASCULINE, new String[]{"\u0446\u0435\u043d\u0442", "\u0446\u0435\u043d\u0442\u0430", "\u0446\u0435\u043d\u0442\u043e\u0432"}));
        currencies.put("NOK", new CurrencyData(RussianNumberConverter.Gender.FEMININE, new String[]{"\u043d\u043e\u0440\u0432\u0435\u0436\u0441\u043a\u0430\u044f \u043a\u0440\u043e\u043d\u0430", "\u043d\u043e\u0440\u0432\u0435\u0436\u0441\u043a\u0438\u0445 \u043a\u0440\u043e\u043d\u044b", "\u043d\u043e\u0440\u0432\u0435\u0436\u0441\u043a\u0438\u0445 \u043a\u0440\u043e\u043d"}, RussianNumberConverter.Gender.NEUTER, new String[]{"\u044d\u0440\u0435", "\u044d\u0440\u0435", "\u044d\u0440\u0435"}));
        currencies.put("PLN", new CurrencyData(RussianNumberConverter.Gender.MASCULINE, new String[]{"\u0437\u043b\u043e\u0442\u044b\u0439", "\u0437\u043b\u043e\u0442\u044b\u0445", "\u0437\u043b\u043e\u0442\u044b\u0445"}, RussianNumberConverter.Gender.MASCULINE, new String[]{"\u0433\u0440\u043e\u0448", "\u0433\u0440\u043e\u0448\u0430", "\u0433\u0440\u043e\u0448\u0435\u0439"}));
        currencies.put("ROL", new CurrencyData(RussianNumberConverter.Gender.MASCULINE, new String[]{"\u0440\u0443\u043c\u044b\u043d\u0441\u043a\u0438\u0439 \u043b\u0435\u0439", "\u0440\u0443\u043c\u044b\u043d\u0441\u043a\u0438\u0445 \u043b\u0435\u0439", "\u0440\u0443\u043c\u044b\u043d\u0441\u043a\u0438\u0445 \u043b\u0435\u0439"}, RussianNumberConverter.Gender.MASCULINE, new String[]{"\u0431\u0430\u043d\u044c", "\u0431\u0430\u043d\u0438", "\u0431\u0430\u043d\u0435\u0439"}));
        currencies.put("RUB", new CurrencyData(RussianNumberConverter.Gender.MASCULINE, new String[]{"\u0440\u0443\u0431\u043b\u044c", "\u0440\u0443\u0431\u043b\u044f", "\u0440\u0443\u0431\u043b\u0435\u0439"}, "\u0440\u0443\u0431.", RussianNumberConverter.Gender.FEMININE, new String[]{"\u043a\u043e\u043f\u0435\u0439\u043a\u0430", "\u043a\u043e\u043f\u0435\u0439\u043a\u0438", "\u043a\u043e\u043f\u0435\u0435\u043a"}, "\u043a\u043e\u043f."));
        currencies.put("RUR", new CurrencyData(RussianNumberConverter.Gender.MASCULINE, new String[]{"\u0440\u043e\u0441\u0441\u0438\u0439\u0441\u043a\u0438\u0439 \u0440\u0443\u0431\u043b\u044c", "\u0440\u043e\u0441\u0441\u0438\u0439\u0441\u043a\u0438\u0445 \u0440\u0443\u0431\u043b\u044f", "\u0440\u043e\u0441\u0441\u0438\u0439\u0441\u043a\u0438\u0445 \u0440\u0443\u0431\u043b\u0435\u0439"}, RussianNumberConverter.Gender.FEMININE, new String[]{"\u043a\u043e\u043f\u0435\u0439\u043a\u0430", "\u043a\u043e\u043f\u0435\u0439\u043a\u0438", "\u043a\u043e\u043f\u0435\u0435\u043a"}));
        currencies.put("SEK", new CurrencyData(RussianNumberConverter.Gender.FEMININE, new String[]{"\u0448\u0432\u0435\u0434\u0441\u043a\u0430\u044f \u043a\u0440\u043e\u043d\u0430", "\u0448\u0432\u0435\u0434\u0441\u043a\u0438\u0445 \u043a\u0440\u043e\u043d\u044b", "\u0448\u0432\u0435\u0434\u0441\u043a\u0438\u0445 \u043a\u0440\u043e\u043d"}, RussianNumberConverter.Gender.MASCULINE, new String[]{"\u044d\u0440\u0435", "\u044d\u0440\u0435", "\u044d\u0440\u0435"}));
        currencies.put("SIT", new CurrencyData(RussianNumberConverter.Gender.MASCULINE, new String[]{"\u0441\u043b\u043e\u0432\u0435\u043d\u0441\u043a\u0438\u0439 \u0442\u043e\u043b\u0430\u0440", "\u0441\u043b\u043e\u0432\u0435\u043d\u0441\u043a\u0438\u0445 \u0442\u043e\u043b\u0430\u0440\u0430", "\u0441\u043b\u043e\u0432\u0435\u043d\u0441\u043a\u0438\u0445 \u0442\u043e\u043b\u0430\u0440\u043e\u0432"}, RussianNumberConverter.Gender.FEMININE, new String[]{"\u0441\u0442\u043e\u0442\u0438\u043d\u0430", "\u0441\u0442\u043e\u0442\u0438\u043d\u044b", "\u0441\u0442\u043e\u0442\u0438\u043d"}));
        currencies.put("SKK", new CurrencyData(RussianNumberConverter.Gender.FEMININE, new String[]{"\u0441\u043b\u043e\u0432\u0430\u0446\u043a\u0430\u044f \u043a\u0440\u043e\u043d\u0430", "\u0441\u043b\u043e\u0432\u0430\u0446\u043a\u0438\u0445 \u043a\u0440\u043e\u043d\u044b", "\u0441\u043b\u043e\u0432\u0430\u0446\u043a\u0438\u0445 \u043a\u0440\u043e\u043d"}, RussianNumberConverter.Gender.NEUTER, new String[]{"\u0433\u0435\u043b\u043b\u0435\u0440", "\u0433\u0435\u043b\u043b\u0435\u0440\u0430", "\u0433\u0435\u043b\u043b\u0435\u0440\u043e\u0432"}));
        currencies.put("TRY", new CurrencyData(RussianNumberConverter.Gender.FEMININE, new String[]{"\u0442\u0443\u0440\u0435\u0446\u043a\u0430\u044f \u043b\u0438\u0440\u0430", "\u0442\u0443\u0440\u0435\u0446\u043a\u0438\u0445 \u043b\u0438\u0440\u044b", "\u0442\u0443\u0440\u0435\u0446\u043a\u0438\u0445 \u043b\u0438\u0440"}, RussianNumberConverter.Gender.MASCULINE, new String[]{"\u043f\u0438\u0430\u0441\u0442\u0440", "\u043f\u0438\u0430\u0441\u0442\u0440\u0430", "\u043f\u0438\u0430\u0441\u0442\u0440\u043e\u0432"}));
        currencies.put("UAH", new CurrencyData(RussianNumberConverter.Gender.FEMININE, new String[]{"\u0433\u0440\u0438\u0432\u043d\u0430", "\u0433\u0440\u0438\u0432\u043d\u044b", "\u0433\u0440\u0438\u0432\u0435\u043d"}, RussianNumberConverter.Gender.FEMININE, new String[]{"\u043a\u043e\u043f\u0435\u0439\u043a\u0430", "\u043a\u043e\u043f\u0435\u0439\u043a\u0438", "\u043a\u043e\u043f\u0435\u0435\u043a"}));
        currencies.put("USD", new CurrencyData(RussianNumberConverter.Gender.MASCULINE, new String[]{"\u0434\u043e\u043b\u043b\u0430\u0440 \u0421\u0428\u0410", "\u0434\u043e\u043b\u043b\u0430\u0440\u0430 \u0421\u0428\u0410", "\u0434\u043e\u043b\u043b\u0430\u0440\u043e\u0432 \u0421\u0428\u0410"}, RussianNumberConverter.Gender.MASCULINE, new String[]{"\u0446\u0435\u043d\u0442", "\u0446\u0435\u043d\u0442\u0430", "\u0446\u0435\u043d\u0442\u043e\u0432"}));
        currencies.put("YUM", new CurrencyData(RussianNumberConverter.Gender.MASCULINE, new String[]{"\u044e\u0433\u043e\u0441\u043b\u0430\u0432\u0441\u043a\u0438\u0439 \u0434\u0438\u043d\u0430\u0440", "\u044e\u0433\u043e\u0441\u043b\u0430\u0432\u0441\u043a\u0438\u0445 \u0434\u0438\u043d\u0430\u0440\u0430", "\u044e\u0433\u043e\u0441\u043b\u0430\u0432\u0441\u043a\u0438\u0445 \u0434\u0438\u043d\u0430\u0440\u043e\u0432"}, RussianNumberConverter.Gender.MASCULINE, new String[]{"\u043f\u0430\u0440\u0430", "\u043f\u0430\u0440\u0430", "\u043f\u0430\u0440\u0430"}));
        currencies.put("ZAR", new CurrencyData(RussianNumberConverter.Gender.MASCULINE, new String[]{"\u0440\u0430\u043d\u0434", "\u0440\u0430\u043d\u0434\u0430", "\u0440\u0430\u043d\u0434\u043e\u0432"}, RussianNumberConverter.Gender.MASCULINE, new String[]{"\u0446\u0435\u043d\u0442", "\u0446\u0435\u043d\u0442\u0430", "\u0446\u0435\u043d\u0442\u043e\u0432"}));
        currencies.put("KZT", new CurrencyData(RussianNumberConverter.Gender.MASCULINE, new String[]{"\u0442\u0435\u043d\u0433\u0435", "\u0442\u0435\u043d\u0433\u0435", "\u0442\u0435\u043d\u0433\u0435"}, RussianNumberConverter.Gender.MASCULINE, new String[]{"\u0442\u0438\u044b\u043d", "\u0442\u0438\u044b\u043d", "\u0442\u0438\u044b\u043d"}));
        currencies.put("UZS", new CurrencyData(RussianNumberConverter.Gender.MASCULINE, new String[]{"\u0441\u0443\u043c", "\u0441\u0443\u043c\u0430", "\u0441\u0443\u043c\u043e\u0432"}, RussianNumberConverter.Gender.MASCULINE, new String[]{"\u0442\u0438\u0439\u0438\u043d", "\u0442\u0438\u0439\u0438\u043d\u0430", "\u0442\u0438\u0439\u0438\u043d\u043e\u0432"}));
    }

    private static class CurrencyData {
        public final RussianNumberConverter.Gender decimalGender;
        public final Map<RussianNumberConverter.Declension, String> decimalNames = new HashMap<RussianNumberConverter.Declension, String>();
        public final RussianNumberConverter.Gender fractionGender;
        public final Map<RussianNumberConverter.Declension, String> fractionNames = new HashMap<RussianNumberConverter.Declension, String>();
        public final String decimalShortName;
        public final String fractionShortName;

        public CurrencyData(RussianNumberConverter.Gender decimalGender, String[] decimalNames, RussianNumberConverter.Gender fractionGender, String[] fractionNames) {
            this.decimalGender = decimalGender;
            this.decimalNames.put(RussianNumberConverter.Declension.FIRST, decimalNames[0]);
            this.decimalNames.put(RussianNumberConverter.Declension.SECOND, decimalNames[1]);
            this.decimalNames.put(RussianNumberConverter.Declension.THIRD, decimalNames[2]);
            this.fractionGender = fractionGender;
            this.fractionNames.put(RussianNumberConverter.Declension.FIRST, fractionNames[0]);
            this.fractionNames.put(RussianNumberConverter.Declension.SECOND, fractionNames[1]);
            this.fractionNames.put(RussianNumberConverter.Declension.THIRD, fractionNames[2]);
            this.decimalShortName = null;
            this.fractionShortName = null;
        }

        public CurrencyData(RussianNumberConverter.Gender decimalGender, String[] decimalNames, String decimalShortName, RussianNumberConverter.Gender fractionGender, String[] fractionNames, String fractionShortName) {
            this.decimalGender = decimalGender;
            this.decimalNames.put(RussianNumberConverter.Declension.FIRST, decimalNames[0]);
            this.decimalNames.put(RussianNumberConverter.Declension.SECOND, decimalNames[1]);
            this.decimalNames.put(RussianNumberConverter.Declension.THIRD, decimalNames[2]);
            this.fractionGender = fractionGender;
            this.fractionNames.put(RussianNumberConverter.Declension.FIRST, fractionNames[0]);
            this.fractionNames.put(RussianNumberConverter.Declension.SECOND, fractionNames[1]);
            this.fractionNames.put(RussianNumberConverter.Declension.THIRD, fractionNames[2]);
            this.decimalShortName = decimalShortName;
            this.fractionShortName = fractionShortName;
        }
    }
}

