/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.l10n.messages;

import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.l10n.model.ResourceBundleControlExt;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class L10n {
    private static final Logger log = LoggerFactory.getLogger(L10n.class);
    private static final String KEY_NOT_FOUND = "key not found ";
    private static final Locale LOCALE_RU = new Locale("ru", "RU");
    private static boolean tryToUseRussian = true;
    private static List<Class<? extends L10n>> bindedClasses = Collections.synchronizedList(new ArrayList());

    public static String get(String key) {
        L10nResourcesManager l10nrm = LocaleManager.get().getL10nResourceManager();
        return l10nrm.findMessage(key, new Object[0]);
    }

    public static String get(String key, Locale locale) {
        L10nResourcesManager l10nrm = LocaleManager.get().getL10nResourceManager();
        return l10nrm.findMessage(locale, key, new Object[0]);
    }

    public static String getWithParams(String key, Locale locale, Object ... parameters) {
        L10nResourcesManager l10nrm = LocaleManager.get().getL10nResourceManager();
        return l10nrm.findMessage(locale, key, parameters);
    }

    public static String getWithParams(String key, Object ... parameters) {
        L10nResourcesManager l10nrm = LocaleManager.get().getL10nResourceManager();
        return l10nrm.findMessage(null, key, parameters);
    }

    public static String replace(String str, Object ... data) {
        if (data == null || data.length == 0 || str == null) {
            return str;
        }
        String result = str;
        for (int i = 0; i < data.length; ++i) {
            result = result.replace('{' + String.valueOf(i) + '}', String.valueOf(data[i]));
        }
        return result;
    }

    public static String get(Object obj, String key, Object ... data) throws MissingResourceException {
        return L10n.get(obj, LocaleManager.get().getCurrentLocale(), key, data);
    }

    public static String get(Object obj, Locale locale, String key, Object ... data) throws MissingResourceException {
        ResourceBundle bundle = L10n.getBundleFor(obj, locale);
        return L10n.getLocalizedStringUnsafe(L10n.getNonNestedClass(obj), locale, bundle, key, data);
    }

    public static String find(Object obj, String key, Object ... data) {
        return L10n.find(obj, LocaleManager.get().getCurrentLocale(), key, data);
    }

    public static String find(Object obj, Locale locale, String key, Object ... data) {
        ResourceBundle bundle;
        try {
            bundle = L10n.getBundleFor(obj, locale);
        }
        catch (MissingResourceException mre) {
            return "bundle not found for " + obj;
        }
        return L10n.getLocalizedStringUnsafe(L10n.getNonNestedClass(obj), locale, bundle, key, data);
    }

    public static void bind(Class<? extends L10n> cls) {
        bindedClasses.add(cls);
        L10n.bindInternal(cls, LocaleManager.get().getCurrentLocale());
    }

    private static void bindInternal(Class<?> cls, Locale locale) {
        log.debug(String.format("binding fields, class=%s, locale=%s", cls.getName(), locale));
        ResourceBundle bundle = L10n.getBundleFor(cls, locale);
        if (!locale.equals(bundle.getLocale())) {
            log.warn(String.format("no resources found for locale %s and class %s, falling back to locale %s", locale, cls.getName(), bundle.getLocale()));
        }
        HashSet<String> processedKeys = new HashSet<String>();
        for (Field field : cls.getDeclaredFields()) {
            if (Modifier.isFinal(field.getModifiers()) || !Modifier.isStatic(field.getModifiers())) continue;
            try {
                field.setAccessible(true);
                field.set(null, L10n.getLocalizedString(cls, locale, bundle, field.getName(), new Object[0]));
            }
            catch (Exception e) {
                log.error("failed binding filed " + field, (Throwable)e);
            }
            processedKeys.add(field.getName());
        }
        log.debug(String.format("processed %s fields for %s", processedKeys.size(), cls));
        Enumeration<String> keys = bundle.getKeys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            if (processedKeys.contains(key)) continue;
            log.warn(String.format("found not used key %s in bundle for class %s", key, cls.getName()));
        }
    }

    private static String getLocalizedString(Class<?> cls, Locale locale, ResourceBundle bundle, String key, Object ... data) {
        try {
            return L10n.getLocalizedStringUnsafe(cls, locale, bundle, key, data);
        }
        catch (MissingResourceException e) {
            log.warn(String.format("resource not found, cls=%s, key=%s, locale=ru_RU", cls.getName(), key));
            return KEY_NOT_FOUND + key;
        }
    }

    private static String getLocalizedStringUnsafe(Class<?> cls, Locale locale, ResourceBundle bundle, String key, Object ... data) throws MissingResourceException {
        return L10n.replace(L10n.getLocalizedStringUnsafe(cls, locale, bundle, key), data);
    }

    private static String getLocalizedStringUnsafe(Class<?> cls, Locale locale, ResourceBundle bundle, String key) throws MissingResourceException {
        if (!tryToUseRussian || bundle.containsKey(key)) {
            return bundle.getString(key);
        }
        log.warn(String.format("resource not found, cls=%s, key=%s, locale=%s", cls.getName(), key, locale));
        ResourceBundle russianBundle = L10n.getBundleFor(cls, LOCALE_RU);
        return russianBundle.getString(key);
    }

    private static ResourceBundle getBundleFor(Object obj, Locale locale) throws MissingResourceException {
        Class<?> cls = L10n.getNonNestedClass(obj);
        try {
            return ResourceBundle.getBundle(cls.getName(), locale, cls.getClassLoader(), new ResourceBundleControlExt("UTF8"));
        }
        catch (MissingResourceException mre) {
            log.warn(String.format("resource bundle not found, bundle=%s, class=%s, locale=%s", cls.getName(), cls.getName(), locale));
            throw mre;
        }
    }

    private static Class<?> getNonNestedClass(Object obj) {
        return L10n.getNonNestedClass(obj instanceof Class ? (Class<?>)obj : obj.getClass());
    }

    private static Class<?> getNonNestedClass(Class<?> cls) {
        Class<?> result = cls.getEnclosingClass();
        if (result != null) {
            log.warn("anonymous or local class passed to localization routine " + cls.getName());
            return L10n.getNonNestedClass(result);
        }
        result = cls.getDeclaringClass();
        if (result != null) {
            log.warn("nested or anonymous class passed to localization routine " + cls.getName());
            return L10n.getNonNestedClass(result);
        }
        return cls;
    }

    public static String getKeyNotFound() {
        return KEY_NOT_FOUND;
    }

    public static void setTryToUseRussian(boolean tryToUseRussian) {
        L10n.tryToUseRussian = tryToUseRussian;
    }
}

