/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.l10n.model;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.l10n.model.L10nMessage;
import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.l10n.model.Resources;
import com.gridnine.xtrip.common.util.IoUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.net.URL;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class L10nResourcesManager {
    private final transient Logger log = LoggerFactory.getLogger(this.getClass());
    private final Map<String, Resources> resources = new HashMap<String, Resources>();

    public static L10nMessage createL10nMessage(String key, Object ... parameters) {
        L10nMessage l10nMessage = new L10nMessage();
        l10nMessage.setKey(key);
        if (Objects.isNull(parameters)) {
            return l10nMessage;
        }
        for (Object param : parameters) {
            l10nMessage.getParameters().add(param != null ? param : "?");
        }
        return l10nMessage;
    }

    public static String getStr(String key, Locale locale, Object ... parameters) {
        if (!Environment.isPublished(LocaleManager.class)) {
            return L10nResourcesManager.replace(key, parameters);
        }
        return LocaleManager.get().getL10nResourceManager().getMessage(locale, key, parameters);
    }

    public static String getStr(String key, Object ... parameters) {
        return L10nResourcesManager.getStr(key, null, parameters);
    }

    public static String replace(String str, Object ... data) {
        if (str == null || data == null || data.length == 0) {
            return str;
        }
        String result = str;
        for (int i = 0; i < data.length; ++i) {
            String value = MiscUtil.toString(data[i]);
            result = result.replace('{' + String.valueOf(i) + '}', value != null ? value : "?");
        }
        return result;
    }

    public void registerResource(URL locationUrl) {
        this.registerResource(locationUrl, null);
    }

    public void registerResource(URL locationUrl, String baseFileName) {
        if (Objects.isNull(locationUrl)) {
            return;
        }
        String urlStr = locationUrl.toString();
        if (this.resources.containsKey(urlStr)) {
            return;
        }
        if (!IoUtil.isResourceExists(locationUrl)) {
            if (this.log.isWarnEnabled()) {
                this.log.warn("resource file not exist: url=" + urlStr);
            }
            return;
        }
        baseFileName = MiscUtil.orElse(baseFileName, "Messages");
        this.resources.put(urlStr, new Resources(locationUrl, baseFileName));
        if (this.log.isInfoEnabled()) {
            this.log.info("registered resources for URL " + urlStr);
        }
    }

    public String findMessage(L10nMessage message, Locale loc) {
        if (Objects.isNull(message)) {
            return null;
        }
        return this.findMessage(loc, message.getKey(), message.getParameters().toArray());
    }

    public String findMessage(Locale loc, String key, Object ... parameters) {
        if (TextUtil.isBlank(key)) {
            return null;
        }
        String result = null;
        for (Resources resource : this.resources.values()) {
            result = loc != null ? resource.findResource(key, loc) : resource.findResource(key);
            if (result == null) continue;
            break;
        }
        if (result == null) {
            this.log.warn(String.format("no localization found: key=%s; locale=%s", key, loc));
            return null;
        }
        return L10nResourcesManager.replace(result, parameters);
    }

    public String findMessage(String key, Object ... parameters) {
        return this.findMessage(null, key, parameters);
    }

    public String findMessage(L10nMessage message) {
        return this.findMessage(message, null);
    }

    public String getMessage(Locale loc, String key, Object ... parameters) {
        String result = this.findMessage(loc, key, parameters);
        if (Objects.nonNull(result)) {
            return result;
        }
        return key == null ? null : L10nResourcesManager.replace(key, parameters);
    }

    public String getMessage(String key, Object ... parameters) {
        String result = this.findMessage(null, key, parameters);
        if (Objects.nonNull(result)) {
            return result;
        }
        return key == null ? null : L10nResourcesManager.replace(key, parameters);
    }

    public String getMessage(L10nMessage message, Locale loc) {
        if (Objects.isNull(message)) {
            return null;
        }
        return this.getMessage(loc, message.getKey(), message.getParameters().toArray());
    }

    public String getMessage(L10nMessage message) {
        return this.getMessage(message, null);
    }
}

