/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.l10n.model;

import com.gridnine.xtrip.common.l10n.model.L10nString;
import com.gridnine.xtrip.common.util.LocaleUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;

public final class L10nStringHelper {
    public static void clearValue(L10nString localizationString, Locale locale) {
        localizationString.getValues().remove(LocaleUtil.createNormalizedLocale(locale));
    }

    public static void copy(L10nString source, L10nString target) {
        target.getValues().clear();
        target.getValues().putAll(source.getValues());
    }

    public static void setValue(L10nString localizationString, String value, Locale locale) {
        localizationString.getValues().put(LocaleUtil.createNormalizedLocale(locale), value);
    }

    public static String getValue(L10nString localizationString, Locale locale, boolean strict) {
        return strict ? L10nStringHelper.getValueStrict(localizationString, locale) : L10nStringHelper.getValueLoose(localizationString, locale);
    }

    private static String getValueStrict(L10nString localizationString, Locale locale) {
        if (localizationString == null || locale == null) {
            return null;
        }
        if (localizationString.getValues().isEmpty()) {
            return null;
        }
        if (localizationString.getValues().containsKey(locale)) {
            return localizationString.getValues().get(locale);
        }
        return localizationString.getValues().entrySet().stream().filter(entry -> entry.getKey() != null && TextUtil.isSame(locale.getLanguage(), ((Locale)entry.getKey()).getLanguage())).map(Map.Entry::getValue).filter(Objects::nonNull).findFirst().orElse(null);
    }

    private static String getValueLoose(L10nString localizationString, Locale locale) {
        if (localizationString == null) {
            return null;
        }
        if (localizationString.getValues().isEmpty()) {
            return null;
        }
        String value = localizationString.getValues().get(locale);
        if (TextUtil.isBlank(value)) {
            value = localizationString.getValues().entrySet().stream().filter(entry -> entry.getKey() != null && locale != null && TextUtil.isSame(locale.getLanguage(), ((Locale)entry.getKey()).getLanguage())).map(Map.Entry::getValue).filter(Objects::nonNull).findFirst().orElse(null);
        }
        if (TextUtil.isBlank(value)) {
            value = localizationString.getValues().get(Locale.ROOT);
        }
        if (TextUtil.isBlank(value)) {
            for (String val : localizationString.getValues().values()) {
                if (TextUtil.isBlank(val)) continue;
                value = val;
                break;
            }
        }
        return value;
    }

    public static String getEnglishValue(L10nString str) {
        if (str == null) {
            return null;
        }
        return L10nStringHelper.getValueLoose(str, LocaleUtil.LOCALE_EN);
    }

    public static String getValue(L10nString localizationString) {
        if (localizationString == null) {
            return "";
        }
        String res = localizationString.toString();
        return TextUtil.isBlank(res) ? "" : res;
    }

    public static String getValue(L10nString localizationString, Locale locale) {
        if (localizationString == null) {
            return "";
        }
        String res = localizationString.toString(locale);
        return TextUtil.isBlank(res) ? "" : res;
    }
}

