/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.l10n.model;

import com.gridnine.xtrip.common.l10n.model.LocaleData;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.Locale;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class LocaleDataTest {
    @Test
    public void whenGetPriceFormatThenReturnPriceWithRoundHalfUp() {
        LocaleData localeData = new LocaleData();
        Locale value = new Locale("RU");
        localeData.setLocale(value);
        localeData.setPriceFormatPattern("#,##0.00");
        DecimalFormat fmt = localeData.getPriceFormat();
        BigDecimal value1 = BigDecimal.valueOf(3677.79);
        Assert.assertThat((Object)fmt.format(value1), (Matcher)CoreMatchers.is((Object)"3 677,79"));
        BigDecimal value2 = BigDecimal.valueOf(14098.195);
        Assert.assertThat((Object)fmt.format(value2), (Matcher)CoreMatchers.is((Object)"14 098,20"));
        BigDecimal value3 = MiscUtil.sum(value1, value2);
        Assert.assertThat((Object)fmt.format(value3), (Matcher)CoreMatchers.is((Object)"17 775,99"));
    }
}

