/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.l10n.model;

import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;

public final class LocaleHelper {
    private static final Map<String, Locale> cache = new HashMap<String, Locale>();
    public static final Locale RU_LOCALE = LocaleHelper.getLocale("RU");
    public static final Locale EN_LOCALE = LocaleHelper.getLocale("EN");
    public static final Locale DE_LOCALE = LocaleHelper.getLocale("DE");

    public static Locale getCurrentLocale() {
        return LocaleManager.get().getCurrentLocale();
    }

    public static Locale getLocale(String language) {
        return LocaleHelper.getLocale(language, null, null);
    }

    public static Locale getLocale(String language, String country) {
        return LocaleHelper.getLocale(language, country, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Locale getLocale(String language, String country, String variant) {
        String l = language != null ? language : "";
        String c = country != null ? country : "";
        String v = variant != null ? variant : "";
        String key = l + "_" + c + "_" + v;
        Locale locale = cache.get(key);
        if (locale == null) {
            Map<String, Locale> map = cache;
            synchronized (map) {
                locale = cache.get(key);
                if (locale == null) {
                    locale = new Locale(l, c, v);
                    cache.put(key, locale);
                }
            }
        }
        return locale;
    }

    public static Locale parse(String value) {
        String[] entries = value.split("_");
        return LocaleHelper.getLocale(entries.length > 0 ? entries[0] : null, entries.length > 1 ? entries[1] : null, entries.length > 2 ? entries[2] : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(Object object, Locale locale) {
        LocaleManager localeManager = LocaleManager.get();
        if (!localeManager.isSupportedLocale(locale)) {
            return object.toString();
        }
        Locale originalLocale = localeManager.getCurrentLocale();
        try {
            localeManager.setCurrentLocale(locale);
            String string = object.toString();
            return string;
        }
        finally {
            localeManager.setCurrentLocale(originalLocale);
        }
    }

    public static String getDisplayName(Locale locale) {
        return Objects.isNull(locale) ? null : locale.getDisplayName(LocaleManager.get().getCurrentLocale());
    }
}

