/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.l10n.model;

import com.gridnine.xtrip.common.l10n.model.Number2WordsConverter;
import com.gridnine.xtrip.common.util.LocaleUtil;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Number2WordsConverterRegistry {
    private final transient Logger log = LoggerFactory.getLogger(this.getClass());
    private final ReentrantLock lock = new ReentrantLock(true);
    private static final Map<Locale, Map<String, Number2WordsConverter>> converters = new HashMap<Locale, Map<String, Number2WordsConverter>>();

    public boolean isSupportedLocale(Locale locale) {
        this.lock.lock();
        try {
            boolean bl = converters.containsKey(LocaleUtil.createNormalizedLocale(locale));
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSupportedCurrency(Locale locale, String currency) {
        this.lock.lock();
        try {
            boolean bl = converters.containsKey(locale) && converters.get(locale).containsKey(currency);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerConverter(Number2WordsConverter converter) {
        this.lock.lock();
        try {
            Locale locale = LocaleUtil.createNormalizedLocale(converter.getLocale());
            Map<String, Number2WordsConverter> map = converters.get(locale);
            if (map == null) {
                map = new HashMap<String, Number2WordsConverter>();
                converters.put(locale, map);
            }
            for (String currency : converter.getCurrencies()) {
                if (map.containsKey(currency)) {
                    this.log.warn(String.format("converter %s for locale %s and currency %s already registered", converter, locale, currency));
                    continue;
                }
                map.put(currency, converter);
                this.log.info(String.format("registered converter %s for locale %s and currency %s", converter, locale, currency));
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Number2WordsConverter findConverter(Locale locale, String currency) {
        this.lock.lock();
        try {
            Number2WordsConverter number2WordsConverter = converters.containsKey(LocaleUtil.createNormalizedLocale(locale)) ? converters.get(LocaleUtil.createNormalizedLocale(locale)).get(currency) : null;
            return number2WordsConverter;
        }
        finally {
            this.lock.unlock();
        }
    }
}

