/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.l10n.model;

import com.gridnine.xtrip.common.l10n.model.L10nStringHelper;
import com.gridnine.xtrip.common.l10n.model.PersonalLocalizableName;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.Locale;

public final class PersonalLocalizableNameUtil {
    public static String buildFullName(PersonalLocalizableName personalName, Locale locale, boolean strict) {
        return PersonalLocalizableNameUtil.buildFullName(personalName, false, locale, strict);
    }

    public static String buildFullName(PersonalLocalizableName personalName, boolean useInitials, Locale locale, boolean strict) {
        if (personalName == null) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        String lastName = L10nStringHelper.getValue(personalName.getLastName(), locale, strict);
        String firstName = L10nStringHelper.getValue(personalName.getFirstName(), locale, strict);
        String secondName = L10nStringHelper.getValue(personalName.getSecondName(), locale, strict);
        String middleName = L10nStringHelper.getValue(personalName.getMiddleName(), locale, strict);
        if (!TextUtil.isBlank(lastName)) {
            result.append(lastName.trim());
        }
        if (!TextUtil.isBlank(firstName)) {
            if (result.length() > 0) {
                result.append(' ');
            }
            result.append(useInitials ? firstName.trim().charAt(0) + "." : firstName.trim());
        }
        if (!TextUtil.isBlank(secondName)) {
            if (result.length() > 0) {
                result.append(' ');
            }
            result.append(useInitials ? secondName.trim().charAt(0) + "." : secondName.trim());
        }
        if (!TextUtil.isBlank(middleName)) {
            if (result.length() > 0) {
                result.append(' ');
            }
            result.append(useInitials ? middleName.trim().charAt(0) + "." : middleName.trim());
        }
        return result.toString();
    }

    public static void splitFullName(String fullName, PersonalLocalizableName personalName, Locale locale) {
        L10nStringHelper.setValue(personalName.getLastName(), "", locale);
        L10nStringHelper.setValue(personalName.getFirstName(), "", locale);
        L10nStringHelper.setValue(personalName.getMiddleName(), "", locale);
        L10nStringHelper.setValue(personalName.getSecondName(), "", locale);
        if (TextUtil.isBlank(fullName)) {
            return;
        }
        String[] arr = fullName.split("\\s+");
        if (arr.length == 0) {
            L10nStringHelper.setValue(personalName.getLastName(), fullName.trim(), locale);
        } else if (arr.length == 1) {
            L10nStringHelper.setValue(personalName.getLastName(), arr[0].trim(), locale);
        } else if (arr.length == 2) {
            L10nStringHelper.setValue(personalName.getLastName(), arr[0].trim(), locale);
            L10nStringHelper.setValue(personalName.getFirstName(), arr[1].trim(), locale);
        } else if (arr.length == 3) {
            L10nStringHelper.setValue(personalName.getLastName(), arr[0].trim(), locale);
            L10nStringHelper.setValue(personalName.getFirstName(), arr[1].trim(), locale);
            L10nStringHelper.setValue(personalName.getMiddleName(), arr[2].trim(), locale);
        } else if (arr.length == 4) {
            L10nStringHelper.setValue(personalName.getLastName(), arr[0].trim(), locale);
            L10nStringHelper.setValue(personalName.getFirstName(), arr[1].trim(), locale);
            L10nStringHelper.setValue(personalName.getSecondName(), arr[2].trim(), locale);
            L10nStringHelper.setValue(personalName.getMiddleName(), arr[3].trim(), locale);
        } else {
            StringBuilder middleName = new StringBuilder();
            for (int i = 2; i < arr.length; ++i) {
                if (middleName.length() > 0) {
                    middleName.append(" ");
                }
                middleName.append(arr[i].trim());
            }
            L10nStringHelper.setValue(personalName.getLastName(), arr[0].trim(), locale);
            L10nStringHelper.setValue(personalName.getFirstName(), arr[1].trim(), locale);
            L10nStringHelper.setValue(personalName.getMiddleName(), middleName.toString(), locale);
        }
    }
}

