/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.meta;

import com.gridnine.xtrip.common.l10n.model.Resources;
import com.gridnine.xtrip.common.meta.BaseMetaElement;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.XHelper;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.w3c.dom.Element;

public class BaseProperty
extends BaseMetaElement {
    private String type;
    private String generics;
    private String format;
    private boolean finalProperty;
    private final Map<String, String> parameters = new LinkedHashMap<String, String>();
    private boolean localizable;
    private final String owner;

    BaseProperty(String ownerId) {
        this.owner = ownerId;
    }

    public String getType() {
        return this.type;
    }

    public String getFormat() {
        return this.format;
    }

    public boolean isFinalProperty() {
        return this.finalProperty;
    }

    public Map<String, String> getParameters() {
        return Collections.unmodifiableMap(this.parameters);
    }

    @Override
    protected String getResourceKey() {
        return this.owner + '.' + this.getId();
    }

    public boolean isLocalizable() {
        return this.localizable;
    }

    public String getGenerics() {
        return this.generics;
    }

    public String getFormatDescription() {
        for (Resources res : this.resources) {
            String descr = res.getResource(this.getResourceKey() + ".formatDescription");
            if (descr == null) continue;
            return descr;
        }
        return null;
    }

    @Override
    protected void fromXml(Element elm, Resources res) {
        super.fromXml(elm, res);
        this.finalProperty = this.finalProperty || XHelper.readBoolean(elm, "@final", false);
        boolean bl = this.localizable = this.localizable || XHelper.readBoolean(elm, "@localizable", false);
        if (TextUtil.isBlank(this.type)) {
            this.type = XHelper.readString(elm, "@type");
            int genericsStart = this.type.indexOf(60);
            int n = this.type.lastIndexOf(62);
            if (genericsStart >= 0 && n == this.type.length() - 1) {
                this.generics = this.type.substring(genericsStart + 1, n);
                this.type = this.type.substring(0, genericsStart);
            }
        }
        if (TextUtil.isBlank(this.format)) {
            this.format = XHelper.readString(elm, "@format");
        }
        for (Element paramElm : XmlUtil.getElements(elm, "param")) {
            this.parameters.put(XHelper.readString(paramElm, "@name"), XHelper.readString(paramElm, "@value"));
        }
        for (Map.Entry entry : XmlUtil.getAttributes(elm).entrySet()) {
            if (!((String)entry.getKey()).contains("_")) continue;
            this.parameters.put((String)entry.getKey(), (String)entry.getValue());
        }
        for (Element child : XmlUtil.getChildren(elm)) {
            if (!child.getNodeName().contains("_")) continue;
            this.parameters.put(child.getNodeName(), XmlUtil.getValue(child));
        }
    }
}

