/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.meta;

import com.gridnine.xtrip.common.l10n.model.Resources;
import com.gridnine.xtrip.common.meta.BaseClassType;
import com.gridnine.xtrip.common.meta.DictionaryCollection;
import com.gridnine.xtrip.common.meta.DictionaryProperty;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.XHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Element;

public class DictionaryType
extends BaseClassType {
    private String providerId;
    private boolean internal;
    private boolean remote;
    private boolean reset;
    private int remotePriority;
    private final Set<String> disabledInModules = new HashSet<String>();
    private final Set<String> interfaces = new LinkedHashSet<String>();
    private final Map<String, DictionaryProperty> properties = new LinkedHashMap<String, DictionaryProperty>();
    private final Map<String, DictionaryCollection> collections = new LinkedHashMap<String, DictionaryCollection>();

    DictionaryType() {
    }

    public List<String> getInterfaces() {
        return Collections.unmodifiableList(new ArrayList<String>(this.interfaces));
    }

    public Map<String, DictionaryProperty> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    public Map<String, DictionaryCollection> getCollections() {
        return Collections.unmodifiableMap(this.collections);
    }

    public String getProviderId() {
        return this.providerId;
    }

    public boolean isInternal() {
        return this.internal;
    }

    public boolean isRemote() {
        return this.remote;
    }

    public boolean isReset() {
        return this.reset;
    }

    public int getRemotePriority() {
        return this.remotePriority;
    }

    public Set<String> getDisabledInModules() {
        return this.disabledInModules;
    }

    @Override
    protected void fromXml(Element elm, Resources res) {
        super.fromXml(elm, res);
        this.providerId = XHelper.readString(elm, "@provider-id");
        this.internal = XHelper.readBoolean(elm, "@internal", false);
        this.remote = XHelper.readBoolean(elm, "@remote", false);
        this.reset = XHelper.readBoolean(elm, "@reset", false);
        this.remotePriority = XHelper.readInt(elm, "@remote_priority", 0);
        String unusedModulesStr = XHelper.readString(elm, "@disabledInModules");
        if (!TextUtil.isBlank(unusedModulesStr)) {
            for (String module : unusedModulesStr.split(",")) {
                if (TextUtil.isBlank(module)) continue;
                this.disabledInModules.add(module.trim());
            }
        }
        for (Element itfElm : XmlUtil.getElements(elm, "interface")) {
            this.interfaces.add(XmlUtil.getValue(itfElm, "@id"));
        }
        for (Element propElm : XmlUtil.getElements(elm, "dict-property")) {
            String propId = XHelper.readString(propElm, "@id");
            DictionaryProperty prop = this.properties.get(propId);
            if (prop == null) {
                prop = new DictionaryProperty(this.getId());
                this.properties.put(propId, prop);
            }
            prop.fromXml(propElm, res);
        }
        for (Element collElm : XmlUtil.getElements(elm, "collection")) {
            String collId = XHelper.readString(collElm, "@id");
            DictionaryCollection coll = this.collections.get(collId);
            if (coll == null) {
                coll = new DictionaryCollection(this.getId());
                this.collections.put(collId, coll);
            }
            coll.fromXml(collElm, res);
        }
    }
}

