/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.meta;

import com.gridnine.xtrip.common.l10n.model.Resources;
import com.gridnine.xtrip.common.meta.BaseType;
import com.gridnine.xtrip.common.meta.EnumItem;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.XHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Element;

public class EnumType
extends BaseType {
    private final Set<String> interfaces = new LinkedHashSet<String>();
    private final Map<String, EnumItem> items = new LinkedHashMap<String, EnumItem>();
    private final Set<String> enumItemRenamers = new HashSet<String>();
    private boolean system;
    private boolean hidden;

    EnumType() {
    }

    public Map<String, EnumItem> getItems() {
        return Collections.unmodifiableMap(this.items);
    }

    public List<String> getInterfaces() {
        return Collections.unmodifiableList(new ArrayList<String>(this.interfaces));
    }

    @Override
    protected void fromXml(Element elm, Resources res) {
        super.fromXml(elm, res);
        for (Element itfElm : XmlUtil.getElements(elm, "interface")) {
            this.interfaces.add(XmlUtil.getValue(itfElm, "@id"));
        }
        this.system = this.system || XHelper.readBoolean(elm, "@system", false);
        this.hidden = this.hidden || XHelper.readBoolean(elm, "@hidden", false);
        for (Element itemElm : XmlUtil.getElements(elm, "enum-item")) {
            String itemId = XHelper.readString(itemElm, "@id");
            EnumItem prop = this.items.get(itemId);
            if (prop == null) {
                prop = new EnumItem(this.getId());
                this.items.put(itemId, prop);
            }
            prop.fromXml(itemElm, res);
        }
        for (Element collElm : XmlUtil.getElements(elm, "enum-item-renamer")) {
            this.enumItemRenamers.add(XHelper.readString(collElm, "@className"));
        }
    }

    public Set<String> getEnumItemRenamers() {
        return this.enumItemRenamers;
    }

    public boolean isSystem() {
        return this.system;
    }

    public boolean isHidden() {
        return this.hidden;
    }
}

