/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.meta;

import com.gridnine.xtrip.common.l10n.model.Resources;
import com.gridnine.xtrip.common.meta.BaseType;
import com.gridnine.xtrip.common.meta.IndexCollection;
import com.gridnine.xtrip.common.meta.IndexProperty;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.XHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Element;

public class IndexType
extends BaseType {
    private String entityId;
    private final Set<String> interfaces = new LinkedHashSet<String>();
    private final Map<String, IndexProperty> properties = new LinkedHashMap<String, IndexProperty>();
    private final Map<String, IndexCollection> collections = new LinkedHashMap<String, IndexCollection>();
    private boolean hidden;
    private String scope;

    public String getEntityId() {
        return this.entityId;
    }

    public List<String> getInterfaces() {
        return Collections.unmodifiableList(new ArrayList<String>(this.interfaces));
    }

    public Map<String, IndexProperty> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    public Map<String, IndexCollection> getCollections() {
        return Collections.unmodifiableMap(this.collections);
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public String getScope() {
        return this.scope;
    }

    @Override
    protected void fromXml(Element elm, Resources res) {
        super.fromXml(elm, res);
        if (this.entityId == null) {
            this.entityId = XHelper.readString(elm, "@entity");
        }
        this.hidden = this.hidden || XHelper.readBoolean(elm, "@hidden", false);
        for (Element itfElm : XmlUtil.getElements(elm, "interface")) {
            this.interfaces.add(XmlUtil.getValue(itfElm, "@id"));
        }
        for (Element propElm : XmlUtil.getElements(elm, "index-property")) {
            String propId = XHelper.readString(propElm, "@id");
            IndexProperty prop = this.properties.get(propId);
            if (prop == null) {
                prop = new IndexProperty(this.getId());
                this.properties.put(propId, prop);
            }
            prop.fromXml(propElm, res);
        }
        for (Element collElm : XmlUtil.getElements(elm, "index-collection")) {
            String collId = XHelper.readString(collElm, "@id");
            IndexCollection coll = this.collections.get(collId);
            if (coll == null) {
                coll = new IndexCollection(this.getId());
                this.collections.put(collId, coll);
            }
            coll.fromXml(collElm, res);
        }
        if (this.scope == null) {
            this.scope = XHelper.readString(elm, "@scope");
        }
    }
}

