/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.meta;

import com.gridnine.xtrip.common.Disposable;
import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.l10n.model.Resources;
import com.gridnine.xtrip.common.meta.BaseType;
import com.gridnine.xtrip.common.meta.DictionaryType;
import com.gridnine.xtrip.common.meta.EntityRef;
import com.gridnine.xtrip.common.meta.EntityRenamer;
import com.gridnine.xtrip.common.meta.EntityType;
import com.gridnine.xtrip.common.meta.EnumItemRenamer;
import com.gridnine.xtrip.common.meta.EnumRef;
import com.gridnine.xtrip.common.meta.EnumType;
import com.gridnine.xtrip.common.meta.IndexType;
import com.gridnine.xtrip.common.meta.InterfaceType;
import com.gridnine.xtrip.common.meta.PropertiesRenamer;
import com.gridnine.xtrip.common.meta.ValidationMessagesType;
import com.gridnine.xtrip.common.util.ObjectFactory;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.XHelper;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class MetaRegistry
implements Disposable {
    private static final Schema SCHEMA;
    private final transient Logger log = LoggerFactory.getLogger(this.getClass());
    private final Map<String, InterfaceType> interfaces = new LinkedHashMap<String, InterfaceType>();
    private final Map<String, EntityType> entities = new LinkedHashMap<String, EntityType>();
    private final Map<String, EntityRef> entityRefs = new LinkedHashMap<String, EntityRef>();
    private final Map<String, EnumRef> enumRefs = new LinkedHashMap<String, EnumRef>();
    private final Map<String, DictionaryType> dictionaries = new LinkedHashMap<String, DictionaryType>();
    private final Map<String, EnumType> enums = new LinkedHashMap<String, EnumType>();
    private final Map<String, ValidationMessagesType> validationMessages = new LinkedHashMap<String, ValidationMessagesType>();
    private final Map<String, IndexType> indexes = new LinkedHashMap<String, IndexType>();
    private final Map<String, PropertiesRenamer> propertiesRenamers = new HashMap<String, PropertiesRenamer>();
    private final Map<String, EntityRenamer> entityRenamers = new HashMap<String, EntityRenamer>();
    private final Map<String, EnumItemRenamer> enumItemRenamers = new HashMap<String, EnumItemRenamer>();

    public static MetaRegistry get() {
        if (!Environment.isTest()) {
            return Holder.INSTANCE;
        }
        return Environment.getPublished(MetaRegistry.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(final URL meta) throws Exception {
        this.log.debug("registering meta data from " + meta);
        try (InputStream strm = meta.openStream();){
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            if (SCHEMA != null) {
                factory.setSchema(SCHEMA);
            }
            DocumentBuilder docBuilder = factory.newDocumentBuilder();
            docBuilder.setErrorHandler(new ErrorHandler(){

                @Override
                public void error(SAXParseException ex) throws SAXException {
                    System.out.println(meta);
                    throw ex;
                }

                @Override
                public void fatalError(SAXParseException ex) throws SAXException {
                    System.out.println(meta);
                    throw ex;
                }

                @Override
                public void warning(SAXParseException ex) throws SAXException {
                }
            });
            Resources resources = new Resources(meta);
            Element root = docBuilder.parse(strm).getDocumentElement();
            MetaRegistry.appendElements(this.enums, XmlUtil.getElements(root, "enum"), new ObjectFactory<EnumType>(){

                @Override
                public EnumType createObject() {
                    return new EnumType();
                }
            }, meta, resources);
            MetaRegistry.appendElements(this.validationMessages, XmlUtil.getElements(root, "validation-messages"), new ObjectFactory<ValidationMessagesType>(){

                @Override
                public ValidationMessagesType createObject() {
                    return new ValidationMessagesType();
                }
            }, meta, resources);
            MetaRegistry.appendElements(this.entities, XmlUtil.getElements(root, "entity"), new ObjectFactory<EntityType>(){

                @Override
                public EntityType createObject() {
                    return new EntityType();
                }
            }, meta, resources);
            MetaRegistry.appendElements(this.interfaces, XmlUtil.getElements(root, "interface"), new ObjectFactory<InterfaceType>(){

                @Override
                public InterfaceType createObject() {
                    return new InterfaceType();
                }
            }, meta, resources);
            MetaRegistry.appendElements(this.dictionaries, XmlUtil.getElements(root, "dict"), new ObjectFactory<DictionaryType>(){

                @Override
                public DictionaryType createObject() {
                    return new DictionaryType();
                }
            }, meta, resources);
            MetaRegistry.appendElements(this.indexes, XmlUtil.getElements(root, "index"), new ObjectFactory<IndexType>(){

                @Override
                public IndexType createObject() {
                    return new IndexType();
                }
            }, meta, resources);
            for (Element elm : XmlUtil.getElements(root, "entity-ref")) {
                String id = XHelper.readString(elm, "@id");
                EntityRef item = this.entityRefs.get(id);
                if (item == null) {
                    item = new EntityRef();
                    this.entityRefs.put(id, item);
                }
                item.fromXml(elm, resources);
            }
            for (Element elm : XmlUtil.getElements(root, "enum-ref")) {
                EnumRef etr = new EnumRef();
                etr.fromXml(elm, resources);
                this.enumRefs.put(etr.getId(), etr);
            }
        }
        if (!"true".equals(System.getProperty("metaregistry.skip-renamers-registration"))) {
            this.updateRenamers();
        }
        this.log.info("meta data registered from " + meta);
    }

    private void updateRenamers() throws Exception {
        for (EntityType entityType : this.entities.values()) {
            this.updateRenamers(entityType);
        }
        for (EnumRef enumRef : this.enumRefs.values()) {
            this.updateRenamers(enumRef);
        }
        for (DictionaryType dictionaryType : this.dictionaries.values()) {
            this.updateRenamers(dictionaryType);
        }
        for (EnumType enumType : this.enums.values()) {
            this.updateRenamers(enumType);
        }
        for (EntityRef entityRef : this.entityRefs.values()) {
            this.updateRenamers(entityRef);
        }
    }

    private void updateRenamers(EnumType et) throws Exception {
        for (String renamer : et.getEnumItemRenamers()) {
            if (this.enumItemRenamers.containsKey(renamer)) continue;
            this.enumItemRenamers.put(renamer, (EnumItemRenamer)Class.forName(renamer).newInstance());
        }
    }

    private void updateRenamers(DictionaryType dt) throws Exception {
        for (String renamer : dt.getPropertiesRenamers()) {
            if (this.propertiesRenamers.containsKey(renamer)) continue;
            this.propertiesRenamers.put(renamer, (PropertiesRenamer)Class.forName(renamer).newInstance());
        }
    }

    private void updateRenamers(EnumRef er) throws Exception {
        for (String renamer : er.getEnumItemRenamers()) {
            if (this.enumItemRenamers.containsKey(renamer)) continue;
            this.enumItemRenamers.put(renamer, (EnumItemRenamer)Class.forName(renamer).newInstance());
        }
    }

    private void updateRenamers(EntityRef et) throws Exception {
        for (String renamer : et.getEntityRenamers()) {
            if (this.entityRenamers.containsKey(renamer)) continue;
            this.entityRenamers.put(renamer, (EntityRenamer)Class.forName(renamer).newInstance());
        }
    }

    private void updateRenamers(EntityType et) throws Exception {
        for (String renamer : et.getPropertiesRenamers()) {
            if (this.propertiesRenamers.containsKey(renamer)) continue;
            this.propertiesRenamers.put(renamer, (PropertiesRenamer)Class.forName(renamer).newInstance());
        }
        for (String renamer : et.getEntityRenamers()) {
            if (this.entityRenamers.containsKey(renamer)) continue;
            this.entityRenamers.put(renamer, (EntityRenamer)Class.forName(renamer).newInstance());
        }
    }

    private static <T extends BaseType> void appendElements(Map<String, T> map, Element[] elements, ObjectFactory<T> factory, URL meta, Resources resources) {
        for (Element elm : elements) {
            String id = XHelper.readString(elm, "@id");
            BaseType item = (BaseType)map.get(id);
            if (item == null) {
                item = (BaseType)factory.createObject();
                map.put(id, item);
            }
            item.fromXml(elm, resources);
            item.addSource(meta);
        }
    }

    public synchronized PropertiesRenamer findPropertiesRenamer(String className) {
        return this.propertiesRenamers.get(className);
    }

    public synchronized EntityRenamer findEntityRenamer(String className) {
        return this.entityRenamers.get(className);
    }

    public synchronized EnumItemRenamer findEnumItemRenamer(String className) {
        return this.enumItemRenamers.get(className);
    }

    public Map<String, EnumType> getEnums() {
        return Collections.unmodifiableMap(this.enums);
    }

    public Map<String, ValidationMessagesType> getValidationMessages() {
        return Collections.unmodifiableMap(this.validationMessages);
    }

    public Map<String, InterfaceType> getInterfaces() {
        return Collections.unmodifiableMap(this.interfaces);
    }

    public Map<String, EntityType> getEntities() {
        return Collections.unmodifiableMap(this.entities);
    }

    public EntityType getEntityType(String id) {
        return this.entities.get(id);
    }

    public boolean containsEntityType(String id) {
        return this.entities.containsKey(id);
    }

    public Map<String, EntityRef> getEntityRefs() {
        return Collections.unmodifiableMap(this.entityRefs);
    }

    public Map<String, EnumRef> getEnumRefs() {
        return Collections.unmodifiableMap(this.enumRefs);
    }

    public Map<String, DictionaryType> getDictionaries() {
        return Collections.unmodifiableMap(this.dictionaries);
    }

    public Map<String, IndexType> getIndexes() {
        return Collections.unmodifiableMap(this.indexes);
    }

    @Override
    public void dispose() {
        this.interfaces.clear();
        this.entities.clear();
        this.entityRefs.clear();
        this.enumRefs.clear();
        this.dictionaries.clear();
        this.enums.clear();
        this.validationMessages.clear();
        this.indexes.clear();
        this.propertiesRenamers.clear();
        this.entityRenamers.clear();
        this.enumItemRenamers.clear();
        this.log.debug("disposed");
    }

    static {
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = null;
        try {
            schema = schemaFactory.newSchema(MetaRegistry.class.getResource("meta_1_0.xsd"));
        }
        catch (SAXException e) {
            LoggerFactory.getLogger(MetaRegistry.class).error("failed loading XML schema", (Throwable)e);
        }
        SCHEMA = schema;
    }

    private static class Holder {
        public static final MetaRegistry INSTANCE = Environment.getPublished(MetaRegistry.class);

        private Holder() {
        }
    }
}

