/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.meta;

import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.meta.BaseClassType;
import com.gridnine.xtrip.common.meta.DictionaryProperty;
import com.gridnine.xtrip.common.meta.DictionaryType;
import com.gridnine.xtrip.common.meta.EntityCollection;
import com.gridnine.xtrip.common.meta.EntityType;
import com.gridnine.xtrip.common.meta.EnumItem;
import com.gridnine.xtrip.common.meta.EnumType;
import com.gridnine.xtrip.common.meta.IndexCollection;
import com.gridnine.xtrip.common.meta.IndexProperty;
import com.gridnine.xtrip.common.meta.IndexType;
import com.gridnine.xtrip.common.meta.MetaRegistry;
import com.gridnine.xtrip.common.meta.Property;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.RandomAccessMapWrapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;

public final class MetaRegistryHelper {
    private static Map<EntityType, RandomAccessMapWrapper<String, Property>> allProperties = new HashMap<EntityType, RandomAccessMapWrapper<String, Property>>();
    private static Map<DictionaryType, Map<String, DictionaryProperty>> allDictProperties = new HashMap<DictionaryType, Map<String, DictionaryProperty>>();
    private static Map<BaseClassType, RandomAccessMapWrapper<String, EntityCollection>> allCollections = new HashMap<BaseClassType, RandomAccessMapWrapper<String, EntityCollection>>();

    public static boolean isRoot(EntityType type) {
        if (type.isRoot()) {
            return true;
        }
        if (type.getExtendsId() == null) {
            return false;
        }
        EntityType parent = MetaRegistryHelper.getEntityType(type.getExtendsId());
        if (parent == null) {
            return false;
        }
        return MetaRegistryHelper.isRoot(parent);
    }

    public static boolean isCachedReference(EntityType et) {
        if (et == null) {
            return false;
        }
        if (et.isCachedReference()) {
            return true;
        }
        if (et.getExtendsId() == null) {
            return false;
        }
        return MetaRegistryHelper.isCachedReference(MetaRegistryHelper.getEntityType(et.getExtendsId()));
    }

    public static boolean isCachedEntity(EntityType et) {
        if (et == null) {
            return false;
        }
        if (et.isCached()) {
            return true;
        }
        if (et.getExtendsId() == null) {
            return false;
        }
        return MetaRegistryHelper.isCachedEntity(MetaRegistryHelper.getEntityType(et.getExtendsId()));
    }

    public static boolean isEntityReference(String indexClassName, String propertyName) {
        if (indexClassName == null) {
            return false;
        }
        MetaRegistry metaRegistry = MetaRegistry.get();
        IndexType idxType = metaRegistry.getIndexes().get(indexClassName);
        if (idxType == null) {
            return false;
        }
        IndexProperty idxProp = idxType.getProperties().get(propertyName);
        return idxProp != null && (metaRegistry.getEntities().containsKey(idxProp.getType()) || metaRegistry.getEntityRefs().containsKey(idxProp.getType()));
    }

    public static DictionaryType getDictionaryType(String id) {
        return MetaRegistry.get().getDictionaries().get(id);
    }

    public static EntityType getEntityType(String id) {
        return MetaRegistry.get().getEntities().get(id);
    }

    public static EntityType getEntityTypeForIndex(String indexId) {
        MetaRegistry mr = MetaRegistry.get();
        IndexType indexType = mr.getIndexes().get(indexId);
        return indexType == null ? null : mr.getEntities().get(indexType.getEntityId());
    }

    public static EnumType getEnumType(String id) {
        return MetaRegistry.get().getEnums().get(id);
    }

    public static boolean isAssignableFrom(EntityType parent, EntityType child) {
        return MetaRegistryHelper.isAssignableFrom(parent.getId(), child);
    }

    public static boolean isAssignableFrom(String parentId, EntityType child) {
        if (BaseEntity.class.getName().equals(parentId) || MiscUtil.equals(child.getId(), parentId)) {
            return true;
        }
        EntityType ett = child;
        String id = null;
        while ((id = ett.getExtendsId()) != null) {
            ett = MetaRegistryHelper.getEntityType(id);
            if (ett == null) {
                return parentId.equals(id);
            }
            if (!MiscUtil.equals(ett.getId(), parentId)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasIndexes(EntityType ett) {
        for (IndexType it : MetaRegistry.get().getIndexes().values()) {
            if (!MetaRegistryHelper.isAssignableFrom(it.getEntityId(), ett)) continue;
            return true;
        }
        return false;
    }

    public static Collection<IndexType> getIndexes(EntityType ett) {
        if (ett == null) {
            return Collections.emptyList();
        }
        ArrayList<IndexType> result = new ArrayList<IndexType>();
        for (IndexType it : MetaRegistry.get().getIndexes().values()) {
            if (!MetaRegistryHelper.isAssignableFrom(it.getEntityId(), ett)) continue;
            result.add(it);
        }
        return result;
    }

    public static Collection<EntityType> getRootEntities() {
        HashSet<EntityType> result = new HashSet<EntityType>();
        for (EntityType ett : MetaRegistry.get().getEntities().values()) {
            if (!MetaRegistryHelper.isRoot(ett)) continue;
            result.add(ett);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RandomAccessMapWrapper<String, Property> getAllProperties(EntityType type) {
        RandomAccessMapWrapper<String, Property> result = allProperties.get(type);
        if (result != null) {
            return result;
        }
        Map<EntityType, RandomAccessMapWrapper<String, Property>> map = allProperties;
        synchronized (map) {
            result = allProperties.get(type);
            if (result != null) {
                return result;
            }
            LinkedHashMap<String, Property> lhm = new LinkedHashMap<String, Property>();
            MetaRegistryHelper.collectProperties(lhm, type);
            result = new RandomAccessMapWrapper<String, Property>(lhm);
            allProperties.put(type, result);
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, DictionaryProperty> getAllProperties(DictionaryType type) {
        Map<String, DictionaryProperty> result = allDictProperties.get(type);
        if (result != null) {
            return result;
        }
        Map<DictionaryType, Map<String, DictionaryProperty>> map = allDictProperties;
        synchronized (map) {
            result = allDictProperties.get(type);
            if (result != null) {
                return result;
            }
            result = new LinkedHashMap<String, DictionaryProperty>();
            MetaRegistryHelper.collectProperties(result, type);
            allDictProperties.put(type, result);
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RandomAccessMapWrapper<String, EntityCollection> getAllCollections(BaseClassType type) {
        RandomAccessMapWrapper<String, EntityCollection> result = allCollections.get(type);
        if (result != null) {
            return result;
        }
        Map<BaseClassType, RandomAccessMapWrapper<String, EntityCollection>> map = allCollections;
        synchronized (map) {
            result = allCollections.get(type);
            if (result != null) {
                return result;
            }
            LinkedHashMap<String, EntityCollection> lhm = new LinkedHashMap<String, EntityCollection>();
            MetaRegistryHelper.collectCollections(lhm, type);
            result = new RandomAccessMapWrapper<String, EntityCollection>(lhm);
            allCollections.put(type, result);
            return result;
        }
    }

    private static void collectProperties(Map<String, Property> properties, EntityType type) {
        if (type == null) {
            return;
        }
        if (type.getExtendsId() != null) {
            MetaRegistryHelper.collectProperties(properties, MetaRegistry.get().getEntities().get(type.getExtendsId()));
        }
        for (Property property : type.getProperties().values()) {
            properties.put(property.getId(), property);
        }
    }

    private static void collectProperties(Map<String, DictionaryProperty> properties, DictionaryType type) {
        if (type == null) {
            return;
        }
        if (type.getExtendsId() != null) {
            MetaRegistryHelper.collectProperties(properties, MetaRegistry.get().getDictionaries().get(type.getExtendsId()));
        }
        for (DictionaryProperty property : type.getProperties().values()) {
            properties.put(property.getId(), property);
        }
    }

    private static void collectCollections(Map<String, EntityCollection> collections, BaseClassType type) {
        if (type == null) {
            return;
        }
        if (type.getExtendsId() != null) {
            MetaRegistryHelper.collectCollections(collections, MetaRegistry.get().getEntities().get(type.getExtendsId()));
        }
        for (EntityCollection entityCollection : type.getCollections().values()) {
            collections.put(entityCollection.getId(), entityCollection);
        }
    }

    public static String getNullableCollectionPropName(String collId) {
        return String.format("%sEqualNull", collId);
    }

    public static IndexType getIndexType(String id) {
        return MetaRegistry.get().getIndexes().get(id);
    }

    public static String getDisplayName(Class<?> clazz, String propertyName) {
        return MetaRegistryHelper.getDisplayName(clazz, propertyName, LocaleManager.get().getCurrentLocale());
    }

    public static String getDisplayName(Class<?> clazz, String propertyName, Locale locale) {
        EnumItem ei;
        EntityType entityType = MetaRegistryHelper.getEntityType(clazz.getName());
        if (entityType != null) {
            Property ep = entityType.getProperties().get(propertyName);
            if (ep != null) {
                return ep.getDisplayName(locale);
            }
            EntityCollection ec = entityType.getCollections().get(propertyName);
            return ec == null ? null : ec.getDisplayName(locale);
        }
        IndexType indexType = MetaRegistryHelper.getIndexType(clazz.getName());
        if (indexType != null) {
            IndexProperty ip = indexType.getProperties().get(propertyName);
            if (ip != null) {
                return ip.getDisplayName(locale);
            }
            IndexCollection ic = indexType.getCollections().get(propertyName);
            return ic == null ? null : ic.getDisplayName(locale);
        }
        EnumType enumType = MetaRegistryHelper.getEnumType(clazz.getName());
        if (enumType != null && (ei = enumType.getItems().get(propertyName)) != null) {
            return ei.getDisplayName(locale);
        }
        return null;
    }

    public static String getDisplayName(Class<?> clazz) {
        return MetaRegistryHelper.getDisplayName(clazz, LocaleManager.get().getCurrentLocale());
    }

    public static String getDisplayName(Class<?> clazz, Locale locale) {
        EntityType entityType = MetaRegistryHelper.getEntityType(clazz.getName());
        if (entityType != null) {
            return entityType.getDisplayName(locale);
        }
        IndexType indexType = MetaRegistryHelper.getIndexType(clazz.getName());
        if (indexType != null) {
            return indexType.getDisplayName(locale);
        }
        return MiscUtil.getSimpleClassName(clazz);
    }
}

