/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.meta;

import com.gridnine.xtrip.common.l10n.model.Resources;
import com.gridnine.xtrip.common.meta.BaseReferenceProperty;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.xml.XHelper;
import org.w3c.dom.Element;

public class Property
extends BaseReferenceProperty {
    private boolean viewable;
    private boolean readonly;
    private boolean privateField;
    private Boolean defaultBooleanValue;

    Property(String ownerId) {
        super(ownerId);
    }

    public boolean isReadonly() {
        return this.readonly;
    }

    @Override
    protected void fromXml(Element elm, Resources res) {
        super.fromXml(elm, res);
        this.viewable = this.viewable || XHelper.readBoolean(elm, "@viewable", true);
        this.readonly = this.readonly || XHelper.readBoolean(elm, "@readonly", false);
        this.privateField = this.privateField || XHelper.readBoolean(elm, "@private", false);
        String attValue = XHelper.readString(elm, "@default_boolean_value");
        if (!TextUtil.isBlank(attValue)) {
            this.defaultBooleanValue = Boolean.valueOf(attValue);
        }
    }

    public boolean isViewable() {
        return this.viewable;
    }

    public boolean isPrivateField() {
        return this.privateField;
    }

    public Boolean getDefaultBooleanValue() {
        return this.defaultBooleanValue;
    }
}

