/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.meta.export;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.meta.export.BaseExportedElementType;
import com.gridnine.xtrip.common.meta.export.ExportMetaRegistry;
import com.gridnine.xtrip.common.meta.export.ExportMetadataProvider;
import com.gridnine.xtrip.common.meta.export.ExportedCollectionExtender;
import com.gridnine.xtrip.common.meta.export.ExportedCollectionType;
import com.gridnine.xtrip.common.meta.export.ExportedCustomEntityDescriptor;
import com.gridnine.xtrip.common.meta.export.ExportedEntityType;
import com.gridnine.xtrip.common.meta.export.ExportedPropertyType;
import com.gridnine.xtrip.common.meta.export.ExportedRootEntityType;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.export.ObjectReferenceExport;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.xml.XHelper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class ExportedObjectsMetadataHelper {
    private static final Map<String, ExportedCollectionExtender> collectionsExtenders = new ConcurrentHashMap<String, ExportedCollectionExtender>();
    private static final Map<String, String> PRIMITIVE_TYPES = new HashMap<String, String>();
    private static final Pattern PATTERN;

    public static String getValueType(ExportedPropertyType elm) throws Exception {
        switch (elm.getType()) {
            case STRING: {
                return MiscUtil.getSimpleClassName(String.class);
            }
            case REFERENCE: {
                return ObjectReferenceExport.class.getName();
            }
            case ENTITY: {
                return elm.getEntityId();
            }
            case DATE: 
            case DATETIME: {
                return Date.class.getName();
            }
            case BOOLEAN: {
                return Boolean.class.getName();
            }
            case INTEGER: {
                return Integer.class.getName();
            }
            case BIGDECIMAL: {
                return BigDecimal.class.getName();
            }
        }
        throw Xeption.forDeveloper("unsupported element type {0}", elm.getType().name());
    }

    public static Map<String, ExportedPropertyType> getAllProperties(ExportedEntityType type) {
        return type.getProperties();
    }

    public static Map<String, ExportedCollectionType> getAllCollections(ExportedEntityType type) {
        return type.getCollections();
    }

    public static Collection<ExportedRootEntityType> getAllRootEntities() {
        ArrayList<ExportedRootEntityType> result = new ArrayList<ExportedRootEntityType>();
        for (ExportedEntityType item : Environment.getPublished(ExportMetadataProvider.class).getEntities().values()) {
            if (!(item instanceof ExportedRootEntityType)) continue;
            ExportedRootEntityType rootEntity = (ExportedRootEntityType)item;
            result.add(rootEntity);
        }
        return result;
    }

    public static String getElementType(ExportedCollectionType collection) {
        throw Xeption.forDeveloper("unsupported collection type {0}", collection.getClass().getName());
    }

    private ExportedObjectsMetadataHelper() {
    }

    public static String getValueType(ExportedCollectionType coll) {
        return ExportedObjectsMetadataHelper.getValueType(coll, Environment.getPublished(ExportMetaRegistry.class));
    }

    public static String getValueType(ExportedCollectionType coll, ExportMetaRegistry registry) {
        if (coll.getPossibleElements().size() > 1) {
            return MiscUtil.getSimpleClassName(Object.class);
        }
        String valueType = coll.getPossibleElements().values().iterator().next();
        if (registry.getEntities().containsKey(valueType)) {
            return valueType;
        }
        throw Xeption.forDeveloper("unsupported element type {0} of collection \"{1}\"", valueType, coll.getId());
    }

    public static ExportedEntityType getEntityType(String entityId) {
        ExportMetadataProvider registry = Environment.getPublished(ExportMetadataProvider.class);
        ExportedCustomEntityDescriptor entityDescriptor = registry.getCustomEntityDescriptor(entityId);
        if (entityDescriptor != null) {
            return entityDescriptor.getMetadata();
        }
        return registry.getEntities().get(entityId);
    }

    public static String getDisplayName(BaseExportedElementType o1, ExportedEntityType parent) {
        ExportedCustomEntityDescriptor ed;
        if (parent != null) {
            ExportedCustomEntityDescriptor ed2 = ExportMetadataProvider.get().getCustomEntityDescriptor(parent.getId());
            if (ed2 != null) {
                return ed2.getPropertyDisplayName(o1.getId(), LocaleManager.get().getCurrentLocale());
            }
        } else if (o1 instanceof ExportedEntityType && (ed = ExportMetadataProvider.get().getCustomEntityDescriptor(o1.getId())) != null) {
            return ed.getEntityDisplayName(LocaleManager.get().getCurrentLocale());
        }
        return Environment.getPublished(ExportMetadataProvider.class).getDisplayName(o1, LocaleManager.get().getCurrentLocale());
    }

    public static String getDocumentation(BaseExportedElementType o1, ExportedEntityType parent) {
        ExportedCustomEntityDescriptor ed;
        if (parent != null) {
            ExportedCustomEntityDescriptor ed2 = ExportMetadataProvider.get().getCustomEntityDescriptor(parent.getId());
            if (ed2 != null) {
                return ed2.getPropertyDocumentation(o1.getId(), LocaleManager.get().getCurrentLocale());
            }
        } else if (o1 instanceof ExportedEntityType && (ed = ExportMetadataProvider.get().getCustomEntityDescriptor(o1.getId())) != null) {
            return ed.getEntityDocumentation(LocaleManager.get().getCurrentLocale());
        }
        return Environment.getPublished(ExportMetadataProvider.class).getDocumentation(o1, LocaleManager.get().getCurrentLocale());
    }

    public static String getPropertyName(String id) {
        Matcher m = PATTERN.matcher(id);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            m.appendReplacement(sb, m.group(1).toUpperCase());
        }
        m.appendTail(sb);
        return sb.toString();
    }

    public static Map<String, String> getAllPossibleElements(ExportedCollectionType type) {
        if (TextUtil.isBlank(type.getExtenderClass())) {
            return type.getPossibleElements();
        }
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>(type.getPossibleElements());
        ExportedCollectionExtender extender = collectionsExtenders.get(type.getExtenderClass());
        if (extender == null) {
            extender = (ExportedCollectionExtender)XHelper.getInstance(type.getExtenderClass(), new Object[0]);
            collectionsExtenders.putIfAbsent(type.getExtenderClass(), extender);
        }
        result.putAll(extender.getAdditionalPossibleMembers());
        return result;
    }

    static {
        PRIMITIVE_TYPES.put("byte", "Byte");
        PRIMITIVE_TYPES.put("short", "Short");
        PRIMITIVE_TYPES.put("int", "Integer");
        PRIMITIVE_TYPES.put("long", "Long");
        PRIMITIVE_TYPES.put("float", "Float");
        PRIMITIVE_TYPES.put("double", "Double");
        PRIMITIVE_TYPES.put("boolean", "Boolean");
        PRIMITIVE_TYPES.put("char", "Character");
        PATTERN = Pattern.compile("-([a-zA-Z])");
    }
}

