/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.meta.rest;

import com.gridnine.xtrip.common.l10n.model.Resources;
import com.gridnine.xtrip.common.meta.rest.BaseTypeMember;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.XHelper;
import java.util.LinkedHashMap;
import java.util.Map;
import org.w3c.dom.Element;

public class RestInformationMessageItem
extends BaseTypeMember {
    private final Map<String, String> parameters = new LinkedHashMap<String, String>();
    private Severity severity;

    RestInformationMessageItem(String ownerId) {
        super(ownerId);
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public Severity getSeverity() {
        return this.severity;
    }

    @Override
    protected void fromXml(Element elm, Resources res) {
        super.fromXml(elm, res);
        String val = XmlUtil.getValue(elm, "@severity");
        if ("info".equals(val)) {
            this.severity = Severity.INFO;
        } else if ("warning".equals(val)) {
            this.severity = Severity.WARNING;
        } else if ("error".equals(val)) {
            this.severity = Severity.ERROR;
        } else {
            throw Xeption.forDeveloper("invalid severity value {0}", val);
        }
        for (Element itemElm : XmlUtil.getElements(elm, "parameter")) {
            this.parameters.put(XHelper.readString(itemElm, "@name"), XHelper.readString(itemElm, "@type"));
        }
    }

    public static enum Severity {
        INFO,
        WARNING,
        ERROR;

    }
}

