/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.meta.rest;

import com.gridnine.xtrip.common.l10n.model.Resources;
import com.gridnine.xtrip.common.meta.rest.BaseServiceMetaElement;
import com.gridnine.xtrip.common.meta.rest.RestServiceGroup;
import com.gridnine.xtrip.common.meta.rest.RestServiceOperation;
import com.gridnine.xtrip.common.meta.rest.RestServicePage;
import com.gridnine.xtrip.common.meta.rest.RestStringWithLang;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.XHelper;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;

public class RestService
extends BaseServiceMetaElement {
    private String path;
    private String webSocketPath;
    private String validatingPathSuffix;
    private String forward;
    private final List<RestStringWithLang> documentation = new ArrayList<RestStringWithLang>();
    private String docHandler = "com.gridnine.xtrip.server.model.rest.standard.StandardDocGenerator";
    private boolean customerFacing;
    private final List<String> typeHandlers = new ArrayList<String>();
    private final List<String> typeDiscriminators = new ArrayList<String>();
    private final List<BaseInterceptorDescriptor> interceptors = new ArrayList<BaseInterceptorDescriptor>();
    private final Map<String, RestServiceOperation> operations = new LinkedHashMap<String, RestServiceOperation>();
    private final Map<String, RestServiceGroup> groups = new LinkedHashMap<String, RestServiceGroup>();
    private final Map<String, RestServicePage> pages = new LinkedHashMap<String, RestServicePage>();

    RestService() {
    }

    public String getPath() {
        return this.path;
    }

    public String getWebSocketPath() {
        return this.webSocketPath;
    }

    public String getValidatingPathSuffix() {
        return this.validatingPathSuffix;
    }

    public String getForward() {
        return this.forward;
    }

    public List<RestStringWithLang> getDocumentation() {
        return this.documentation;
    }

    public String getDocHandler() {
        return this.docHandler;
    }

    public boolean isCustomerFacing() {
        return this.customerFacing;
    }

    public List<String> getTypeHandlers() {
        return this.typeHandlers;
    }

    public List<String> getTypeDiscriminators() {
        return this.typeDiscriminators;
    }

    public List<BaseInterceptorDescriptor> getInterceptors() {
        return this.interceptors;
    }

    public Map<String, RestServiceOperation> getOperations() {
        return this.operations;
    }

    public Map<String, RestServiceGroup> getGroups() {
        return this.groups;
    }

    public Map<String, RestServicePage> getPages() {
        return this.pages;
    }

    @Override
    protected void fromXml(Element elm, Resources res) {
        String value;
        super.fromXml(elm, res);
        if (TextUtil.isBlank(this.path)) {
            this.path = XHelper.readString(elm, "@path");
        }
        if (TextUtil.isBlank(this.webSocketPath)) {
            this.webSocketPath = XHelper.readString(elm, "@websocket-path");
        }
        if (TextUtil.isBlank(this.validatingPathSuffix)) {
            this.validatingPathSuffix = XHelper.readString(elm, "@validating-path-suffix");
        }
        if (TextUtil.isBlank(this.forward)) {
            this.forward = XHelper.readString(elm, "@forward");
        }
        for (Element docElm : XmlUtil.getElements(elm, "documentation")) {
            RestStringWithLang doc = new RestStringWithLang();
            doc.fromXml(docElm);
            if (TextUtil.isBlank(doc.getValue())) continue;
            this.documentation.add(doc);
        }
        if (TextUtil.isBlank(this.docHandler)) {
            this.docHandler = XHelper.readString(elm, "doc-handler");
        }
        this.customerFacing = XHelper.readBoolean(elm, "@customer-facing", false);
        for (Element handlerElm : XmlUtil.getElements(elm, "type-handler")) {
            value = XmlUtil.getValue(handlerElm);
            if (TextUtil.isBlank(value)) continue;
            this.typeHandlers.add(value);
        }
        for (Element discriminatorElm : XmlUtil.getElements(elm, "type-discriminator")) {
            value = XmlUtil.getValue(discriminatorElm);
            if (TextUtil.isBlank(value)) continue;
            this.typeDiscriminators.add(value);
        }
        for (Element childElm : XmlUtil.getChildren(elm)) {
            BaseInterceptorDescriptor descr;
            if ("generic-interceptor".equals(childElm.getTagName())) {
                descr = new GenericInterceptorDescriptor();
                descr.fromXml(childElm);
            } else {
                if (!"auth-interceptor".equals(childElm.getTagName())) continue;
                descr = new AuthInterceptorDescriptor();
                descr.fromXml(childElm);
            }
            this.interceptors.add(descr);
        }
    }

    public static class AuthInterceptorDescriptor
    extends BaseInterceptorDescriptor {
        private AppliedTo appliedTo;
        private boolean onException;

        AuthInterceptorDescriptor() {
        }

        public AppliedTo getAppliedTo() {
            return this.appliedTo;
        }

        public boolean isOnException() {
            return this.onException;
        }

        @Override
        void fromXml(Element elm) {
            super.fromXml(elm);
            this.appliedTo = XHelper.readCaseInsensitiveEnum(elm, "@applied-to", AppliedTo.class);
            this.onException = XHelper.readBoolean(elm, "@onException");
        }
    }

    public static class GenericInterceptorDescriptor
    extends BaseInterceptorDescriptor {
        GenericInterceptorDescriptor() {
        }
    }

    public static abstract class BaseInterceptorDescriptor {
        private String className;

        BaseInterceptorDescriptor() {
        }

        public String getClassName() {
            return this.className;
        }

        void fromXml(Element elm) {
            this.className = XHelper.readString(elm, ".");
        }
    }

    public static enum AppliedTo {
        ALL,
        NONE;

    }
}

