/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.meta.ui;

import com.gridnine.xtrip.common.l10n.model.Resources;
import com.gridnine.xtrip.common.meta.ui.BaseUiContainerItem;
import com.gridnine.xtrip.common.meta.ui.UiMetaRegistry;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.xml.XHelper;
import org.w3c.dom.Element;

public abstract class BaseUiContainerCell
extends BaseUiContainerItem {
    public static final int SPAN_REMAINING = Integer.MAX_VALUE;
    private int columnSpan;
    private int rowSpan;

    private static int readSpan(Element elm, String tagName) {
        String str = XHelper.readString(elm, tagName);
        if (TextUtil.isBlank(str)) {
            return 1;
        }
        if ("remaining".equals(str)) {
            return Integer.MAX_VALUE;
        }
        int result = Integer.parseInt(str);
        return result < 1 ? 1 : result;
    }

    BaseUiContainerCell(String ownerId) {
        super(ownerId);
    }

    public int getColumnSpan() {
        return this.columnSpan;
    }

    public int getRowSpan() {
        return this.rowSpan;
    }

    @Override
    protected void fromXml(Element elm, Resources res) {
        throw new UnsupportedOperationException();
    }

    void fromXml(Element elm, Resources res, UiMetaRegistry.ProcessingCallback callback) {
        super.fromXml(elm, res);
        this.columnSpan = BaseUiContainerCell.readSpan(elm, "@column-span");
        this.rowSpan = BaseUiContainerCell.readSpan(elm, "@row-span");
    }
}

