/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.meta.ui;

import com.gridnine.xtrip.common.util.TextUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;

class ListWithInjections<T> {
    private final Function<T, String> idFunc;
    private List<T> processed;
    private List<T> added;
    private List<Injection<T>> injected;

    ListWithInjections(Function<T, String> idf) {
        this.idFunc = idf;
    }

    void addOrInject(T item, String before, String after) {
        if (this.processed != null) {
            throw new IllegalStateException("modifications of processed list not allowed");
        }
        if (TextUtil.isBlank(after) && TextUtil.isBlank(before)) {
            if (this.added == null) {
                this.added = new ArrayList<T>();
            }
            this.added.add(item);
        } else {
            if (this.injected == null) {
                this.injected = new ArrayList<Injection<T>>();
            }
            this.injected.add(new Injection<T>(item, before, after));
        }
    }

    List<T> asList() {
        if (this.processed == null) {
            this.processed = this.process();
        }
        return this.processed;
    }

    private List<T> process() {
        ArrayList<T> result = new ArrayList<T>();
        if (this.added != null) {
            result.addAll(this.added);
            this.added = null;
        }
        if (this.injected != null) {
            for (Injection injection : this.injected) {
                injection.inject(result, this.idFunc);
            }
            this.injected = null;
        }
        return result;
    }

    private static class Injection<T> {
        private final T item;
        private final String before;
        private final String after;

        Injection(T itm, String bfr, String aft) {
            this.item = itm;
            this.before = bfr;
            this.after = aft;
        }

        void inject(List<T> list, Function<T, String> idFunc) {
            for (int i = 0; i < list.size(); ++i) {
                T itm = list.get(i);
                if (itm == null) continue;
                String id = idFunc.apply(itm);
                if (id.equals(this.after)) {
                    list.add(i + 1, this.item);
                    return;
                }
                if (!id.equals(this.before)) continue;
                list.add(i, this.item);
                return;
            }
            list.add(this.item);
        }
    }
}

