/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.meta.ui;

import com.gridnine.xtrip.common.l10n.model.Resources;
import com.gridnine.xtrip.common.meta.BaseMetaElement;
import com.gridnine.xtrip.common.meta.ui.BaseUiContainer;
import com.gridnine.xtrip.common.meta.ui.BaseUiContainerItem;
import com.gridnine.xtrip.common.meta.ui.BaseUiWidget;
import com.gridnine.xtrip.common.meta.ui.ListWithInjections;
import com.gridnine.xtrip.common.meta.ui.UiAclResource;
import com.gridnine.xtrip.common.meta.ui.UiContainerReference;
import com.gridnine.xtrip.common.meta.ui.UiElement;
import com.gridnine.xtrip.common.meta.ui.UiLabel;
import com.gridnine.xtrip.common.meta.ui.UiMetaRegistry;
import com.gridnine.xtrip.common.meta.ui.UiModel;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.XHelper;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;

public class UiCardsContainer
extends BaseUiContainer {
    private final List<UiModel.Field> properties = new ArrayList<UiModel.Field>();
    private final ListWithInjections<Card> cards = new ListWithInjections<Card>(BaseMetaElement::getId);

    UiCardsContainer() {
    }

    public List<UiModel.Field> getProperties() {
        return this.properties;
    }

    public List<Card> getCards() {
        return this.cards.asList();
    }

    @Override
    void fromXml(Element elm, Resources res, UiMetaRegistry.ProcessingCallback callback) {
        super.fromXml(elm, res, callback);
        for (Element childElm : XmlUtil.getElements(elm, "property")) {
            UiModel.Field prop = new UiModel.Field();
            prop.fromXml(childElm);
            this.properties.add(prop);
        }
        for (Element childElm : XmlUtil.getElements(elm, "card")) {
            Card card = new Card(this.getId());
            card.fromXml(childElm, res, callback);
            this.cards.addOrInject(card, XHelper.readString(childElm, "@insert-before"), XHelper.readString(childElm, "@insert-after"));
        }
    }

    public static class Card
    extends BaseUiContainerItem {
        private Style style;
        private boolean hidden;
        private UiLabel caption;
        private UiLabel help;
        private UiElement payload;

        Card(String ownerId) {
            super(ownerId);
        }

        public Style getStyle() {
            return this.style == null ? Style.STATIC : this.style;
        }

        public boolean isHidden() {
            return this.hidden;
        }

        public UiLabel getCaption() {
            return this.caption;
        }

        public UiLabel getHelp() {
            return this.help;
        }

        public UiElement getPayload() {
            return this.payload;
        }

        @Override
        protected void fromXml(Element elm, Resources res) {
            throw new UnsupportedOperationException();
        }

        void fromXml(Element elm, Resources res, UiMetaRegistry.ProcessingCallback callback) {
            super.fromXml(elm, res);
            String str = XHelper.readString(elm, "@style");
            if (!TextUtil.isBlank(str)) {
                this.style = Style.decode(str);
            }
            this.hidden = XHelper.readBoolean(elm, "@hidden", false);
            for (Element childElm : XmlUtil.getChildren(elm)) {
                BaseUiContainer ctr;
                if ("acl".equals(childElm.getTagName())) {
                    this.acl = new UiAclResource();
                    this.acl.fromXml(childElm, res, callback);
                    continue;
                }
                if ("caption".equals(childElm.getTagName())) {
                    this.caption = callback.getOrCreateLabel(childElm);
                    continue;
                }
                if ("help".equals(childElm.getTagName())) {
                    this.help = callback.getOrCreateLabel(childElm);
                    continue;
                }
                this.payload = "container-ref".equals(childElm.getTagName()) ? new UiContainerReference(XHelper.readString(childElm, "@id")) : ((ctr = BaseUiContainer.read(childElm, res, callback)) != null ? new UiContainerReference(ctr.getId()) : BaseUiWidget.read(childElm, res, callback));
            }
            if (this.payload == null) {
                throw Xeption.forDeveloper("no payload found for card {0}", this.getId());
            }
        }
    }

    public static enum Style {
        STATIC,
        EXPANDED,
        COLLAPSED;


        static Style decode(String str) {
            if ("static".equals(str)) {
                return STATIC;
            }
            if ("expanded".equals(str)) {
                return EXPANDED;
            }
            if ("collapsed".equals(str)) {
                return COLLAPSED;
            }
            throw Xeption.forDeveloper("unknown card style {0}", str);
        }
    }
}

