/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.meta.ui;

import com.gridnine.xtrip.common.l10n.model.Resources;
import com.gridnine.xtrip.common.meta.BaseMetaElement;
import com.gridnine.xtrip.common.meta.ui.BaseUiContainer;
import com.gridnine.xtrip.common.meta.ui.BaseUiContainerCell;
import com.gridnine.xtrip.common.meta.ui.BaseUiWidget;
import com.gridnine.xtrip.common.meta.ui.ListWithInjections;
import com.gridnine.xtrip.common.meta.ui.UiAclResource;
import com.gridnine.xtrip.common.meta.ui.UiContainerReference;
import com.gridnine.xtrip.common.meta.ui.UiElement;
import com.gridnine.xtrip.common.meta.ui.UiLabel;
import com.gridnine.xtrip.common.meta.ui.UiMetaRegistry;
import com.gridnine.xtrip.common.meta.ui.UiModel;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.XHelper;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;

public class UiCellsContainer
extends BaseUiContainer {
    private final List<UiModel.Field> properties = new ArrayList<UiModel.Field>();
    private final List<Column> columns = new ArrayList<Column>();
    private final ListWithInjections<BaseCell> cells = new ListWithInjections<BaseCell>(BaseMetaElement::getId);

    UiCellsContainer() {
    }

    public List<UiModel.Field> getProperties() {
        return this.properties;
    }

    public List<Column> getColumns() {
        return this.columns;
    }

    public List<BaseCell> getCells() {
        return this.cells.asList();
    }

    @Override
    void fromXml(Element elm, Resources res, UiMetaRegistry.ProcessingCallback callback) {
        super.fromXml(elm, res, callback);
        for (Element childElm : XmlUtil.getChildren(elm)) {
            BaseCell cell;
            if ("model".equals(childElm.getTagName()) || "acl".equals(childElm.getTagName())) continue;
            if ("property".equals(childElm.getTagName())) {
                UiModel.Field prop = new UiModel.Field();
                prop.fromXml(childElm);
                this.properties.add(prop);
                continue;
            }
            if ("column".equals(childElm.getTagName())) {
                Column col = new Column();
                col.fromXml(childElm);
                this.columns.add(col);
                continue;
            }
            if ("simple-cell".equals(childElm.getTagName())) {
                cell = new SimpleCell(this.getId());
                ((SimpleCell)cell).fromXml(childElm, res, callback);
                this.cells.addOrInject(cell, XHelper.readString(childElm, "@insert-before"), XHelper.readString(childElm, "@insert-after"));
                continue;
            }
            if ("complex-cell".equals(childElm.getTagName())) {
                cell = new ComplexCell(this.getId());
                ((ComplexCell)cell).fromXml(childElm, res, callback);
                this.cells.addOrInject(cell, XHelper.readString(childElm, "@insert-before"), XHelper.readString(childElm, "@insert-after"));
                continue;
            }
            throw Xeption.forDeveloper("unsupported tag {0}", childElm.getTagName());
        }
    }

    public static class ComplexCell
    extends BaseCell {
        private UiElement payload;

        ComplexCell(String ownerId) {
            super(ownerId);
        }

        public UiElement getPayload() {
            return this.payload;
        }

        @Override
        void fromXml(Element elm, Resources res, UiMetaRegistry.ProcessingCallback callback) {
            super.fromXml(elm, res, callback);
            for (Element childElm : XmlUtil.getChildren(elm)) {
                BaseUiContainer ctr;
                if ("acl".equals(childElm.getTagName())) {
                    this.acl = new UiAclResource();
                    this.acl.fromXml(childElm, res, callback);
                    continue;
                }
                this.payload = "container-ref".equals(childElm.getTagName()) ? new UiContainerReference(XHelper.readString(childElm, "@id")) : ((ctr = BaseUiContainer.read(childElm, res, callback)) != null ? new UiContainerReference(ctr.getId()) : BaseUiWidget.read(childElm, res, callback));
            }
            if (this.payload == null) {
                throw Xeption.forDeveloper("no payload found for complex cell {0}", this.getId());
            }
        }
    }

    public static class SimpleCell
    extends BaseCell {
        private UiLabel help;
        private UiLabel value;
        private CellStyle style;
        private CellAlignment alignment = CellAlignment.CENTER_LEFT;

        SimpleCell(String ownerId) {
            super(ownerId);
        }

        public UiLabel getHelp() {
            return this.help;
        }

        public UiLabel getValue() {
            return this.value;
        }

        public CellStyle getStyle() {
            return this.style;
        }

        public CellAlignment getAlignment() {
            return this.alignment;
        }

        @Override
        void fromXml(Element elm, Resources res, UiMetaRegistry.ProcessingCallback callback) {
            Element valueElm;
            Element helpElm;
            super.fromXml(elm, res, callback);
            Element aclElm = XmlUtil.getElement(elm, "acl");
            if (aclElm != null) {
                if (this.acl == null) {
                    this.acl = new UiAclResource();
                }
                this.acl.fromXml(aclElm, res, callback);
            }
            if ((helpElm = XmlUtil.getElement(elm, "help")) != null) {
                this.help = callback.getOrCreateLabel(helpElm);
            }
            if ((valueElm = XmlUtil.getElement(elm, "value")) != null) {
                this.value = callback.getOrCreateLabel(valueElm);
            }
            this.style = CellStyle.decode(XHelper.readString(elm, "@style"));
            this.alignment = CellAlignment.decode(XHelper.readString(elm, "@alignment"));
        }
    }

    public static abstract class BaseCell
    extends BaseUiContainerCell {
        BaseCell(String ownerId) {
            super(ownerId);
        }
    }

    public static enum CellAlignment {
        TOP_LEFT,
        TOP_CENTER,
        TOP_RIGHT,
        CENTER_LEFT,
        CENTER,
        CENTER_RIGHT,
        BOTTOM_LEFT,
        BOTTOM_CENTER,
        BOTTOM_RIGHT;


        static CellAlignment decode(String str) {
            if ("top-left".equals(str)) {
                return TOP_LEFT;
            }
            if ("top-center".equals(str)) {
                return TOP_CENTER;
            }
            if ("top-right".equals(str)) {
                return TOP_RIGHT;
            }
            if ("center-left".equals(str)) {
                return CENTER_LEFT;
            }
            if ("center".equals(str)) {
                return CENTER;
            }
            if ("center-right".equals(str)) {
                return CENTER_RIGHT;
            }
            if ("bottom-left".equals(str)) {
                return BOTTOM_LEFT;
            }
            if ("bottom-center".equals(str)) {
                return BOTTOM_CENTER;
            }
            if ("bottom-right".equals(str)) {
                return BOTTOM_RIGHT;
            }
            throw Xeption.forDeveloper("unknown cells contaner cell alignment {0}", str);
        }
    }

    public static enum CellStyle {
        BASIC,
        CAPTION,
        VALUE,
        COMBINED;


        static CellStyle decode(String str) {
            if ("basic".equals(str)) {
                return BASIC;
            }
            if ("caption".equals(str)) {
                return CAPTION;
            }
            if ("value".equals(str)) {
                return VALUE;
            }
            if ("combined".equals(str)) {
                return COMBINED;
            }
            throw Xeption.forDeveloper("unknown cells contaner cell style {0}", str);
        }
    }

    public static class Column {
        private Double prefWidth;

        Column() {
        }

        public Double getPrefWidth() {
            return this.prefWidth;
        }

        void fromXml(Element elm) {
            this.prefWidth = XHelper.readDouble(elm, "@pref-width");
        }
    }
}

