/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.meta.ui;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.l10n.model.Resources;
import com.gridnine.xtrip.common.util.LocaleUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Set;

public class UiLabel {
    final Set<Resources> resources = new LinkedHashSet<Resources>();
    String id;
    String content;

    UiLabel() {
    }

    public String getId() {
        return this.id;
    }

    public String getContent() {
        return this.content;
    }

    public String toString() {
        if (!Environment.isPublished(LocaleManager.class)) {
            return this.content;
        }
        return this.toString(LocaleManager.get().getCurrentLocale());
    }

    public String toString(Locale locale) {
        String value;
        if (TextUtil.isBlank(this.id)) {
            return this.content;
        }
        for (Resources res : this.resources) {
            value = res.findResource(this.id, locale);
            if (value == null) continue;
            return value;
        }
        if (!LocaleUtil.LOCALE_RU.equals(locale)) {
            for (Resources res : this.resources) {
                value = res.findResource(this.id, LocaleUtil.LOCALE_RU);
                if (value == null) continue;
                return value;
            }
        }
        return TextUtil.isBlank(this.content) ? this.id : this.content;
    }
}

