/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.meta.ui;

import com.gridnine.xtrip.common.l10n.model.Resources;
import com.gridnine.xtrip.common.meta.ui.BaseUiContainer;
import com.gridnine.xtrip.common.meta.ui.BaseUiWidget;
import com.gridnine.xtrip.common.meta.ui.ListWithInjections;
import com.gridnine.xtrip.common.meta.ui.UiAclResource;
import com.gridnine.xtrip.common.meta.ui.UiContainerReference;
import com.gridnine.xtrip.common.meta.ui.UiLabel;
import com.gridnine.xtrip.common.meta.ui.UiMetaRegistry;
import com.gridnine.xtrip.common.meta.ui.UiModel;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.XHelper;
import java.util.List;
import org.w3c.dom.Element;

public class UiWidgetBigTableBox
extends BaseUiWidget {
    private UiModel model;
    private UiLabel placeholder;
    private boolean reorderable;
    private final ListWithInjections<BaseColumn> columns = new ListWithInjections<BaseColumn>(BaseColumn::getId);

    UiWidgetBigTableBox() {
    }

    public UiModel getModel() {
        return this.model;
    }

    public UiLabel getPlaceholder() {
        return this.placeholder;
    }

    public boolean isReorderable() {
        return this.reorderable;
    }

    public List<BaseColumn> getColumns() {
        return this.columns.asList();
    }

    @Override
    protected void fromXml(Element elm, Resources res, UiMetaRegistry.ProcessingCallback callback) {
        super.fromXml(elm, res, callback);
        for (Element childElm : XmlUtil.getChildren(elm)) {
            BaseColumn col;
            if ("model".equals(childElm.getTagName())) {
                if (this.model == null) {
                    this.model = new UiModel();
                }
                this.model.fromXml(childElm);
                continue;
            }
            if ("placeholder".equals(childElm.getTagName())) {
                this.placeholder = callback.getOrCreateLabel(childElm);
                continue;
            }
            if ("column".equals(childElm.getTagName())) {
                col = new SimpleColumn();
            } else if ("combo-box-column".equals(childElm.getTagName())) {
                col = new ComboBoxColumn();
            } else if ("key-value-column".equals(childElm.getTagName())) {
                col = new KeyValueColumn();
            } else if ("super-column".equals(childElm.getTagName())) {
                col = new SuperColumn();
            } else {
                if (!"nested-entity-reference-column".equals(childElm.getTagName())) continue;
                col = new NestedEntityReferenceColumn();
            }
            ((BaseColumn)col).fromXml(childElm, res, callback);
            this.columns.addOrInject(col, XHelper.readString(childElm, "@insert-before"), XHelper.readString(childElm, "@insert-after"));
        }
        this.reorderable = XHelper.readBoolean(elm, "@reorderable", this.reorderable);
    }

    public static class SuperColumn
    extends BaseColumn {
        private UiContainerReference payload;

        SuperColumn() {
        }

        public UiContainerReference getPayload() {
            return this.payload;
        }

        @Override
        void fromXml(Element elm, Resources res, UiMetaRegistry.ProcessingCallback callback) {
            super.fromXml(elm, res, callback);
            for (Element childElm : XmlUtil.getChildren(elm)) {
                if ("container-ref".equals(childElm.getTagName())) {
                    this.payload = new UiContainerReference(XHelper.readString(childElm, "@id"));
                    continue;
                }
                BaseUiContainer ctr = BaseUiContainer.read(childElm, res, callback);
                if (ctr == null) continue;
                this.payload = new UiContainerReference(ctr.getId());
            }
            if (this.payload == null) {
                throw Xeption.forDeveloper("no payload found for column {0}", this.getId());
            }
        }
    }

    public static class KeyValueColumn
    extends BaseColumn {
        private String keyModelClassName;

        public String getKeyModelClassName() {
            return this.keyModelClassName;
        }

        @Override
        void fromXml(Element elm, Resources res, UiMetaRegistry.ProcessingCallback callback) {
            super.fromXml(elm, res, callback);
            this.keyModelClassName = XHelper.readString(elm, "key-model-class");
        }
    }

    public static class NestedEntityReferenceColumn
    extends BaseColumn {
        private String rootModelClassName;
        private String nestedModelClassName;

        public String getRootModelClassName() {
            return this.rootModelClassName;
        }

        public String getNestedModelClassName() {
            return this.nestedModelClassName;
        }

        @Override
        void fromXml(Element elm, Resources res, UiMetaRegistry.ProcessingCallback callback) {
            super.fromXml(elm, res, callback);
            this.rootModelClassName = XHelper.readString(elm, "root-model-class");
            this.nestedModelClassName = XHelper.readString(elm, "nested-model-class");
        }
    }

    public static class ComboBoxColumn
    extends BaseColumn {
        private String modelClassName;

        public String getModelClassName() {
            return this.modelClassName;
        }

        @Override
        void fromXml(Element elm, Resources res, UiMetaRegistry.ProcessingCallback callback) {
            super.fromXml(elm, res, callback);
            this.modelClassName = XHelper.readString(elm, "model-class");
        }
    }

    public static class SimpleColumn
    extends BaseColumn {
        private ColumnType type;

        public ColumnType getType() {
            return this.type;
        }

        @Override
        void fromXml(Element elm, Resources res, UiMetaRegistry.ProcessingCallback callback) {
            super.fromXml(elm, res, callback);
            this.type = ColumnType.decode(XHelper.readString(elm, "@type"));
        }
    }

    public static abstract class BaseColumn {
        private UiAclResource acl;
        private UiLabel caption;
        private UiLabel help;
        private String id;
        private boolean notEditable;
        private Double prefWidthEm;
        private Double maxWidthEm;
        private Double minWidthEm;

        BaseColumn() {
        }

        public UiAclResource getAcl() {
            return this.acl;
        }

        public UiLabel getCaption() {
            return this.caption;
        }

        public UiLabel getHelp() {
            return this.help;
        }

        public String getId() {
            return this.id;
        }

        public boolean isNotEditable() {
            return this.notEditable;
        }

        public Double getPrefWidthEm() {
            return this.prefWidthEm;
        }

        public Double getMaxWidthEm() {
            return this.maxWidthEm;
        }

        public Double getMinWidthEm() {
            return this.minWidthEm;
        }

        void fromXml(Element elm, Resources res, UiMetaRegistry.ProcessingCallback callback) {
            Element helpElm;
            Element captionElm;
            this.id = XHelper.readString(elm, "@id");
            this.notEditable = XHelper.readBoolean(elm, "@not-editable", this.notEditable);
            this.prefWidthEm = XHelper.readDouble(elm, "@pref-width-em");
            this.maxWidthEm = XHelper.readDouble(elm, "@max-width-em");
            this.minWidthEm = XHelper.readDouble(elm, "@min-width-em");
            Element aclElm = XmlUtil.getElement(elm, "acl");
            if (aclElm != null) {
                this.acl = new UiAclResource();
                this.acl.fromXml(aclElm, res, callback);
            }
            if ((captionElm = XmlUtil.getElement(elm, "caption")) != null) {
                this.caption = callback.getOrCreateLabel(captionElm);
            }
            if ((helpElm = XmlUtil.getElement(elm, "help")) != null) {
                this.help = callback.getOrCreateLabel(helpElm);
            }
        }
    }

    public static enum ColumnType {
        STRING,
        DATE,
        DATE_TIME,
        PRICE,
        ACTION,
        BOOLEAN,
        NESTED_ENTITY_REFERENCE;


        static ColumnType decode(String str) {
            if ("string".equals(str)) {
                return STRING;
            }
            if ("date".equals(str)) {
                return DATE;
            }
            if ("date-time".equals(str)) {
                return DATE_TIME;
            }
            if ("price".equals(str)) {
                return PRICE;
            }
            if ("action".equals(str)) {
                return ACTION;
            }
            if ("boolean".equals(str)) {
                return BOOLEAN;
            }
            if ("nested-entity-reference".equals(str)) {
                return NESTED_ENTITY_REFERENCE;
            }
            throw Xeption.forDeveloper("unknown big table column type {0}", str);
        }
    }
}

