/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.meta.ui;

import com.gridnine.xtrip.common.l10n.model.Resources;
import com.gridnine.xtrip.common.meta.ui.BaseUiContainer;
import com.gridnine.xtrip.common.meta.ui.BaseUiWidget;
import com.gridnine.xtrip.common.meta.ui.UiAclResource;
import com.gridnine.xtrip.common.meta.ui.UiContainerReference;
import com.gridnine.xtrip.common.meta.ui.UiLabel;
import com.gridnine.xtrip.common.meta.ui.UiMetaRegistry;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.XHelper;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;

public class UiWidgetNavigatorBox
extends BaseUiWidget {
    private UiLabel placeholder;
    private UiLabel caption;
    private boolean reorderable;
    private Style style;
    private final List<Variant> variants = new ArrayList<Variant>();

    public UiLabel getPlaceholder() {
        return this.placeholder;
    }

    public UiLabel getCaption() {
        return this.caption;
    }

    public boolean isReorderable() {
        return this.reorderable;
    }

    public Style getStyle() {
        return this.style;
    }

    public List<Variant> getVariants() {
        return this.variants;
    }

    @Override
    protected void fromXml(Element elm, Resources res, UiMetaRegistry.ProcessingCallback callback) {
        Element captionElm;
        super.fromXml(elm, res, callback);
        Element placeholderElm = XmlUtil.getElement(elm, "placeholder");
        if (placeholderElm != null) {
            this.placeholder = callback.getOrCreateLabel(placeholderElm);
        }
        if ((captionElm = XmlUtil.getElement(elm, "caption")) != null) {
            this.caption = callback.getOrCreateLabel(captionElm);
        }
        this.reorderable = XHelper.readBoolean(elm, "@reorderable", this.reorderable);
        String str = XHelper.readString(elm, "@style");
        if (!TextUtil.isBlank(str)) {
            this.style = Style.decode(str);
        }
        for (Element varElm : XmlUtil.getElements(elm, "variant")) {
            Variant variant = new Variant();
            variant.fromXml(varElm, res, callback);
            this.variants.add(variant);
        }
    }

    public static enum Style {
        COMPACT,
        EXPANDED,
        PLAIN_NAVIGATION,
        TREE_NAVIGATION;


        static Style decode(String str) {
            if ("compact".equals(str)) {
                return COMPACT;
            }
            if ("expanded".equals(str)) {
                return EXPANDED;
            }
            if ("plain-navigation".equals(str)) {
                return PLAIN_NAVIGATION;
            }
            if ("tree-navigation".equals(str)) {
                return TREE_NAVIGATION;
            }
            throw Xeption.forDeveloper("unknown navigator box style {0}", str);
        }
    }

    public static class Variant {
        private UiAclResource acl;
        private UiLabel caption;
        private UiContainerReference payload;

        Variant() {
        }

        public UiAclResource getAcl() {
            return this.acl;
        }

        public UiLabel getCaption() {
            return this.caption;
        }

        public UiContainerReference getPayload() {
            return this.payload;
        }

        void fromXml(Element elm, Resources res, UiMetaRegistry.ProcessingCallback callback) {
            for (Element childElm : XmlUtil.getChildren(elm)) {
                if ("acl".equals(childElm.getTagName())) {
                    this.acl = new UiAclResource();
                    this.acl.fromXml(childElm, res, callback);
                    continue;
                }
                if ("caption".equals(childElm.getTagName())) {
                    this.caption = callback.getOrCreateLabel(childElm);
                    continue;
                }
                if ("container-ref".equals(childElm.getTagName())) {
                    this.payload = new UiContainerReference(XHelper.readString(childElm, "@id"));
                    continue;
                }
                BaseUiContainer ctr = BaseUiContainer.read(childElm, res, callback);
                if (ctr == null) continue;
                this.payload = new UiContainerReference(ctr.getId());
            }
            if (this.payload == null) {
                throw Xeption.forDeveloper("no payload found for navigator variant", new Object[0]);
            }
        }
    }
}

