/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model;

import com.gridnine.xtrip.common.util.Identity;
import com.gridnine.xtrip.common.util.UUIDGenerator;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import com.gridnine.xtrip.common.util.XSSerializable;
import com.gridnine.xtrip.common.util.XSerializable;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.common.xml.XSHelper;
import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.w3c.dom.Element;

public abstract class BaseAsset
implements Identity,
XSerializable,
XSSerializable,
Serializable,
XCloneable {
    private static final long serialVersionUID = 8393183529376854212L;
    private String uid;
    private Date modified;

    protected BaseAsset() {
        this.uid = UUIDGenerator.generate(true).toString();
    }

    protected BaseAsset(String aUid) {
        this.uid = aUid;
    }

    public Date getModified() {
        return this.modified;
    }

    public void setModified(Date modifiedValue) {
        this.modified = modifiedValue;
    }

    @Override
    public String getUid() {
        return this.uid;
    }

    @Override
    public void setUid(String value) {
        this.uid = value;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BaseAsset)) {
            return false;
        }
        return this.uid.equals(((BaseAsset)obj).uid);
    }

    public int hashCode() {
        return this.uid.hashCode();
    }

    public String toString() {
        return String.format("{%s: UID=%s}", this.getClass().getName(), this.getUid());
    }

    @Override
    public void fromXML(Element elm) throws Exception {
        this.uid = XHelper.readString(elm, "uid");
        this.modified = XHelper.readDate(elm, "modified");
    }

    @Override
    public final void fromXML(XMLStreamReader reader) throws Exception {
        throw new UnsupportedOperationException();
    }

    protected abstract boolean readXMLElement(XMLStreamReader var1) throws Exception;

    @Override
    public void toXML(Element elm) throws Exception {
        XHelper.writeString(elm, "uid", this.uid);
        XHelper.writeDate(elm, "modified", this.modified);
    }

    @Override
    public final void toXML(XMLStreamWriter writer) throws Exception {
        XSHelper.writeString(writer, "uid", this.uid);
        XSHelper.writeDate(writer, "modified", this.modified);
        this.writeXMLElements(writer);
    }

    protected abstract void writeXMLElements(XMLStreamWriter var1) throws Exception;

    @Override
    public final Object clone(boolean newUids, Map<String, String> uids) throws Exception {
        BaseAsset clone = (BaseAsset)this.getClass().newInstance();
        clone.uid = XCloneHelper.getNewUid(this.uid, newUids, uids);
        clone.modified = XCloneHelper.cloneDate(this.modified);
        clone.copyFrom(this, newUids, uids);
        return clone;
    }

    protected abstract void copyFrom(BaseAsset var1, boolean var2, Map<String, String> var3) throws Exception;

    public static enum Property {
        uid,
        modified;

    }
}

