/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model;

import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.BaseIdentity;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.EntityStatus;
import com.gridnine.xtrip.common.model.UpdatePolicy;
import com.gridnine.xtrip.common.model.VersionInfo;
import com.gridnine.xtrip.common.util.Identity;
import com.gridnine.xtrip.common.util.InvocationContext;
import com.gridnine.xtrip.common.util.UUIDGenerator;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.common.xml.XSHelper;
import java.util.Date;
import java.util.Map;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.w3c.dom.Element;

public class EntityContainer<T extends BaseEntity>
extends BaseEntity {
    private static final long serialVersionUID = 4572474451834905193L;
    private Date created = new Date();
    private Date modified = new Date();
    private String createdBy;
    private String modifiedBy;
    private EntityStatus status = EntityStatus.EDIT;
    private T entity;
    private final VersionInfo versionInfo = new VersionInfo(null);
    private int versionsCount = 1;
    private Class<T> entityType;
    private UpdatePolicy updatePolicy = UpdatePolicy.OVERWRITE;
    private Long revision;

    public static <T extends BaseEntity> EntityContainer<T> create(T entity) {
        EntityContainer result = new EntityContainer(entity.getClass());
        result.entity = entity;
        return result;
    }

    public static <T extends BaseEntity> EntityContainer<T> create(T entity, String uid) {
        EntityContainer result = new EntityContainer(entity.getClass(), uid);
        result.entity = entity;
        return result;
    }

    public EntityContainer() {
    }

    public EntityContainer(Class<T> cls) {
        super(UUIDGenerator.generate(true).toString());
        this.entityType = cls;
    }

    public EntityContainer(Class<T> cls, String uid) {
        super(uid);
        this.entityType = cls;
    }

    public Class<T> getEntityType() {
        return this.entityType;
    }

    public Date getCreated() {
        return this.created;
    }

    public void setCreated(Date value) {
        this.created = value;
    }

    public Date getModified() {
        return this.modified;
    }

    public void setModified(Date value) {
        this.modified = value;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String value) {
        this.createdBy = value;
    }

    public String getModifiedBy() {
        return this.modifiedBy;
    }

    public void setModifiedBy(String value) {
        this.modifiedBy = value;
    }

    public EntityStatus getStatus() {
        return this.status;
    }

    public void setStatus(EntityStatus value) {
        this.status = value;
    }

    public T getEntity() {
        if (this.entity == null) {
            try {
                this.entity = (BaseEntity)this.entityType.newInstance();
            }
            catch (Exception e) {
                throw new Error("failed creating new entity instance", e);
            }
        }
        return this.entity;
    }

    public VersionInfo getVersionInfo() {
        return this.versionInfo;
    }

    public int getVersionsCount() {
        return this.versionsCount;
    }

    public void setVersionsCount(int value) {
        this.versionsCount = value;
    }

    public EntityReference<T> toReference() {
        return new EntityReference<T>(this.getUid(), this.getEntityType(), ((BaseEntity)this.getEntity()).toString());
    }

    public void setUpdatePolicy(UpdatePolicy value) {
        this.updatePolicy = value;
    }

    public UpdatePolicy getUpdatePolicy() {
        return this.updatePolicy;
    }

    public Long getRevision() {
        return this.revision;
    }

    @Override
    public void fromXML(Element elm) throws Exception {
        Element versionInfoElm;
        Element versionElm;
        super.fromXML(elm);
        this.entityType = Class.forName(XHelper.readString(elm, "entityType"));
        this.created = XHelper.readDate(elm, "created");
        this.modified = XHelper.readDate(elm, "modified");
        this.createdBy = XHelper.readString(elm, "createdBy");
        this.modifiedBy = XHelper.readString(elm, "modifiedBy");
        this.status = XHelper.readEnum(elm, "status", EntityStatus.class);
        if (this.status == null) {
            this.status = EntityStatus.EDIT;
        }
        this.updatePolicy = XHelper.readEnum(elm, "updatePolicy", UpdatePolicy.class);
        if (this.updatePolicy == null) {
            this.updatePolicy = UpdatePolicy.OVERWRITE;
        }
        if ((versionElm = XmlUtil.getElement(elm, "version")) != null) {
            ((BaseEntity)this.getEntity()).fromXML(versionElm);
        }
        if ((versionInfoElm = XmlUtil.getElement(elm, "versionInfo")) != null) {
            this.versionInfo.fromXML(versionInfoElm);
        }
        this.versionsCount = XHelper.readInt(elm, "versionsCount", 1);
        this.revision = XHelper.readLong(elm, "revision");
    }

    @Override
    protected boolean readXMLElement(XMLStreamReader reader) throws Exception {
        String tagName = reader.getName().getLocalPart();
        if ("entityType".equals(tagName)) {
            this.entityType = Class.forName(XSHelper.readString(reader));
            return true;
        }
        if ("created".equals(tagName)) {
            this.created = XSHelper.readDate(reader);
            return true;
        }
        if ("modified".equals(tagName)) {
            this.modified = XSHelper.readDate(reader);
            return true;
        }
        if ("createdBy".equals(tagName)) {
            this.createdBy = XSHelper.readString(reader);
            return true;
        }
        if ("modifiedBy".equals(tagName)) {
            this.modifiedBy = XSHelper.readString(reader);
            return true;
        }
        if ("status".equals(tagName)) {
            this.status = XSHelper.readEnum(reader, EntityStatus.class);
            if (this.status == null) {
                this.status = EntityStatus.EDIT;
            }
            return true;
        }
        if ("updatePolicy".equals(tagName)) {
            this.updatePolicy = XSHelper.readEnum(reader, UpdatePolicy.class);
            if (this.updatePolicy == null) {
                this.updatePolicy = UpdatePolicy.OVERWRITE;
            }
            return true;
        }
        if ("version".equals(tagName)) {
            ((BaseEntity)this.getEntity()).fromXML(reader);
            return true;
        }
        if ("versionInfo".equals(tagName)) {
            this.versionInfo.fromXML(reader);
            return true;
        }
        if ("versionsCount".equals(tagName)) {
            this.versionsCount = XSHelper.readInt(reader, 1);
            return true;
        }
        if ("revision".equals(tagName)) {
            this.revision = XSHelper.readLong(reader);
            return true;
        }
        return false;
    }

    @Override
    public void toXML(Element elm) throws Exception {
        super.toXML(elm);
        XHelper.writeDate(elm, "created", this.created);
        XHelper.writeDate(elm, "modified", this.modified);
        XHelper.writeString(elm, "createdBy", this.createdBy);
        XHelper.writeString(elm, "modifiedBy", this.modifiedBy);
        XHelper.writeEnum(elm, "status", this.status);
        XHelper.writeEnum(elm, "updatePolicy", this.updatePolicy);
        if (this.entity != null) {
            ((BaseEntity)this.entity).toXML(XmlUtil.addElement(elm, "version"));
        }
        this.versionInfo.toXML(XmlUtil.addElement(elm, "versionInfo"));
        XHelper.writeInt(elm, "versionsCount", this.versionsCount);
        XHelper.writeString(elm, "entityType", this.entityType.getName());
        XHelper.writeLong(elm, "revision", this.revision);
    }

    @Override
    protected void writeXMLElements(XMLStreamWriter writer) throws Exception {
        super.writeXMLElements(writer);
        XSHelper.writeDate(writer, "created", this.created);
        XSHelper.writeDate(writer, "modified", this.modified);
        XSHelper.writeString(writer, "createdBy", this.createdBy);
        XSHelper.writeString(writer, "modifiedBy", this.modifiedBy);
        XSHelper.writeEnum(writer, "status", this.status);
        XSHelper.writeEnum(writer, "updatePolicy", this.updatePolicy);
        if (this.entity != null) {
            writer.writeStartElement("version");
            ((BaseEntity)this.entity).toXML(writer);
            writer.writeEndElement();
        }
        writer.writeStartElement("versionInfo");
        this.versionInfo.toXML(writer);
        writer.writeEndElement();
        XSHelper.writeInt(writer, "versionsCount", this.versionsCount);
        XSHelper.writeString(writer, "entityType", this.entityType.getName());
        XSHelper.writeLong(writer, "revision", this.revision);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void copyFrom(BaseEntity sourceEntity, boolean newUids, Map<String, String> uids) throws Exception {
        super.copyFrom(sourceEntity, newUids, uids);
        EntityContainer source = (EntityContainer)sourceEntity;
        this.entityType = source.entityType;
        this.created = XCloneHelper.cloneDate(source.created);
        this.modified = XCloneHelper.cloneDate(source.modified);
        this.createdBy = source.createdBy;
        this.modifiedBy = source.modifiedBy;
        this.status = source.status;
        this.updatePolicy = source.updatePolicy;
        if (source.entity != null) {
            ((BaseIdentity)this.getEntity()).setUid(XCloneHelper.getNewUid(((BaseIdentity)source.entity).getUid(), newUids, uids));
            ((BaseEntity)this.getEntity()).setCloneUidSet(true);
            boolean doExit = InvocationContext.get("entityClone").enter((Identity)this.getEntity());
            try {
                ((BaseEntity)this.getEntity()).copyFrom((BaseEntity)source.entity, newUids, uids);
            }
            finally {
                ((BaseEntity)this.getEntity()).setCloneUidSet(false);
                if (doExit) {
                    InvocationContext.get("entityClone").exit();
                }
            }
        }
        this.versionInfo.copyFrom(source.versionInfo, newUids, uids);
        this.versionsCount = source.versionsCount;
        this.revision = source.revision;
    }

    @Override
    public String toString() {
        return String.format("{container for %s: UID=%s}", this.entityType.getName(), this.getUid());
    }

    @Override
    public BaseEntity newInstance(String uid) {
        return new EntityContainer<T>(null, uid);
    }
}

