/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model;

import com.gridnine.xtrip.common.l10n.model.L10nString;
import com.gridnine.xtrip.common.model.HistoricalValue;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XSerializable;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.XHelper;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public final class HistoricalValueHelper {
    private static final ThreadLocal<DateFormat> DATETIME_FORMAT = ThreadLocal.withInitial(() -> new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS", Locale.ROOT));

    public static void readHistoricalString(Element elm, String path, List<HistoricalValue<String>> values) {
        HistoricalValueHelper.readHistoricalObject(elm, path, values, new ReadCallback<String>(){

            @Override
            public String getValue(Element element) {
                return XmlUtil.getValue(element);
            }
        });
    }

    public static void readHistoricalBoolean(Element elm, String path, List<HistoricalValue<Boolean>> values) {
        HistoricalValueHelper.readHistoricalObject(elm, path, values, new ReadCallback<Boolean>(){

            @Override
            public Boolean getValue(Element element) {
                return Boolean.valueOf(XmlUtil.getValue(element));
            }
        });
    }

    public static void readHistoricalDouble(Element elm, String path, List<HistoricalValue<Double>> values) {
        HistoricalValueHelper.readHistoricalObject(elm, path, values, new ReadCallback<Double>(){

            @Override
            public Double getValue(Element element) {
                String value = XmlUtil.getValue(element);
                if (TextUtil.nonBlank(value)) {
                    return Double.valueOf(value);
                }
                return null;
            }
        });
    }

    public static void readHistoricalBigDecimal(Element elm, String path, List<HistoricalValue<BigDecimal>> values) {
        HistoricalValueHelper.readHistoricalObject(elm, path, values, new ReadCallback<BigDecimal>(){

            @Override
            public BigDecimal getValue(Element element) {
                return new BigDecimal(XmlUtil.getValue(element));
            }
        });
    }

    public static void readHistoricalDate(Element elm, String path, List<HistoricalValue<Date>> values) {
        HistoricalValueHelper.readHistoricalObject(elm, path, values, element -> {
            String value = XmlUtil.getValue(element);
            if (TextUtil.nonBlank(value)) {
                try {
                    return DATETIME_FORMAT.get().parse(value);
                }
                catch (Exception e) {
                    LoggerFactory.getLogger(HistoricalValueHelper.class).warn(String.format("failed deserializing value %s", value));
                }
            }
            return null;
        });
    }

    public static <T extends XSerializable> void readHistoricalProperty(Element elm, String path, List<HistoricalValue<T>> values) {
        HistoricalValueHelper.readHistoricalObject(elm, path, values, new ReadCallback<T>(){

            @Override
            public T getValue(Element element) {
                return (XSerializable)XHelper.readObject(element, ".");
            }
        });
    }

    public static <T extends XSerializable> void readHistoricalDictProperty(final Element elm, final String path, List<HistoricalValue<T>> values, final DictionaryReferenceCreator<T> dictCreator) {
        HistoricalValueHelper.readHistoricalObject(elm, path, values, new ReadCallback<T>(){

            @Override
            public T getValue(Element element) {
                String dictCode = "";
                String dictCaption = "";
                if (TextUtil.isSame(element.getTagName(), path)) {
                    dictCode = XmlUtil.getValue(elm, path);
                    dictCaption = XmlUtil.getValue(elm, path + "@caption");
                } else {
                    dictCode = XmlUtil.getAttributes(element).get("code");
                    dictCaption = XmlUtil.getAttributes(element).get("caption");
                }
                Object dictRef = dictCreator.createDictElement(dictCode, dictCaption);
                return dictRef;
            }
        });
    }

    public static void readHistoricalLocalizableProperty(final Element elm, final String path, List<HistoricalValue<L10nString>> values) {
        HistoricalValueHelper.readHistoricalObject(elm, path, values, new ReadCallback<L10nString>(){

            @Override
            public L10nString getValue(Element element) {
                L10nString value = TextUtil.isSame(element.getTagName(), path) ? XHelper.readLocalizationString(elm, path) : XHelper.readLocalizationString(element, ".");
                return value;
            }
        });
    }

    public static void writeHistoricalString(Element elm, String path, List<HistoricalValue<String>> values, final boolean asCdata) {
        HistoricalValueHelper.writeHistoricalObject(elm, path, values, new WriteCallback<String>(){

            @Override
            public void setValue(Element element, String value) {
                XmlUtil.setValue(element, value, asCdata);
            }
        });
    }

    public static void writeHistoricalBoolean(Element elm, String path, List<HistoricalValue<Boolean>> values, final boolean asCdata) {
        HistoricalValueHelper.writeHistoricalObject(elm, path, values, new WriteCallback<Boolean>(){

            @Override
            public void setValue(Element element, Boolean value) {
                XmlUtil.setValue(element, String.valueOf(value), asCdata);
            }
        });
    }

    public static void writeHistoricalDouble(Element elm, String path, List<HistoricalValue<Double>> values, final boolean asCdata) {
        HistoricalValueHelper.writeHistoricalObject(elm, path, values, new WriteCallback<Double>(){

            @Override
            public void setValue(Element element, Double value) {
                XmlUtil.setValue(element, String.valueOf(value), asCdata);
            }
        });
    }

    public static void writeHistoricalBigDecimal(Element elm, String path, List<HistoricalValue<BigDecimal>> values, final boolean asCdata) {
        HistoricalValueHelper.writeHistoricalObject(elm, path, values, new WriteCallback<BigDecimal>(){

            @Override
            public void setValue(Element element, BigDecimal value) {
                XmlUtil.setValue(element, String.valueOf(value), asCdata);
            }
        });
    }

    public static void writeHistoricalDate(Element elm, String path, List<HistoricalValue<Date>> values) {
        HistoricalValueHelper.writeHistoricalObject(elm, path, values, (element, value) -> {
            if (value != null) {
                XmlUtil.setValue(element, DATETIME_FORMAT.get().format((Date)value));
            }
        });
    }

    public static <T extends XSerializable> void writeHistoricalProperty(Element elm, String path, List<HistoricalValue<T>> values) {
        HistoricalValueHelper.writeHistoricalObject(elm, path, values, new WriteCallback<T>(){

            @Override
            public void setValue(Element element, T value) {
                try {
                    value.toXML(element);
                }
                catch (Exception e) {
                    LoggerFactory.getLogger(this.getClass()).warn(String.format("failed serializing value %s", value));
                }
                element.setAttribute("class", value.getClass().getName());
            }
        });
    }

    public static <T extends XSerializable> void writeHistoricalDictProperty(Element elm, String path, List<HistoricalValue<T>> values, final DictionaryReferenceGetter dictProvider) {
        HistoricalValueHelper.writeHistoricalObject(elm, path, values, new WriteCallback<T>(){

            @Override
            public void setValue(Element element, T value) {
                try {
                    if (value != null) {
                        element.setAttribute("class", value.getClass().getName());
                        element.setAttribute("code", dictProvider.getCode(value));
                        if (!TextUtil.isBlank(dictProvider.getCaption(value))) {
                            element.setAttribute("caption", dictProvider.getCaption(value));
                        }
                    }
                }
                catch (Exception e) {
                    LoggerFactory.getLogger(this.getClass()).warn(String.format("failed serializing value %s", value));
                }
            }
        });
    }

    public static void writeHistoricalLocalizableProperty(Element elm, String path, List<HistoricalValue<L10nString>> values) {
        HistoricalValueHelper.writeHistoricalObject(elm, path, values, new WriteCallback<L10nString>(){

            @Override
            public void setValue(Element element, L10nString value) {
                try {
                    if (value != null) {
                        element.setTextContent(value.getStringValue());
                    }
                }
                catch (Exception e) {
                    LoggerFactory.getLogger(this.getClass()).warn(String.format("failed serializing value %s", value));
                }
            }
        });
    }

    public static <T> T getValue(List<HistoricalValue<T>> values) {
        return HistoricalValueHelper.getValue(values, new Date());
    }

    public static <T> T getValue(List<HistoricalValue<T>> values, Date date) {
        return HistoricalValueHelper.getValue(values, date, false);
    }

    public static <T> T getValue(List<HistoricalValue<T>> values, Date date, boolean strict) {
        if (values.isEmpty()) {
            return null;
        }
        HistoricalValue<T> value = HistoricalValueHelper.getHistoricalValue(values, date, strict);
        return value != null ? (T)value.getValue() : null;
    }

    public static <T> void setValue(List<HistoricalValue<T>> values, T value) {
        HistoricalValueHelper.setValue(values, value, new Date());
    }

    public static <T> void setValue(List<HistoricalValue<T>> values, T value, Date date) {
        if (values == null) {
            return;
        }
        if (values.size() == 0 && value == null) {
            return;
        }
        HistoricalValue<T> result = HistoricalValueHelper.getHistoricalValue(values, date);
        if (result == null) {
            result = new HistoricalValue();
            values.add(result);
        }
        result.setValue(value);
        result.setDate(date);
    }

    public static <T> HistoricalValue<T> getHistoricalValue(List<HistoricalValue<T>> values) {
        return HistoricalValueHelper.getHistoricalValue(values, new Date());
    }

    public static <T> HistoricalValue<T> getHistoricalValue(List<HistoricalValue<T>> values, Date date) {
        return HistoricalValueHelper.getHistoricalValue(values, date, false);
    }

    public static <T> HistoricalValue<T> getHistoricalValue(List<HistoricalValue<T>> values, Date date, boolean strict) {
        if (values.isEmpty() || date == null) {
            return null;
        }
        if (strict) {
            return values.stream().filter(v -> v.getDate() != null && v.getDate().before(date)).max((o1, o2) -> MiscUtil.compare(o1.getDate(), o2.getDate())).orElse(null);
        }
        HistoricalValue<T> result = null;
        for (HistoricalValue<T> value : values) {
            if (value.getDate() == null || result != null && (!value.getDate().before(date) || !value.getDate().after(result.getDate()))) continue;
            result = value;
        }
        return result;
    }

    private static <T> void readHistoricalObject(Element elm, String path, List<HistoricalValue<T>> values, ReadCallback<T> callback) {
        values.clear();
        if (elm == null) {
            return;
        }
        Element item = XmlUtil.getElement(elm, path);
        if (item == null) {
            return;
        }
        Element[] elements = XmlUtil.getElements(item, "item");
        if (elements.length == 0) {
            T value = callback.getValue(item);
            if (value != null) {
                HistoricalValue<T> historicalValue = new HistoricalValue<T>();
                historicalValue.setValue(value);
                historicalValue.setDate(new Date());
                values.add(historicalValue);
            }
        } else {
            for (Element element : elements) {
                HistoricalValue<T> historicalValue = new HistoricalValue<T>();
                historicalValue.setUid(element.getAttribute("uid"));
                historicalValue.setValue(callback.getValue(XmlUtil.getElement(element, "value")));
                historicalValue.setDate(XHelper.readDate(element, "date"));
                values.add(historicalValue);
            }
        }
    }

    private static <T> void writeHistoricalObject(Element elm, String path, List<HistoricalValue<T>> values, WriteCallback<T> callback) {
        if (values.isEmpty()) {
            return;
        }
        Element element = XmlUtil.addElement(elm, path);
        for (HistoricalValue<T> value : values) {
            if (value.getValue() == null) continue;
            Element item = XmlUtil.addElement(element, "item");
            item.setAttribute("uid", value.getUid());
            callback.setValue(XmlUtil.addElement(item, "value"), value.getValue());
            XHelper.writeDate(item, "date", value.getDate());
        }
    }

    public static interface DictionaryReferenceCreator<T extends XSerializable> {
        public T createDictElement(String var1, String var2);
    }

    public static interface DictionaryReferenceGetter<T> {
        public String getCaption(T var1);

        public String getCode(T var1);
    }

    public static interface WriteCallback<T> {
        public void setValue(Element var1, T var2);
    }

    public static interface ReadCallback<T> {
        public T getValue(Element var1);
    }
}

