/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model;

import com.gridnine.xtrip.common.util.TextUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MulticallException
extends RuntimeException {
    private static final long serialVersionUID = 215679310424818557L;
    private volatile transient String message;
    private static final Pattern PATTERN = Pattern.compile("\n-BEGIN OF THE LIST-.*-END OF THE LIST-", 32);
    private final Map<Object, Throwable> subrouteExceptions = new HashMap<Object, Throwable>();

    public MulticallException() {
    }

    public MulticallException(Object target, Throwable t) {
        if (null == t) {
            throw new IllegalArgumentException();
        }
        this.subrouteExceptions.put(target, t);
    }

    @Override
    public String getMessage() {
        if (this.message != null) {
            return this.message;
        }
        StringBuilder sb = new StringBuilder();
        int size = this.subrouteExceptions.size();
        if (this.subrouteExceptions.size() == 0) {
            sb.append("no errors has occurred.");
        } else {
            if (1 == size) {
                sb.append(String.format("an error has occurred %d", size));
            } else {
                sb.append(String.format("%d errors have occurred", size));
            }
            sb.append(":");
            int i = 1;
            sb.append("\n").append("-BEGIN OF THE LIST-");
            for (Map.Entry<Object, Throwable> entry : this.subrouteExceptions.entrySet()) {
                String targetValue;
                Object target = entry.getKey();
                String string = targetValue = target != null ? target.toString() : "(null)";
                if (targetValue.length() > 40) {
                    targetValue = targetValue.substring(0, 40);
                }
                sb.append("\n").append(i++).append(" [").append(targetValue).append("]: ");
                Throwable ex = entry.getValue();
                try {
                    String str = TextUtil.getExceptionStackTraceRegular(ex);
                    Matcher matcher = PATTERN.matcher(str);
                    int p = 0;
                    while (matcher.find()) {
                        sb.append(str.substring(p, matcher.start()));
                        sb.append(matcher.group().replace("\n", "\n\t"));
                        p = matcher.end();
                    }
                    sb.append(str.substring(p));
                }
                catch (Throwable e) {
                    sb.append(ex.toString());
                    sb.append("\nUNABLE TO GET STACK TRACE BECAUSE AN EXCEPTION HAS OCCURRED: " + e.getMessage());
                }
            }
            sb.append("\n").append("-END OF THE LIST-");
        }
        this.message = sb.toString();
        return this.message;
    }

    public void addSubrouteException(Object target, Throwable t) {
        if (null == t) {
            throw new IllegalArgumentException();
        }
        this.subrouteExceptions.put(target, t);
        this.message = null;
    }

    public <T> Map<T, Throwable> getSubrouteExceptions() {
        return Collections.unmodifiableMap(this.subrouteExceptions);
    }
}

