/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model;

import com.gridnine.xtrip.common.model.PeriodicalValue;
import com.gridnine.xtrip.common.util.XSerializable;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.XHelper;
import java.util.Date;
import java.util.List;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public final class PeriodicalPropertyHelper {
    public static void readPeriodicalString(Element elm, String path, List<PeriodicalValue<String>> values) {
        PeriodicalPropertyHelper.readPeriodicalObject(elm, path, values, new ReadCallback<String>(){

            @Override
            public String getValue(Element element) {
                return XmlUtil.getValue(element);
            }
        });
    }

    public static <T extends XSerializable> void readPeriodicalProperty(Element elm, String path, List<PeriodicalValue<T>> values) {
        PeriodicalPropertyHelper.readPeriodicalObject(elm, path, values, new ReadCallback<T>(){

            @Override
            public T getValue(Element element) {
                return (XSerializable)XHelper.readObject(element, ".");
            }
        });
    }

    public static void writePeriodicalString(Element elm, String path, List<PeriodicalValue<String>> values, final boolean asCdata) {
        PeriodicalPropertyHelper.writePeriodicalProperty(elm, path, values, new WriteCallback<String>(){

            @Override
            public void setValue(Element element, String value) {
                XmlUtil.setValue(element, value, asCdata);
            }
        });
    }

    public static <T extends XSerializable> void writePeriodicalProperty(Element elm, String path, List<PeriodicalValue<T>> values) {
        PeriodicalPropertyHelper.writePeriodicalProperty(elm, path, values, new WriteCallback<T>(){

            @Override
            public void setValue(Element element, T value) {
                try {
                    value.toXML(element);
                }
                catch (Exception e) {
                    LoggerFactory.getLogger(PeriodicalPropertyHelper.class).warn(String.format("failed serializing value %s", value));
                }
                element.setAttribute("class", value.getClass().getName());
            }
        });
    }

    public static <T> T getValue(List<PeriodicalValue<T>> values) {
        if (values.isEmpty()) {
            return null;
        }
        for (PeriodicalValue<T> value : values) {
            if (value.getBeginDate() != null || value.getEndDate() != null) continue;
            return value.getValue();
        }
        Date currentDate = new Date();
        for (PeriodicalValue<T> value : values) {
            if (value.getBeginDate() != null && value.getBeginDate().after(currentDate) || value.getEndDate() != null && value.getEndDate().before(currentDate)) continue;
            return value.getValue();
        }
        return null;
    }

    public static <T> void setValue(List<PeriodicalValue<T>> values, T value) {
        values.clear();
        if (value == null) {
            return;
        }
        PeriodicalValue<T> hv = new PeriodicalValue<T>();
        hv.setValue(value);
        values.add(hv);
    }

    private static <T> void readPeriodicalObject(Element elm, String path, List<PeriodicalValue<T>> values, ReadCallback<T> callback) {
        values.clear();
        if (elm == null) {
            return;
        }
        Element item = XmlUtil.getElement(elm, path);
        if (item == null) {
            return;
        }
        Element[] elements = XmlUtil.getElements(item, "item");
        if (elements.length == 0) {
            T val = callback.getValue(item);
            if (val != null) {
                PeriodicalValue<T> hv = new PeriodicalValue<T>();
                hv.setValue(val);
                values.add(hv);
            }
            return;
        }
        for (Element element : elements) {
            PeriodicalValue<T> hv = new PeriodicalValue<T>();
            hv.setUid(element.getAttribute("uid"));
            hv.setBeginDate(XHelper.readDate(element, "beginDate"));
            hv.setEndDate(XHelper.readDate(element, "endDate"));
            hv.setValue(callback.getValue(XmlUtil.getElement(element, "value")));
            values.add(hv);
        }
    }

    private static <T> void writePeriodicalProperty(Element elm, String path, List<PeriodicalValue<T>> values, WriteCallback<T> callback) {
        if (values.isEmpty()) {
            return;
        }
        Element element = XmlUtil.addElement(elm, path);
        for (PeriodicalValue<T> value : values) {
            if (value.getValue() == null) continue;
            Element item = XmlUtil.addElement(element, "item");
            item.setAttribute("uid", value.getUid());
            callback.setValue(XmlUtil.addElement(item, "value"), value.getValue());
            XHelper.writeDate(item, "beginDate", value.getBeginDate());
            XHelper.writeDate(item, "endDate", value.getEndDate());
        }
    }

    private PeriodicalPropertyHelper() {
    }

    public static interface WriteCallback<T> {
        public void setValue(Element var1, T var2);
    }

    public static interface ReadCallback<T> {
        public T getValue(Element var1);
    }
}

